/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.utils;

import cn.trust.sign.client.utils.EncUtils;
import cn.trust.sign.client.utils.FastBase64;
import cn.trust.sign.model.Digest;
import cn.trust.sign.model.GenTrust;
import com.dovtrust.client.exceptions.ParameterOutRangeException;
import com.dovtrust.client.log.LoggerUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.PublicKey;
import java.util.HashSet;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonUtils {
    public static void writeLog(String message) {
        LoggerUtil.client_error((String)message);
    }

    public static GenTrust getGenTrust(String jsonBean, byte[] key, String base64Cert) throws UnsupportedEncodingException {
        GenTrust root = new GenTrust();
        root.setVersion("4.4");
        PublicKey publicKey = EncUtils.getPublicKey(base64Cert);
        root.setSessionKey(EncUtils.getEncKey(key, publicKey));
        String encData = EncUtils.getEncData(jsonBean, key);
        root.setSignReq(encData);
        String str = EncUtils.crcDigestHexStr(encData.getBytes());
        Digest digest = new Digest();
        digest.setAlg("CRC32");
        digest.setValue(str);
        root.setSignReqDig(digest);
        return root;
    }

    public static Object getValue(String jsonBean, String key) throws ParseException {
        JSONObject jsonObj = (JSONObject)JSONValue.parseWithException((String)jsonBean);
        return jsonObj.get((Object)key);
    }

    public static String getStringValue(Object obj) {
        String result = "";
        if (obj != null) {
            result = String.valueOf(obj);
        }
        return result;
    }

    public static byte[] getByteValue(Object obj) {
        byte[] result = null;
        if (obj != null) {
            result = FastBase64.decode(JsonUtils.getStringValue(obj));
        }
        return result;
    }

    public static int getIntValue(Object obj) {
        int result = 0;
        if (obj != null) {
            result = Integer.valueOf(JsonUtils.getStringValue(obj));
        }
        return result;
    }

    public static float getFloatValue(Object obj) {
        float result = 0.0f;
        if (obj != null) {
            result = Float.valueOf(JsonUtils.getStringValue(obj)).floatValue();
        }
        return result;
    }

    public static String objToJson(Object object) {
        String jsonBean = JSONValue.toJSONString((Object)object);
        return jsonBean;
    }

    public static Object jsonToObj(String json) throws ParseException {
        Object obj = new JSONParser().parse(json);
        return obj;
    }

    public static String getEncData(String jsonBean, byte[] key, String base64Cert) throws UnsupportedEncodingException {
        GenTrust genTrust = JsonUtils.getGenTrust(jsonBean, key, base64Cert);
        String encDate = JsonUtils.objToJson(genTrust);
        return encDate;
    }

    public static String parametersToJson(String ... args) throws ParameterOutRangeException {
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("pdf");
        keySet.add("extInfo");
        keySet.add("imageContent");
        keySet.add("signAlpha");
        keySet.add("imageWidth");
        keySet.add("imageHeight");
        keySet.add("cert");
        keySet.add("imageType");
        keySet.add("prikey");
        keySet.add("pwd");
        keySet.add("originalData");
        keySet.add("keyword");
        keySet.add("startPage");
        keySet.add("kwIndex");
        keySet.add("pos");
        keySet.add("offset");
        keySet.add("xoffset");
        keySet.add("yoffset");
        keySet.add("signatureAnnotation");
        keySet.add("signatureNumber");
        keySet.add("annotationPage");
        keySet.add("signPage");
        keySet.add("signPosL");
        keySet.add("signPosB");
        keySet.add("signPosR");
        keySet.add("signPosT");
        keySet.add("ruleNo");
        keySet.add("version");
        keySet.add("code");
        keySet.add("data");
        keySet.add("savePath");
        keySet.add("type");
        keySet.add("text");
        keySet.add("imageType");
        keySet.add("fontColor");
        keySet.add("fontFamily");
        keySet.add("fontSize");
        keySet.add("isBold");
        keySet.add("sealCenter");
        keySet.add("sealType");
        keySet.add("sealWidth");
        keySet.add("snapshotJson");
        keySet.add("uName");
        keySet.add("credNumber");
        keySet.add("credType");
        keySet.add("channel");
        keySet.add("image");
        keySet.add("format");
        keySet.add("fPImage");
        keySet.add("fPFormat");
        keySet.add("image");
        keySet.add("fpImage");
        keySet.add("userName");
        keySet.add("idNumber");
        keySet.add("channelId");
        keySet.add("sealEinNumber");
        String json = " { ";
        int i = 0;
        while (i < args.length) {
            if (!keySet.add(args[i])) {
                if (args[i + 1] != null && !args[i + 1].trim().equals("")) {
                    json = "snapshotJson".equals(args[i]) ? (i == args.length - 2 ? String.valueOf(json) + "\"" + args[i] + "\"" + " :" + args[i + 1] : String.valueOf(json) + "\"" + args[i] + "\"" + " : " + args[i + 1] + ",") : (i == args.length - 2 ? String.valueOf(json) + "\"" + args[i] + "\"" + " :  \"" + args[i + 1] + "\"" : String.valueOf(json) + "\"" + args[i] + "\"" + " : \"" + args[i + 1] + "\",");
                }
            } else {
                String result = "\u53c2\u6570\u540d\u79f0\u4e0d\u5b58\ufffd?700030";
                JsonUtils.writeLog(result);
                throw new ParameterOutRangeException(result);
            }
            i += 2;
        }
        json = String.valueOf(json) + " } ";
        return json;
    }

    public static String toJsonString(Object object) {
        StringBuffer sb = new StringBuffer("{");
        Field[] fields = object.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].setAccessible(true);
            try {
                Object obj = fields[i].get(object);
                if (obj != null && !"serialVersionUID".equals(fields[i].getName())) {
                    sb.append("\"" + fields[i].getName() + "\":");
                    if (fields[i].getType().getSimpleName().equals("String") && !fields[i].getName().equals("Snapshot")) {
                        sb.append("\"" + obj + "\"");
                    } else {
                        sb.append(obj);
                    }
                    sb.append(",");
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
        int len = sb.length();
        return String.valueOf(sb.substring(0, len - 1)) + "}";
    }
}

