<!DOCTYPE HTML>
<%@ page language="java" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"%>
<head>
<jsp:include page="common.jsp"></jsp:include>
<link rel="stylesheet"
	href="https://a.amap.com/jsapi_demos/static/demo-center/css/demo-center.css" />

</head>
<style>
.info {
	padding: .75rem 1.25rem;
	margin-bottom: 1rem;
	border-radius: .25rem;
	position: fixed;
	top: 1rem;
	background-color: white;
	width: auto;
	min-width: 22rem;
	border-width: 0;
	right: 10rem;
	box-shadow: 0 2px 6px 0 rgba(114, 124, 245, .5);
}

.amap-icon img,.amap-marker-content img {
	width: 25px;
	height: 34px;
}

.marker {
	position: absolute;
	top: -20px;
	right: -118px;
	color: #fff;
	padding: 4px 10px;
	box-shadow: 1px 1px 1px rgba(10, 10, 10, .2);
	white-space: nowrap;
	font-size: 12px;
	font-family: "";
	background-color: #25A5F7;
	border-radius: 3px;
}
</style>
<body>
	<div class="easyui-panel" data-options="fit:true,border:false">
		<input type="hidden" name="txtlatitude" type="text" id="txtlatitude" />
		<input type="hidden" name="txtLongitude" type="text" id="txtLongitude" />
		<input type="hidden" name="txtAddress" type="text" id="txtAddress" />
		<input type="hidden" name="txtgeoAry" type="text" id="txtgeoAry" />
		<input type="hidden" name="txtPositions" type="text" id="txtPositions" />
		<center>
			<div style="width: 660px; height: 360px; border: #ccc solid 1px;"
				id="dituContent"></div>
			<div class="info">
				<div class="input-item">
					<div class="input-item-prepend">
						<span class="input-item-text" style="width: 8rem;">请输入关键字</span>
					</div>
					<input id='tipinput' type="text">
				</div>
			</div>
		</center>
	</div>
	<script type="text/javascript">
		window._AMapSecurityConfig = {
			securityJsCode: "9c73b8f7466ff8fd888b551441ccd8ab",
		};
	</script>
	<script type="text/javascript"
		src="https://webapi.amap.com/maps?v=1.4.15&key=9437f623a59899584339c9d50cbcdb83&plugin=AMap.Autocomplete,AMap.PlaceSearch,AMap.Scale,AMap.ToolBar"></script>
	<!-- 工具栏 -->
	<script type="text/javascript">
		var ctx = "${ctx}";//全局上下文变量
		var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
		var map;
		var marker;
		var geolocation;
		var positions="";
		$(function() {
			initMap();//创建和初始化地图
		});
		//创建和初始化地图函数：
		function initMap() {
			map = new AMap.Map('dituContent', {
				resizeEnable : true
			});
			window.map = map;//将map变量存储在全局
			map.on('click', clickFun);
			AMap.plugin([ "AMap.Geolocation" ], function() {
				geolocation = new AMap.Geolocation();
				/* map.addControl(geolocation); */
				geolocation.getCurrentPosition(function(status, result) {
					var currentLat = result.position.lat;//纬度
					var currentLng = result.position.lng;//经度 
					map.setZoom(15);
					map.setCenter([ currentLng, currentLat ]);
				});
			});
			var auto = new AMap.Autocomplete({
				input : "tipinput"
			});
			
			var scale = new AMap.Scale({
				visible : true
			}), toolBar = new AMap.ToolBar({
				visible : true
			});
			
			map.addControl(scale);
			map.addControl(toolBar);
			toolBar.hideDirection();
			var placeSearch = new AMap.PlaceSearch({
				map : map
			});
			AMap.event.addListener(auto, "select", function(e) {
				placeSearch.setCity(e.poi.adcode);
				placeSearch.search(e.poi.name, function(status, result) {
					/* placeSearch.render.markerList.clear(); */
					document.getElementById("txtLongitude").value = result.poiList.pois[0].location.lng;
					document.getElementById("txtlatitude").value = result.poiList.pois[0].location.lat;
					document.getElementById("txtAddress").value = result.poiList.pois[0].address;
				});
			});
		}

		function removeMarkers() {
			map.remove(markers);
		}
		function clickFun(e) {
			document.getElementById("txtLongitude").value = e.lnglat.getLng();
			document.getElementById("txtlatitude").value = e.lnglat.getLat();
			setAddress();
			setMarker();
		}
		function setAddress() {
			var currentLat = document.getElementById("txtlatitude").value;//纬度
			var currentLng = document.getElementById("txtLongitude").value;//经度 
			AMap
					.service(
							'AMap.Geocoder',
							function() {//回调函数
								//实例化Geocoder
								geocoder = new AMap.Geocoder({
									city : ""//城市，默认：“全国”
								});
								var lnglatXY = [ currentLng, currentLat ];//地图上所标点的坐标
								geocoder
										.getAddress(
												lnglatXY,
												function(status, result) {
													if (status === 'complete'
															&& result.info === 'OK') {
														var txtAddress = result.regeocode.addressComponent.city
																+ result.regeocode.addressComponent.district
																+ result.regeocode.addressComponent.township
																+ result.regeocode.addressComponent.street
																+ result.regeocode.addressComponent.streetNumber;
														document
																.getElementById("txtAddress").value = txtAddress;
													}

												});
							});
		}
		function setMarker() {
			//clearMarker();
			var currentLat = document.getElementById("txtlatitude").value;//纬度
			var currentLng = document.getElementById("txtLongitude").value;//经度 
			marker = new AMap.Marker(
					{
						icon : "//a.amap.com/jsapi_demos/static/demo-center/icons/poi-marker-red.png",
						position : [ currentLng, currentLat ],
						draggable : true
					});
			marker.setMap(map);
			positions = positions +","+"["+"'"+currentLat+"'"+","+"'"+currentLng+"'"+"]";
			document.getElementById("txtPositions").value = positions;
		}
		function clearMarker() {
			if (marker) {
				marker.setMap(null);
				marker = null;
			}
		}
		function initPoint() {
			var currentLng = document.getElementById("txtLongitude").value;
			var currentLat = document.getElementById("txtlatitude").value;
			setAddress();
			setMarker();
			map.setZoom(15);
			map.setCenter([ currentLng, currentLat ]);
		}
	</script>

	<!-- <script src="http://api.map.baidu.com/location/ip?qt=loc&coor=bd09ll&ak=LKSRVjxwRLjKloFasK8sf7nPfs6X2lk5&timeout=10000&callback=initMap"></script> -->
</body>