var basegrid=$('#ReportBase_datagrid');
$(function(){
	bindEnterKey("#searchReportBase",searchReportBase)
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
//		fit:true,
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		toolbar:"#ReportBase_datagrid_tb",
	    url:ctx+'/ReportBase/pageReportBase',
	    columns:[[
	    {
			field:'opt',title:'预览',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openReportDetail(\''+row.REPORT_CODE+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
//	    {field:'ID',title:'id',width:100,align:'center',halign:'center'},
	    {field:'REPORT_NAME',title:'名称',width:120,align:'left',halign:'left'},
	    {field:'REPORT_CODE',title:'编码',width:120,align:'left',halign:'left'},
	    {field:'REPORT_TYPE_TEXT_',title:'报表类型',width:60,align:'center',halign:'center'},
	   // {field:'SQL_SCRIPT',title:'sql脚本',width:200,align:'center',halign:'center'},
//	    {field:'REPORT_SCRIPT',title:'页面js脚本增强',width:100,align:'center',halign:'center'},
	    {field:'DATA_OPTIONS',title:'列表配置',width:200,align:'center',halign:'center'},
	    {field:'CREATE_BY_TEXT_',title:'创建人',width:80,align:'center',halign:'center'},
	    {field:'CREATE_TIME',title:'创建时间',width:80,align:'center',halign:'center'}/*,
	    {field:'MODIFY_ACCOUNT',title:'修改人',width:80,align:'center',halign:'center'},
	    {field:'MODIFY_TIME',title:'修改时间',width:80,align:'center',halign:'center'}*/
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
//			openReportDetail(row.REPORT_CODE);
	    	editReportBaseColumn();
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('ReportBase_datagrid',"报表信息");   
	        }    
	    }]   
	});
}
//查看表单明细
function openReportDetail(code) {
	// 定义非法字符数组
	var illegalChars = ['or', 'and', '--', "'"];
	// 判断字符串中是否包含非法字符
	for (var i = 0; i < illegalChars.length; i++) {
		if (code.includes(illegalChars[i])) {
			// 字符串中包含非法字符，给出相应的提示或处理逻辑
			if (illegalChars[i] === '--') {
				alertWarn("报告编码包含 -- 非法字符！");
			} else {
				alertWarn("报告编码包含 " + illegalChars[i] + " 非法字符！");
			}
			return;
		}
	}

	// 字符串中不包含非法字符，执行打开报告详情的操作
	window.open(ctx + "/ReportBase/genReport?reportCode=" + code);
}

//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchReportBase(){
	basegrid.datagrid('load',{
		search:$("#searchReportBase").val()
	});
}

//增加记录
function addReportBase() {
	openSaveDialog({
		title:"添加记录",
//		maximized : true,
		width:700,
		height:500,
//		contenturl:"/GenForm/form?formcode=ReportBase_Form",
//		submiturl:"/ReportBase/saveReportBase?formcode=ReportBase_Form",
		contenturl:"/view/report/ReportBaseform",
		submiturl:"/ReportBase/saveReportBase",
		callback:reloadGrid
	});
	
}
function editReportBaseColumn(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		if(row.REPORT_TYPE=='1'){
			openSaveDialog({
				title : "列表编辑",
				maximized : true,
				submiturl:"/ReportBase/saveReportBase?formcode=ReportBase",
				contenturl:"/GenForm/form?formcode=ReportBase&id=" + id,
	//			submiturl : "/ReportBaseColumn/saveReportBaseColumn",
	//			onload : "/ReportBaseColumn/findReportBaseColumn?id=" + id,
				callback : reloadGrid,
		        onsubmit: function (params) {
		            if (endGridEdit()) {
		                var rows = $ReportBaseColumn_datagrid.datagrid("getChanges");
		                params.rows = JSON.stringify(rows);
		                return true;
		            }
		            return false;
		        }
			});
		}else{
			openSaveDialog({
				title : "列表编辑",
				maximized : true,
				submiturl:"/ReportBase/saveReportBase?formcode=ReportBase",
				contenturl:"/ReportBase/editReportBase?id=" + id,
	//			submiturl : "/ReportBaseColumn/saveReportBaseColumn",
	//			onload : "/ReportBaseColumn/findReportBaseColumn?id=" + id,
				callback : reloadGrid,
		        onsubmit: function (params) {
		        	if($("#reportType")=='2'){
						debugger;
			        	if (endGridEdit()) {
			                var rows = $ReportBaseChart_datagrid.datagrid("getChanges");
			                params.rows = JSON.stringify(rows);
			                return true;
			            }
		        	}else{
		        		debugger;
		        		$("#sqlScript").val($("#my").html())
		        	}
		            return true;
		        }
			});
		}
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}
//修改记录
function editReportBase() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title : "修改记录",
			width:700,
			height:500,
	//		contenturl:"/GenForm/form?formcode=ReportBase_Form",
	//		submiturl:"/ReportBase/saveReportBase?formcode=ReportBase_Form",
			contenturl:"/view/report/ReportBaseform",
			submiturl:"/ReportBase/saveReportBase",
			onload : "/ReportBase/findReportBase?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}
function copyReportBase(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id =row.ID;
		alertConfirmYes('您是否要拷贝当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/ReportBase/copyReportBase",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要复制的数据信息');
	}
}
//删除记录
function delReportBase() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/ReportBase/delReportBase",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}

function exportReportBas() {
	openChooseDialog({
		title: "选择自定义报表",
		contenturl: "/view/sys/ReportBasSelect",
		width: 750,
		height: 450,
		okhandler: function () {
			var rows = $('#chooseReportBasSelectgrid').datagrid('getRows');
			if (rows.length > 0) {
				var ids = [];
				for (var i = 0; i < rows.length; i++) {
					ids.push(rows[i].id);
				}
				ids = ids.join(";");
				window.open(ctx + "/ReportBase/exportReportBasXml?ids=" + ids)
			} else {
				alertWarn("请先选择要导出的字典信息");
			}
		}
	})

}

function importReportBas() {
	openSaveDialog({
		title: "导入自定义报表",
		submitbtn: "commonImport",
		contenturl: "/view/common/commonImport",
		onsubmit: function (params) {
			var fileText = $("#file").filebox("getText");
			var fileType = fileText.substring(fileText.lastIndexOf("."), fileText.length);
			if (fileType != ".json" && fileType != ".JSON") {
				alertWarn("请选择json格式的附件！");
				return false;
			}
			return true;
		},
		submiturl: "/ReportBase/importReportBas",
		callback: function (result) {
			if (result.success) {
				alertInfo(result.msg);
			} else {
				alertError(result.msg);
			}
		}
	});
}