var basegrid=$('#PubContract_datagrid');
var formCode="";
if(type=='WT'){
	formCode="PubContract_WT"
}else if(type=='DB'){
	formCode="PubContract_DB"
}else{
	formCode="PubContract_QT"
}

$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchPubContract();
			}
		}
	});
	initGrid();
});

function initGrid(){
	var url=ctx+'/PubContract/pagePubContract';
	if(type=='WT'){
		url+="?type=1"
	}else if(type=='DB'){
		url+="?type=2"
	}else{
		url+="?type=3"
	}
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
	//	fitColumns:true,
		pagination:true,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		toolbar:"#PubContract_datagrid_tb",
	    url:url,
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
//	    {field:'id',title:'ID',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'fundType',title:'资金类型',width:100,align:'center',halign:'center',sortable:true},
	    {field:'contractTypeName',title:'合同类型',width:100,align:'center',halign:'center',sortable:true},
	    {field:'contractCode',title:'合同编码',width:100,align:'center',halign:'center',sortable:true},
	    {field:'contractName',title:'合同名称',width:200,align:'center',halign:'center',sortable:true},
	    {field:'ourCompanyText',title:'我方公司',width:150,align:'center',halign:'center',sortable:true},
	    {field:'contractOwnerText',title:'合同责任人',width:150,align:'center',halign:'center',sortable:true},
	    {field:'contractDeptText',title:'责任部门',width:150,align:'center',halign:'center',sortable:true},
	    {field:'otherCompanyText',title:'对方公司',width:150,align:'center',halign:'center',sortable:true},
//	    {field:'otherCompanys',title:'其他相对方',width:150,align:'center',halign:'center',sortable:true},
	    {field:'contractLabel',title:'合同标签',width:150,align:'center',halign:'center',sortable:true},
	    {field:'isAddContractText',title:'是否补充合同',width:150,align:'center',halign:'center',sortable:true},
//	    {field:'mainContractId',title:'关联合同',width:150,align:'center',halign:'center',sortable:true},
	    {field:'contractMoney',title:'合同金额(元)',width:150,align:'center',halign:'center',sortable:true},
//	    {field:'orgId',title:'创建单位',width:150,align:'center',halign:'center',sortable:true},
	    {field:'startDate',title:'开始日期',width:150,align:'center',halign:'center',sortable:true},
	    {field:'endDate',title:'结束日期',width:150,align:'center',halign:'center',sortable:true},
	    // {field:'payProvision',title:'付款条款',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'remark',title:'备注',width:100,align:'center',halign:'center',sortable:true},
        // {field:'type',title:'类别委托/担保/其他劳动合同',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'processinstid',title:'流程实例ID',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatusText',title:'审批状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubContract_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode="+formCode+"&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchPubContract(){
	basegrid.datagrid('load',{
		type:type,
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
		search:$("#searchPubContract").val()
	});
}

//增加记录
function addPubContract() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode="+formCode,
		submiturl:"/PubContract/savePubContract?formcode="+formCode,
		callback:reloadGrid
	});
	
}

//修改记录
function editPubContract() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl: "/GenForm/form?formcode="+formCode+"&id=" + id,
			submiturl:"/PubContract/savePubContract?formcode="+formCode,
			//onload : "/PubContract/findPubContract?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delPubContract() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubContract/delPubContract",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.id,
			formCode:formCode,
			callback:reloadGrid
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}