var basegrid=$('#BasSysLoginlog_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasSysLoginlog_datagrid_tb",
	    url:ctx+'/BasSysLoginlog/pageBasSysLoginlog',
	    columns:[[
/*	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.loginId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},*/
	   // {field:'loginId',title:'loginId',width:100,align:'center',halign:'center'},
	  //  {field:'accountId',title:'accountId',width:100,align:'center',halign:'center'},
	    {field:'empId',title:'empId',hidden:true},
	    {field:'orgName',title:'单位名称',width:100,align:'center',halign:'center'},
	    {field:'empName',title:'员工名称',width:100,align:'center',halign:'center'},
	    {field:'loginIp',title:'登录IP',width:100,align:'center',halign:'center'},
	    {field:'loginTime',title:'登录时间',width:100,align:'center',halign:'center'},
	   // {field:'loginType',title:'登录类型',width:100,align:'center',halign:'center'},
	  //  {field:'logoutIp',title:'登出IP',width:100,align:'center',halign:'center'},
	    {field:'logoutTime',title:'登出时间',width:100,align:'center',halign:'center'},
	    //{field:'sessionId',title:'sessionId',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.loginId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasSysLoginlog_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSysLoginlog&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasSysLoginlog(){
	basegrid.datagrid('load',{
		search:$("#searchBasSysLoginlog").val()
	});
}

//增加记录
function addBasSysLoginlog() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSysLoginlog",
		submiturl:"/BasSysLoginlog/saveBasSysLoginlog?formcode=BasSysLoginlog",
//		contenturl:"/view/bas/BasSysLoginlog",
//		submiturl:"/BasSysLoginlog/saveBasSysLoginlog",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasSysLoginlog() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.loginId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasSysLoginlog&id=" + id,
			submiturl:"/BasSysLoginlog/saveBasSysLoginlog?formcode=BasSysLoginlog",
//			contenturl : "/view/bas/BasSysLoginlog",
//			submiturl : "/BasSysLoginlog/saveBasSysLoginlog",
//			onload : "/BasSysLoginlog/findBasSysLoginlog?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasSysLoginlog() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.loginId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasSysLoginlog/delBasSysLoginlog",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
