var basegrid=$('#GenFormPanel_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GenFormPanel_datagrid_tb",
	    url:ctx+'/GenFormPanel/pageGenFormPanel',
	    columns:[[
	    {field:'DISPLAY_NO',title:'显示顺序'},
	    {field:'PANEL_ID',title:'面板ID'},
	    {field:'FORM_ID',title:'表单ID'},
	    {field:'PANEL_TITLE',title:'面板标题'},
	    {field:'PANEL_TYPE',hidden:true},
	    {field:'PANEL_TYPE_TEXT_',title:'面板类型'},
	    {field:'PANEL_URL',title:'面板url'},
	    {field:'FORM_COLNUM',title:'表单布局列数'}
	    ]]
	});

}

function reloadGrid(){
	basegrid.datagrid('reload');
}

function searchGenFormPanel(){
	basegrid.datagrid('load',{
		search:$("#searchGenFormPanel").val()
	});
}

//增加数据字典
function addGenFormPanel() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/gen/GenFormPanelform",
		submiturl:"/GenFormPanel/saveGenFormPanel",
		callback:reloadGrid
	});
	
}

//修改数据字典
function editGenFormPanel() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.PANEL_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/gen/GenFormPanelform",
			submiturl : "/GenFormPanel/saveGenFormPanel",
			onload : "/GenFormPanel/findGenFormPanel?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除数据字典
function delGenFormPanel() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.PANEL_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GenFormPanel/delGenFormPanel",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
