function initWfCommonphrase(tagargetId){
	if($("#usuallyLang_"+tagargetId).length>0){
		return;
	}
	const  str = `<div id="usuallyLang_${tagargetId}"  class="usuallyLang">
							<el-popover
							  placement="right"
							   v-model="showPopover"
							  width="350"
							  popper-class="usuallyLang_${tagargetId}"
							  @show="reloadBtn()"
							  trigger="click">
							  <el-table :data="gridData" cell-class-name="usuallyLangtd usuallyLangtd${tagargetId}" max-height="200"
								 @row-click="handleRowClick" :show-header="showHeader" size="small">
								<el-table-column width="300" property="commonPhrase" label="常用语" show-overflow-tooltip="true"></el-table-column>
								<el-table-column width="1"  property="opt" label="操作">
								<template slot-scope="scope">
						         <el-button-group   class="usuallyLangbtn" style="display: none;">
						               <el-button
						                 @click.stop.prevent="editRow(scope.$index,gridData)"
						                 icon="el-icon-edit"
						                 size="mini">
						               </el-button>
						               <el-button
						                 @click.stop.prevent="deleteRow(scope.$index,gridData)"
						                 icon="el-icon-circle-close gray"
						                 size="mini">
						               </el-button>
						             </el-button-group>
						               </template>
								</el-table-column>
							  </el-table>
							  <a slot="reference" class="blue" style="font-size:12px;text-decoration: none;">常用意见
						  		<span class="iconfont icon-chatmsg " style="font-size:12px;"></span></a>
							<div style="margin:auto;text-align:center;padding:10px;">
								<el-button-group>
								  <el-button type="" icon="el-icon-circle-plus-outline" size="mini" @click="add()">增加</el-button>
								</el-button-group>
								&emsp;
								<el-button-group>
								  <el-button type="" icon="el-icon-edit" size="mini"  @click="edit()">修改</el-button>
								</el-button-group>
							</div>
						</el-popover>
						</div>`

	$("#"+tagargetId).before(str);
	new Vue({
		el:'#usuallyLang_'+tagargetId,
		data() {
			return {
				showPopover:false,
				showHeader:false,
				editing : false ,
				gridData: [{
					commonPhrase: '同意',
				}, {
					commonPhrase: '反对',
				}]
			}
		},
		mounted:function(){
			this.loadData();
		},
		methods:{
			loadData:function(){
				const that = this;
				$.ajax({
					url:ctx+"/WfCommonphrase/findByAccountOrCommon",
					type:"POST",
					async:false,
					success:function(data){
						if(data!=null){
							that.gridData = data;
							$('body').on('mouseover', '.el-tooltip', function() {
								setTimeout(()=>{
									$(".el-tooltip__popper").css("zIndex",$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001)
								},100)
							});
							$(".el-tooltip").mouseover(function(){

							})
						}
					},
					error:function(){
					},
					dataType:"json"
				})
			},
			handleRowClick(row) {
				$("#"+tagargetId).textbox("setValue",row.commonPhrase);
				this.showPopover=false;
			},
			editRow:function(index, rows) {
				const that = this;
				var id = rows[index].phraseId;
				openSaveDialog({
					title : "修改记录",
					maximized : false,
					width:600,
					height:300,
					contenturl:"/GenForm/form?formcode=WfCommonphrase&id=" + id,
					submiturl:"/WfCommonphrase/saveWfCommonphrase?formcode=WfCommonphrase",
					callback : function(){
						that.loadData();
						that.reloadBtn();
					}
				});
			},
			deleteRow:function(index, rows) {
				alertConfirmYes('您是否要删除常用语【'+rows[index].commonPhrase+'】？', function(r) {
					if (r) {
						$.ajax({
							url : ctx+"/WfCommonphrase/delWfCommonphrase",
							data : {
								id : rows[index].phraseId
							},
							dataType : 'json',
							success : function(result) {
								if (result.success) {
									rows.splice(index, 1);
									alertInfo(result.msg);
									that.reloadBtn();
								}else{
									alertError(result.msg);
								}
							}
						});
					}
				});
			},
			add:function(){
				const that = this;
				$.ajax({
					url : ctx+"/WfCommonphrase/getMaxDisplayNo",
					dataType : 'json',
					success : function(result) {
						that.reloadBtn();
						that.showPopover=false;
						if (result.success) {
							openSaveDialog({
								title:"添加记录",
								width:600,
								height:300,
								contenturl:"/GenForm/form?formcode=WfCommonphrase",
								submiturl:"/WfCommonphrase/saveWfCommonphrase?formcode=WfCommonphrase",
								callback:function(){
									that.loadData();
								},
								onload : function (){
									$('#displayNo').numberbox('setValue',result.o);
								}
							});
						}else{
							alertError(result.msg);
						}
					}
				});
			},
			edit:function(){
				this.editing=!this.editing;
				this.reloadBtn();
			},
			reloadBtn:function(){
				console.log($(".usuallyLang_"+tagargetId))

				setTimeout(()=>{
					$(".usuallyLangtd"+tagargetId).closest("table").find("col").eq(0).attr("width",this.editing?200:300);
					$(".usuallyLangtd"+tagargetId).closest("table").find("col").eq(1).attr("width",this.editing?110:1);
					$(".usuallyLangtd"+tagargetId).closest("table").find("tr").find("td:first").width(this.editing?200:300);
					$(".usuallyLangtd"+tagargetId).closest("table").find("tr").find("td:first").children().width(this.editing?200:300);
					this.editing?$(".usuallyLangbtn").show():$(".usuallyLangbtn").hide();
					$(".usuallyLang_"+tagargetId).css("zIndex",$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001)
				},100)
			}
		}
	})
}