var basegrid = $('#GmInfoType_datagrid');
$(function() {
	initGrid();
	$("#orgIdVal").combobox({
		url : ctx + '/basorg/getComboOrg',
		editable : true,
		limitToList : true,
		panelHeight : 'auto',
		onChange:function(newV,oldV){
			searchGmInfoType();
		}
	});
});

function initGrid() {
	basegrid.datagrid({
		// fit : true,
		border : false,
		singleSelect : true,
		rownumbers : true,
		fitColumns : $("body").height()>700,
		pagination : true,
		cls:'md',
		height:getMixGridHeight(),
		toolbar : "#GmInfoType_datagrid_tb",
		url : ctx + '/GmInfoType/pageGmInfoType',
		columns : [ [
				{
					field : 'opt',
					title : '明细',
					width : 100,
					align : 'center',
					formatter : function(value, row, index) { // value表示字段的值,rowData行记录数据,index行索引
						return "<div onclick='openFormDetail("+index+")' class='icon-detail iconfont blue'>&nbsp;</div>";
					}
				}, {
					field : 'typeName',
					title : '栏目名称',
					width : 200,
					align : 'left',
					halign : 'center'
				}, {
					field : 'userName',
					title : '栏目管理员',
					width : 200,
					align : 'left',
					halign : 'center'
				}, {
					field : 'isApproval',
					hidden : true
				   }, {
				// 	field : 'isApprovalText',
				// 	title : '是否审批',
				// 	width : 80,
				// 	align : 'center',
				// 	halign : 'center'
				// }, {
				// 	field : 'flowCode',
				// 	title : '流程编码',
				// 	width : 100,
				// 	align : 'center',
				// 	halign : 'center'
				// },{
					field : 'remindDay',
					title : '新消息标示天数',
					width : 100,
					align : 'right',
					halign : 'center'
				}, {
					field : 'printSetup',
					hidden : true
				}, {
				// 	field : 'printSetupText',
				// 	title : '打印类型',
				// 	width : 100,
				// 	align : 'center',
				// 	halign : 'center'
				// }, {
					field : 'isReadingPeople',
					hidden : true
				}, {
					field : 'isReadingPeopleText',
					title : '允许查看阅读情况',
					width : 100,
					align : 'center',
					halign : 'center'
				},{
					field : 'isPushText',
					title : '是否消息推送',
					width : 100,
					align : 'center',
					halign : 'center'
				},{
					field : 'displayNo',
					title : '排序',
					width : 100,
					align : 'right',
					halign : 'center'
				}, {
					field : 'isReleasePeople',
					hidden : true
				}, {
				// 	field : 'isReleasePeopleText',
				// 	title : '显示发布人',
				// 	width : 120,
				// 	align : 'center',
				// 	halign : 'center'
				// }, {
				// 	field : 'topNumber',
				// 	title : '置顶数',
				// 	width : 80,
				// 	align : 'right',
				// 	halign : 'center'
				// }, {
					field : 'infoType',
					hidden : true
				}, {
				// 	field : 'infoTypeText',
				// 	title : '信息类型',
				// 	width : 100,
				// 	align : 'center',
				// 	halign : 'center'
				// }, {
					field : 'orgIdName',
					title : '栏目归属企业',
					width : 100,
					align : 'center',
					halign : 'center'}
				// }, {
				// 	field : 'systemPresetText',
				// 	title : '是否预置',
				// 	width : 80,
				// 	align : 'center',
				// 	halign : 'center'
				// }
				] ],
		onDblClickRow : function(index, row) {
			// 查看明细
			openFormDetail(index);
		}
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');
	pager.pagination({
		buttons : [ {
			iconCls : 'icon-page_excel',
			handler : function() {
				exportExcel('GmInfoType_datagrid', "信息栏目维护");
			}
		} ]
	});
}
// 查看表单明细
function openFormDetail(index) {
	basegrid.datagrid("selectRow",index);
	var row = basegrid.datagrid('getSelected');
	if (row){
		openDetailDialog({
			title : "查看记录",
			maximized : true,
			contenturl : "/GenForm/form?formcode=GmInfoType&isdetail=true&id=" + row.typeId,
			onload : function (){
				document.getElementById('userId_TEXT__span').innerText=row.userName;
			}
		});
	}
}
// 重新加载表格
function reloadGrid() {
	basegrid.datagrid('reload');
}
// 查询表格
function searchGmInfoType() {
	basegrid.datagrid('load', {
		//type : type,
		// search : $("#searchGmInfoType").val(),
		orgIdVal : $("#orgIdVal").combobox('getValue')
	});
}

// 增加记录
function addGmInfoType() {
	console.info($("#admin"));
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=GmInfoType",
		submiturl : "/GmInfoType/saveGmInfoType?formcode=GmInfoType",
		// contenturl:"/view/business/gm/GmInfoType",
		// submiturl:"/GmInfoType/saveGmInfoType",
		callback : reloadGrid,
		onload : function (){
			if ($("#admin").length == 0){
				$('#infoType').combobox({readonly:true});
				$('#orgId').combobox({readonly:true});
				$('#systemPreset').combobox({readonly:true});
			}
		}
	});

}

// 修改记录
function editGmInfoType() {
	var row = basegrid.datagrid('getSelected');
/*	if(row.infoType=='1'){
		alertInfo("集团统建项目不可修改");
		return false;
	}*/
	if (row) {
		var id = row.typeId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl : "/GenForm/form?formcode=GmInfoType&id=" + id,
			submiturl : "/GmInfoType/saveGmInfoType?formcode=GmInfoType",
			callback : reloadGrid,
			onload : function (){
				$('#userId').val(row.userId);
				$('#userId_TEXT_').textbox('setValue',row.userName);
				if ($("#admin").length == 0){
					$('#infoType').combobox({readonly:true});
					$('#orgId').combotree({readonly:true});
					$('#systemPreset').combobox({readonly:true});
				}
			}
		});		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

// 删除记录
function delGmInfoType() {
	var row = basegrid.datagrid('getSelected');
	// console.info(row);
	if (row) {
		if(row.infoType=='1'){
			alertWarn("集团统建栏目不可删除");
			return false;
		}
		if(row.systemPreset=='Y'){
			alertWarn("系统预置栏目不能删除");
			return false;
		}

		var id = row.typeId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				//判断该栏目是否被 空间所引用，如果引用则不能删除
				$.ajax({
					url:ctx+"/BasSpaceComponentAssociated/countInfoTypeIsOrNotUse",
					data:{
						id:id
					},
					dataType:"json",
					success:function(result){
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});
				/*$.ajax({
					url : ctx + "/GmInfoType/delGmInfoType",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						} else {
							alertError(result.msg);
						}
					}
				});*/
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
function chooseFlow(){
	openChooseDialog({
		title:'选择流程',
		contenturl:'/GenForm/allflow',
		width:400,
		height:500,
		okhandler:function(){
			var row=$("#allflow").datagrid('getSelected');
			if(row){
				$('#flowCode').textbox('setValue',row.value);
				return true;
			}else{
				 alertWarn("请选择流程");
				 return false;
			}
		}
	});
	
}