var basegrid=$('#BasSysCode_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasSysCode_datagrid_tb",
	    url:ctx+'/BasSysCode/pageBasSysCode',
	    columns:[[
	    {field:'SYS_CODE_ID',title:'',hidden:true},
	    {field:'GENCODE_DATE',title:'编码年份',width:100,align:'center',halign:'center'},
	    {field:'GENCODE',title:'编码代码',width:100,align:'center',halign:'center'},
	    {field:'GENCODE_PREFIX',title:'编码前缀',width:100,align:'center',halign:'center'},
	    {field:'GENCODE_SUFFIX',title:'编码后缀',width:100,align:'center',halign:'center'},
	    {field:'MEMO',title:'备注',width:100,align:'center',halign:'center'},
	    {field:'GENCODE_RULE',title:'编码生成规则',hidden:true},
	    {field:'GENCODE_RULE_TEXT_',title:'编码生成规则',width:100,align:'center',halign:'center'},
	    {field:'YEARCLEAR',title:'每年重置',width:100,align:'center',halign:'center',formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
							if (value) {
									if (value == 1) {
										return '是';
									} else {
										return '否';
									}
								} else {
									return '否';
								}
					}},
		{field:'MONTHCLEAR',title:'每月重置',width:100,align:'center',halign:'center',formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
			if (value) {
					if (value == 1) {
						return '是';
					} else {
						return '否';
					}
				} else {
					return '否';
				}
				}},
	    {field:'GENCODE_NO',title:'当前流水号',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow : editBasSysCode
	});
	basegrid.datagrid('doCellTip');
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasSysCode(){
	basegrid.datagrid('load',{
		search:$("#searchBasSysCode").val()
	});
}

//增加记录
function addBasSysCode() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/base/BasSysCodeform",
		submiturl:"/BasSysCode/saveBasSysCode",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasSysCode() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.SYS_CODE_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/base/BasSysCodeform",
			submiturl : "/BasSysCode/saveBasSysCode",
			onload : "/BasSysCode/findBasSysCode?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasSysCode() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.SYS_CODE_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasSysCode/delBasSysCode",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
