var basegrid=$('#BasSpaceComponentDefinition_datagrid');
$(function(){
	initGrid();
	bindEnterKey("#searchBasSpaceComponentDefinition",searchBasSpaceComponentDefinition);
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		toolbar:"#BasSpaceComponentDefinition_datagrid_tb",
	    url:ctx+'/BasSpaceComponentDefinition/pageBasSpaceComponentDefinition',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.componentId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'componentName',title:'组件名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'componentSourceText',title:'组件来源',width:100,align:'center',halign:'center',sortable:true},
	    {field:'showStyleText',title:'显示模式',width:100,align:'center',halign:'center',sortable:true},
	    {field:'showFormText',title:'展现形式',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isConfigText',title:'允许用户配置',width:100,align:'center',halign:'center',sortable:true},
	    {field:'view',title:'操作',width:50,align:'center',formatter: function(value,row,index){
	    		return '<a id="preview'+index+'" class="easyui-linkbutton"'
						+'href="javascript:void(0)" data-options="iconCls:\'icon-page-printer\',plain:true"'
						+'onclick="previewBasSpaceComponent(this)">预览</a>'
	    	}
	    }
	    
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.componentId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasSpaceComponentDefinition_datagrid',"组件信息");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSpaceComponentDefinition&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasSpaceComponentDefinition(){
	basegrid.datagrid('load',{
		search:$("#searchBasSpaceComponentDefinition").val()
	});
}

//增加记录
function addBasSpaceComponentDefinition() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasSpaceComponentDefinition&isdetail=false",
		submiturl:"/BasSpaceComponentDefinition/saveBasSpaceComponentDefinition?formcode=BasSpaceComponentDefinition",
		callback:reloadGrid,
		onsubmit:function(param){
			param.data = getBasSpaceComponentUserData();
			return true;
		}
	});
	
}

//修改记录
function editBasSpaceComponentDefinition() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.componentId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasSpaceComponentDefinition&isdetail=false&id=" + id,
			submiturl:"/BasSpaceComponentDefinition/saveBasSpaceComponentDefinition?formcode=BasSpaceComponentDefinition",
			callback : reloadGrid,
			onsubmit:function(param){
				param.data = getBasSpaceComponentUserData();
				return true;
			}
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasSpaceComponentDefinition() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.componentId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasSpaceComponentDefinition/delBasSpaceComponentDefinition",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}

//预览组件
function previewBasSpaceComponent(prame){
	var prviewId=prame.id;
	var index=prviewId.substr(7,prviewId.length-7);
	basegrid.datagrid('selectRow',index);
	var row=basegrid.datagrid('getSelected');
	var url = ctx+"/BasSpaceComponentDefinition/previewBasSpaceComponent?id=" +row.componentId;
	window.open(url);
}
