var basegrid=$('#BasRoles_datagrid');

$(function(){
	initGrid();
	bindEnterKey("#searchBasRoles",searchBasRoles);
});

function initGrid(){
	basegrid.datagrid({
		// fit:true,
		height:getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		toolbar:"#BasRoles_datagrid_tb",
	    url:ctx+'/BasRoles/pageBasRoles',
	    columns:[[
	    {field:'ROLE_ID',title:'角色ID',align:'center',halign:'center',hidden:true},
	    {field:'ROLE_CODE',title:'角色编码',align:'center',halign:'center',width:100},
	    {field:'ROLE_NAME',title:'角色名称',align:'center',halign:'center',width:100},
	    {field:'ROLE_TYPE',align:'center',halign:'center',hidden:true},
	    {field:'ROLE_TYPE_TEXT_',title:'角色类型',align:'center',halign:'center',width:100},
	    {field:'ROLE_ORIGIN_TEXT_',title:'角色来源',align:'center',halign:'center',width:100},
//	    {field:'ORG_ID',title:'组织机构ID'},
//	    {field:'IS_USE',title:'是否使用'},
	    {field:'DISPLAY_NO',title:'显示顺序',align:'center',halign:'center',width:100},
	    {field:'REMARK',title:'备注',align:'left',halign:'center',width:150}
	    ]]
	});
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasRoles_datagrid',"角色信息");   
	        }    
	    }]   
	}); 
}

function reloadGrid(){
	basegrid.datagrid('reload',{
		search:$("#searchBasRoles").val()
	});
}

function searchBasRoles(){
	reloadGrid();
}

//增加数据
function addBasRoles() {
	openSaveDialog({
		title:"添加角色",
		contenturl:"/view/base/BasRolesform",
		submiturl:"/BasRoles/saveBasRoles",
		onload:function(){
			$("#roleOrigin").val("2");//用户自定义
		},
		callback:reloadGrid
	});
	
}

//修改数据
function editBasRoles() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ROLE_ID;
		openSaveDialog({
			title : "修改角色",
			contenturl : "/view/base/BasRolesform",
			submiturl : "/BasRoles/saveBasRoles",
			onload : "/BasRoles/findBasRoles?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除数据
function delBasRoles() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id =row.ROLE_ID;
		if(row.ROLE_ORIGIN=='1'){
			alertWarn("暂时无法删除系统预置角色")
			return;
		}
		//查询当前角色下是否有用户
		$.ajax({
			url:ctx+"/BasRoles/getRoleAccountByRoleId",
			data : {
				id : id
			},
			dataType : 'json',
			success: function (result) {
				console.log(result);
				if(result.length>0){
					let names = "";
					result.forEach(x=>{
						names += x.accountName+",";
					})
					alertConfirmYes("该角色下存在用户："+names+"是否确认删除！",function (r){
						if(r){
							$.ajax({
								url : ctx+"/BasRoles/delBasRolesAndAccount",
								data : {
									id : id
								},
								dataType : 'json',
								success : function(result) {
									if (result.success) {
										basegrid.datagrid('reload');
										alertInfo(result.msg);
									}else{
										alertError(result.msg);
									}
								}
							});
						}
					})
				}else{
					alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
						if (r) {
							$.ajax({
								url : ctx+"/BasRoles/delBasRoles",
								data : {
									id : id
								},
								dataType : 'json',
								success : function(result) {
									if (result.success) {
										basegrid.datagrid('reload');
										alertInfo(result.msg);
									}else{
										alertError(result.msg);
									}
								}
							});
						}
					});
				}
			}
		})


	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
