var BasMessageTypeDataGrid=$('#BasMessageType_datagrid');
$(function(){
	bindEnterKey("#searchBasMessageType",searchBasMessageType)
	initBasMessageTypeGrid();
});

function initBasMessageTypeGrid(){
	BasMessageTypeDataGrid.datagrid({
		height:$("body").height()-172,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			// startDate:$('#sDate').datebox('getValue'),
			// endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#BasMessageType_datagrid_tb",
	    url:ctx+'/BasMessageType/pageBasMessageType',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasMessageTypeFormDetail('+row.typeId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'color',title:'颜色',width:40,align:'center',halign:'center',sortable:true,formatter:function(value){
	    	return "<div style='width:20px;height:20px;margin:auto;background-color:"+value+"'></div>";
	    }},
	    {field:'name',title:'名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'code',title:'编码',width:80,align:'center',halign:'center',sortable:true},
	    {field:'icon',title:'图标',width:80,align:'center',halign:'center',sortable:true},
//	    {field:'noticeType',title:'通知类型',width:100,align:'center',halign:'center',sortable:true},
	    {field:'enableText',title:'是否启用',width:100,align:'center',halign:'center',sortable:true},
	    {field:'displayNo',title:'排序',width:100,align:'center',halign:'center',sortable:true},
	    {field:'remark',title:'备注',width:200,align:'left',halign:'center',sortable:true},
	    // {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'typeId',title:'类型id',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasMessageTypeFormDetail(row.typeId);
	    }
	});
    BasMessageTypeDataGrid.datagrid('doCellTip');
    var pager = BasMessageTypeDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasMessageType_datagrid',"消息分类");   
	        }    
	    }]   
	});
}
//查看表单明细
function BasMessageTypeFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasMessageType&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasMessageType(){
	BasMessageTypeDataGrid.datagrid('reload');
}
//查询表格
function searchBasMessageType(){
	BasMessageTypeDataGrid.datagrid('load',{
		search:$("#searchBasMessageType").val(),
		// startDate:$('#sDate').datebox('getValue'),
		// endDate:$('#eDate').datebox('getValue'),
		// applyPerson: $("#applyPerson").textbox('getValue'),
		// applyDept :$("#applyDept").combobox('getValue')
	});
}

//增加记录
function addBasMessageType() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasMessageType",
		submiturl:"/BasMessageType/saveBasMessageType?formcode=BasMessageType",
		callback:reloadBasMessageType
	});
	
}

//修改记录
function editBasMessageType() {
	var row = BasMessageTypeDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.typeId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasMessageType&id=" + id,
			submiturl:"/BasMessageType/saveBasMessageType?formcode=BasMessageType",
			callback : reloadBasMessageType
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasMessageType() {
	var row = BasMessageTypeDataGrid.datagrid('getSelected');
	if (row) {
	var id =row.typeId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasMessageType/delBasMessageType",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasMessageTypeDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
