var basegrid=$('#BasBankDeposit_datagrid');
$(function(){
	$('#selOrgId').combobox({
		editable : false,
		value:orgId,
		onChange:function(newV,oldV){
			searchBasBankDeposit();
		}
	});
    initGrid();
});

function initGrid(){
    basegrid.datagrid({
        fit:true,
        border:false,
        singleSelect:true,
        rownumbers:true,
        fitColumns:true,
        pagination:true,
        toolbar:"#BasBankDeposit_datagrid_tb",
        url:ctx+'/BasBankAccount/pageBasBankDeposit',
		queryParams:{
			orgid:orgId
		},
        columns:[[
            {field:'bankAccountId',title:'银行账号ID',hidden:true},
            {field:'bankId',title:'银行ID',hidden:true},
            {field:'orgId',title:'财务组织',hidden:true},
            {field:'bankName',title:'银行名称',width:150,align:'left',halign:'center'},
            {field:'accountNo',title:'银行账号',width:200,align:'right',halign:'center'},
            {field:'initMoney',title:'期初结余',width:100,formatter:formatterMoney,align:'center',halign:'center'},
            {field:'monthSr',title:'本月累计收入',width:100,formatter:formatterMoney,align:'center',halign:'center'},
            {field:'monthZc',title:'本月累计支出',width:100,formatter:formatterMoney,align:'center',halign:'center'},
            {field:'overMoney',title:'期末账面余额',width:100,formatter:formatterMoney,align:'center',halign:'center'},
            {field:'thePeriodMoney',title:'银行对账单余额',width:100,formatter:formatterMoney,align:'center',halign:'center'}
        ]],
        onDblClickRow:function(index, row){
        }
    });
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({
        buttons:[{
            iconCls:'icon-page_excel',
            handler:function(){
                exportExcel('BasBankAccount_datagrid',"title");
            }
        }]
    });
}
//重新加载表格
function reloadGrid(){
    basegrid.datagrid('reload');
}
//查询表格
function searchBasBankDeposit(){
    basegrid.datagrid('load',{
        search:$("#searchBasBankDeposit").val(),
        orgid:$('#selOrgId').combobox('getValue')
    });
}