getRolesLevelByAccount
===
select  GROUP_CONCAT(r.ROLE_CODE SEPARATOR ',') code_list
from bas_roles_account t
left join bas_roles r on r.ROLE_ID = t.ROLE_ID
where r.IS_USE = 'Y'
and  t.ACCOUNT_ID = #accountId#

getRolesCodeByAccount
===

SELECT
	GROUP_CONCAT( w.code_list SEPARATOR ',' ) code_list,
	GROUP_CONCAT( w.codeAndInfo SEPARATOR ',' ) code_And_Info
FROM
	(
	SELECT
		r.ROLE_CODE code_list,
		(
		CASE
				WHEN r.ROLE_TYPE = 'dept' THEN
				concat( r.ROLE_CODE, t.DEPT_ID ) 
				WHEN r.ROLE_TYPE = 'org' THEN
				concat( r.ROLE_CODE, t.ORG_ID ) 
				else  r.ROLE_CODE
			END 
			) codeAndInfo 
		FROM
			bas_roles_account t
			LEFT JOIN bas_roles r ON r.ROLE_ID = t.ROLE_ID 
		WHERE
			r.IS_USE = 'Y' 
			AND t.ACCOUNT_ID = #accountId#
		) w 
	WHERE
		1 =1
		
getAllRoles
===
select  GROUP_CONCAT(t.ROLE_CODE SEPARATOR ',') all_roles
from bas_roles t
where t.IS_USE = 'Y'


findMyLeaderByOrgId
===
SELECT
	T.ACCOUNT_ID,
	GETACCOUNTNAME ( T.ACCOUNT_ID ) ACCOUNT_NAME ,
	h.PHOTO_VERSION_ID ,
	h.SEX,
	h.EMP_CODE,
	GETORGNAME(A.ORG_ID) org_Name,
	GETDEPTNAME(A.DEPT_ID) dept_name
FROM
	bas_roles_account T
	LEFT JOIN bas_roles r ON r.ROLE_ID = t.ROLE_ID 
	left join bas_emp_account a on a.ACCOUNT_ID = t.ACCOUNT_ID
	left join hr_emp h on h.hr_emp_id = a.hr_emp_id
WHERE 
	r.IS_USE = 'Y'  AND r.ROLE_TYPE = 'org'  AND r.ROLE_CODE = 'ORG_GSLD'
@if(!isEmpty(accountId)){
   and a.ACCOUNT_ID not in (#accountId#)
@}
@if(!isEmpty(orgId)){
   AND t.ORG_ID = #orgId# 
@}

@if(!isEmpty(search)){
and(
 GETACCOUNTNAME ( T.ACCOUNT_ID ) like #search#  or 
 upper(h.EMP_CODE) like #search# 
)@}

getRolesFlow
===
SELECT group_concat(d.PROCESSCHNAME) FROM wf_processdefine d WHERE d.PROCESSDEFCONTENT REGEXP concat('(>|")',#roleId#,'[^/]*role')

selectAllocate
===
select @pageTag(){
getaccountname(t.account_id) account_name,
getdeptname(a.dept_id) dept_name,
getdeptname(a.org_id) org_name,
t.*,
r.ROLE_TYPE,
r.ROLE_NAME,
concat(getdeptname(t.org_id) ,nvl2(t.org_id,'>',''),getdeptname(t.dept_id) ,nvl2(t.dept_id,'>',''),r.role_name) role_name_text,
GETDICNAME('ROLE_TYPE',r.ROLE_TYPE) ROLE_TYPE_TEXT
@}
from BAS_ROLES_ACCOUNT t
left join bas_emp_account a on a.account_id=t.account_id
left join bas_roles r on r.role_id = t.role_id
where 1=1
@if(!isEmpty(accountId)){
and a.ACCOUNT_ID=#accountId#
@}
@if(!isEmpty(search)){
and(
upper(r.ROLE_NAME) like #search# ESCAPE '/'  or
upper(concat(getdeptname(t.org_id) ,nvl2(t.org_id,'>',''),getdeptname(t.dept_id) ,nvl2(t.dept_id,'>',''),r.role_name)) like #search# ESCAPE  '/'
)@}
@if(!isEmpty(flowsql)){
#text(flowsql)#
@}
@pageIgnoreTag(){
@if(isEmpty(sort)){
order by r.display_no,a.account_id
@}
@if(!isEmpty(sort)){
order by #text(sort)# #text(order)#
@}
@}



pageBasEmpAccountData
===
select  @pageTag(){
t.ACCOUNT_ID,
t.ACCOUNT_NAME,
t.DEPT_ID,t.ORG_ID,
concat(o.org_name,'-',d.dept_name) org_name,
d.dept_name dept_name
 @} 
from bas_emp_account t 
left join bas_org o on o.ORG_ID = t.ORG_ID
left join bas_dept d on d.dept_id  = t.DEPT_ID
left join bas_emp e on t.EMP_ID = e.EMP_ID
where t.IS_USE = 'Y'  and e.EMP_ID !=0
@if(!isEmpty(orgId)){
and t.org_id =#orgId#
@}
@if(!isEmpty(search)){
and(
 upper(t.ACCOUNT_NAME) like #search#  
)@}
order by o.SORT is null,o.SORT asc,d.DISPLAY_NO is null ,d.DISPLAY_NO asc 




pageRolesDataByAccount
===
select @pageTag(){
a.account_id,
t.role_id,
c.DIC_TEXT role_type,
(case when r.ROLE_TYPE = 'org' then CONCAT(o.org_name,'>',r.ROLE_NAME) when r.ROLE_TYPE = 'dept' then CONCAT(o.org_name,'>',d.dept_name,'>',r.ROLE_NAME) else r.ROLE_NAME end ) ROLE_NAME,
(case when r.ROLE_TYPE = 'org' then t.org_id when r.ROLE_TYPE = 'dept' then t.dept_id else '' end ) ROLE_SIGN 
 @}
 from bas_roles_account t
 left join bas_emp_account a on a.account_id = t.ACCOUNT_ID
 left join bas_org o on o.org_id = t.org_id
left join bas_dept d on d.dept_id = t.dept_id
 left join bas_roles r on r.ROLE_ID = t.ROLE_ID
 left join bas_dic c on c.DIC_CODE = 'ROLE_TYPE' and r.ROLE_TYPE = c.DIC_VALUE
 where a.is_use = 'Y' AND r.is_use = 'Y'
@if(!isEmpty(accountId)){
and  t.account_id = #accountId#
@}
@if(!isEmpty(search)){
and(
 upper(r.role_name) like #search#
)@}

 order by r.ROLE_TYPE asc ,r.DISPLAY_NO asc



pageRolesMenuDataByAccount
===
with tmp as (
with recursive cte as (
select
			t.MENU_ID,
			t.MENU_NAME as text,
			t.MENU_TYPE ,
			concat(t.MENU_NAME) path
from
			bas_menu t 
where
			t.is_use = 'Y' and t.PMENU_ID = 0
union all
select
			T.MENU_ID,
			concat( cte.text, '>', t.MENU_NAME ) as text,
			t.MENU_TYPE ,
			concat( cte.text, '>', t.MENU_NAME ) path
from
			bas_menu t,
			cte
where
			t.is_use = 'Y'
	and cte.menu_id = t.PMENU_ID
		)
select
		cte.*
from
		cte  where 1=1 and cte.menu_type = 2

)
select @pageTag(){
z.*  @}
from (
select 
t.menu_id,
p.path menu_name,
t.role_id,
@if(!isEmpty(accountId)){
 #accountId# account_id,
@}
m.DISPLAY_NO,
LENGTH(p.path)-LENGTH(REPLACE(p.path,'>','')) num
 from bas_roles_menu t 
 left join tmp p on p.menu_id = t.menu_id
 left join bas_menu m on m.menu_id = t.menu_id
 left join bas_roles r on r.role_id = t.role_id
 where (t.BUTTON_ID is  null or t.BUTTON_ID = '')
 AND   r.is_use = 'Y'
 AND  m.enable='Y'
 @if(!isEmpty(accountId)){
 and (
(r.ROLE_TYPE = 'org'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id and a.org_id = t.org_id))
or 
(r.ROLE_TYPE = 'dept'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id and a.org_id = t.dept_id))
or 
(r.ROLE_TYPE = 'sys'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id ))
or 
(r.ROLE_TYPE = 'common'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id ))
 )
@}
and m.menu_type = 2
)z where 1=1   and (z.menu_name is not null and z.menu_name !='')
@if(!isEmpty(roleId)){
and z.role_id =#roleId# 
@}

@if(!isEmpty(search)){
and (
upper(z.menu_name) like #search# 
)
@}
order by z.num asc, z.DISPLAY_NO asc

 
pageRolesButtonDataByAccount
===
select @pageTag(){ 
t.BUTTON_ID,
b.BUTTON_TEXT,
b.BUTTON_HTMLID
@}
FROM bas_roles_menu T 
LEFT JOIN bas_menu_button b on b.BUTTON_ID = t.BUTTON_ID 
left join bas_roles r on r.role_id = t.role_id
WHERE T.BUTTON_ID IS NOT NULL AND T.BUTTON_ID !='' 
AND T.MENU_ID = #menuId# 
and (
(r.ROLE_TYPE = 'org'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id and a.org_id = t.org_id))
or 
(r.ROLE_TYPE = 'dept'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id and a.org_id = t.dept_id))
or 
(r.ROLE_TYPE = 'sys'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id ))
or 
(r.ROLE_TYPE = 'common'  and EXISTS (select 1 from bas_roles_account a where a.account_id = #accountId# and a.role_id = t.role_id ))
 )

 
pageRolesReferAccountData
===
select  @pageTag(){ 
distinct a.account_id,
a.account_name,
CONCAT(o.ORG_NAME,'.',d.dept_name) org_dept_name
@}
from bas_roles_account t
left join bas_roles r on r.role_id = t.ROLE_ID
left join bas_emp_account a on a.account_id = t.account_id
left join bas_org o on o.org_id = a.org_id
left join bas_dept d on d.dept_id = a.dept_id
where t.ROLE_ID = #roleId# 
@if(!isEmpty(search)){
and (
upper(a.account_name) like #search# or
upper(o.ORG_NAME) like #search# or
upper(d.dept_name) like #search# 
)
@}
@if(!isEmpty(roleSign)){
and (
CASE WHEN r.ROLE_TYPE = 'org' then t.org_id = #roleSign#  WHEN r.ROLE_TYPE = 'dept' then t.dept_id = #roleSign# else 1=1 end
)
@}
ORDER BY o.SORT asc ,d.DISPLAY_NO asc , a.DISPLAY_NO asc


pageMenuReferAccountData
=== 
with tmp as (
select t.menu_id from bas_menu t where t.MENU_ID = #menuId#
)

select @pageTag(){
distinct a.account_id,a.account_name,CONCAT(o.ORG_NAME,'.',d.dept_name) org_dept_name
@}
from bas_roles_account t
left join bas_roles r on r.ROLE_ID = t.ROLE_ID
left join bas_emp_account a on a.account_id = t.account_id
left join bas_emp e on e.emp_id = a.emp_id
left join bas_org o on o.org_id = a.org_id
left join bas_dept d on d.dept_id = a.dept_id
where 1=1 and  t.ACCOUNT_ID  is not null 
and  (  ((R.ROLE_TYPE = 'common' or R.ROLE_TYPE ='sys') AND  EXISTS (
select 1 from bas_roles_menu rm where  rm.MENU_ID = (select p.menu_id  from tmp p)  and  rm.ROLE_ID = t.role_id
) )
or  ((R.ROLE_TYPE = 'org' ) AND  EXISTS (
select 1 from bas_roles_menu rm where  rm.MENU_ID =  (select p.menu_id  from tmp p)  and  rm.ROLE_ID = t.role_id and rm.org_id = t.org_id
) )
or ((R.ROLE_TYPE = 'dept' ) AND  EXISTS (
select 1 from bas_roles_menu rm where  rm.MENU_ID =  (select p.menu_id  from tmp p)  and  rm.ROLE_ID = t.role_id and rm.dept_id = t.dept_id
) )
)
@if(!isEmpty(search)){
and (
upper(a.account_name) like #search# or
upper(o.ORG_NAME) like #search# or
upper(d.dept_name) like #search# 
)
@}
order by  o.SORT is null ,o.SORT asc,d.DISPLAY_NO is null , d.DISPLAY_NO asc 


pageMenuReferRolesData
===
WITH rolesData as (
SELECT  
o.org_id,
d.DEPT_ID,
r.ROLE_ID,
CONCAT( o.org_name, '>', d.dept_name, '>', r.ROLE_NAME )  role_name,r.DISPLAY_NO,r.ROLE_TYPE
from bas_dept d 
left join bas_org o on o.org_id = d.org_id
, bas_roleS r
where r.ROLE_TYPE = 'dept' and d.IS_USE = 'Y' AND R.IS_USE = 'Y'
union all
select  o.ORG_ID,
null as dept_id,
r.ROLE_ID,
CONCAT( o.org_name, '>', r.ROLE_NAME ) role_name,r.DISPLAY_NO,r.ROLE_TYPE
from bas_org o ,bas_roles r 
where o.IS_USE = 'Y' AND R.IS_USE = 'Y' and r.ROLE_TYPE = 'org'
union all
select  
null as org_id,
null as dept_id,
r.role_id,
r.ROLE_NAME,
r.DISPLAY_NO,
r.ROLE_TYPE
from bas_roles r where r.IS_USE = 'Y' AND (r.ROLE_TYPE = 'common' or r.ROLE_TYPE = 'sys')
)
select  
@pageTag(){ 
c.DIC_TEXT role_type,r.ROLE_ID,
r.role_name ROLE_NAME
@}
from bas_roles_menu t
left join rolesData r on r.ROLE_ID = t.ROLE_ID
LEFT JOIN BAS_ORG o on o.org_id = t.ORG_ID
left join bas_dept d on d.dept_id = t.dept_id
left join bas_dic c on c.DIC_CODE = 'ROLE_TYPE' and r.ROLE_TYPE = c.DIC_VALUE
where t.MENU_ID = #menuId#
AND (
		( r.ROLE_TYPE = 'org' AND t.org_id = r.org_id ) 
		OR ( r.ROLE_TYPE = 'dept' AND t.dept_id = r.dept_id ) 
		or(r.ROLE_TYPE = 'common')
		or(r.ROLE_TYPE = 'sys')
	)
and t.BUTTON_ID is null 
@if(!isEmpty(search)){
and (
upper(c.DIC_TEXT) like #search# or
upper(r.ROLE_NAME) like #search#
)
@}

getRoleAccountByRoleId
===
select DISTINCT a.ACCOUNT_ID,b.ACCOUNT_NAME from bas_roles_account a
LEFT JOIN bas_emp_account b on a.ACCOUNT_ID = b.ACCOUNT_ID
where a.ROLE_ID = #roleId# and b.ACCOUNT_NAME is NOT NULL

delRoleAccountByRoleId
===
delete from bas_roles_account where ROLE_ID = #roleId#


pageRolesDataAll
===
select   @pageTag(){ 
z.* 
@}
from 
(SELECT  
o.org_id,
d.DEPT_ID,
r.ROLE_ID,
CONCAT( o.org_name, '>', d.dept_name, '>', r.ROLE_NAME )  role_name,r.DISPLAY_NO,d.dept_id role_Sign 
from bas_dept d 
left join bas_org o on o.org_id = d.org_id
, bas_roleS r
where r.ROLE_TYPE = 'dept' and d.IS_USE = 'Y' AND R.IS_USE = 'Y'
union all
select  o.ORG_ID,
null as dept_id,
r.ROLE_ID,
CONCAT( o.org_name, '>', r.ROLE_NAME ) role_name,r.DISPLAY_NO,o.org_id role_Sign
from bas_org o ,bas_roles r 
where o.IS_USE = 'Y' AND R.IS_USE = 'Y' and r.ROLE_TYPE = 'org'
union all
select  
null as org_id,
null as dept_id,
r.role_id,
r.ROLE_NAME,
r.DISPLAY_NO,
'' as role_Sign
from bas_roles r where r.IS_USE = 'Y' AND (r.ROLE_TYPE = 'common' or r.ROLE_TYPE = 'sys'))z where 1=1
@if(!isEmpty(search)){
and(
 upper(z.role_name) like #search#
)@}
order by z.DISPLAY_NO is null,z.DISPLAY_NO asc


pageRolesMenuDataAll
===
with recursive cte as (
select
			t.MENU_ID,
			t.MENU_NAME as text,
			t.MENU_TYPE ,
			concat(t.MENU_NAME) path,
			t.DISPLAY_NO
from
			bas_menu t 
where
			t.is_use = 'Y' and t.PMENU_ID = 0
union all
select
			T.MENU_ID,
			concat( cte.text, '>', t.MENU_NAME ) as text,
			t.MENU_TYPE ,
			concat( cte.text, '>', t.MENU_NAME ) path,
			t.DISPLAY_NO
from
			bas_menu t,
			cte
where
			t.is_use = 'Y'
	and cte.menu_id = t.PMENU_ID
		)
select @pageTag(){ 
		cte.menu_id,
		cte.path menu_name,
		null as role_id, 
		null as account_id,
		cte.DISPLAY_NO
		@}
from
		cte  where 1=1 and cte.menu_type = 2
@if(!isEmpty(search)){
and(
 upper(cte.path) like #search#
)@}
order by cte.DISPLAY_NO asc


pageRolesButtonDataByMenuId
===
select 
@pageTag(){ 
b.MENU_ID,
b.BUTTON_ID,
b.BUTTON_TEXT,
b.BUTTON_HTMLID
@}
from bas_menu_button b  
WHERE b.BUTTON_ID IS NOT NULL AND b.BUTTON_ID !='' 
AND b.MENU_ID = #menuId#
