

pageAll
===
select @pageTag(){
		t.FLOW_NO,
		t.FLOW_NAME,
		t.CREATE_TIME,
		t.PRINT_ID,
		case when a.APPLY_ORGS is null then '公用' else  GETORGNAME(a.APPLY_ORGS) end APPLY_ORGS_name
	 @}
from BAS_FLOW_PRINT t
LEFT JOIN STF_BUSINESS_PROCESS a on a.DESIGN_NAME = t.FLOW_NO
where t.is_use = 'Y'
@if( !isEmpty(createTimeStart) ){
	and t.CREATE_TIME >= STR_TO_DATE(#createTimeStart#,'%Y-%m-%d')
@}
@if( !isEmpty(createTimeEnd) ){
	and t.CREATE_TIME <= STR_TO_DATE(#createTimeEnd#,'%Y-%m-%d')
@}
@if(!isEmpty(search)){
and(
 upper(t.FLOW_NO) like #search#  ESCAPE '/' OR
 upper(t.FLOW_NAME) like #search#  ESCAPE '/' OR
 upper(GETORGNAME(a.APPLY_ORGS)) like #search#  ESCAPE '/'
)@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
   	 order by t.PRINT_ID desc
    @}else{
   	 order by #text(sort)# #text(order)#
    @}
@}


pageFlowDeFine
===
SELECT @pageTag(){
	CONCAT(t.PROCESSCHNAME,'(', t.PROCESSDEFNAME , ')') AS FLOW,
	t.UPDATETIME,
	t.VERSIONSIGN,
	t.PROCESSCHNAME flow_name	,
	t.PROCESSDEFNAME  flow_no,
	t.PROCESSDEFID
@}
FROM wf_processdefine t
WHERE t.PROCESSDEFNAME IS NOT NULL
-- AND t.CURRENTSTATE = '3'
@if(!isEmpty(search)){
and(
	upper(t.PROCESSCHNAME) like #search#  ESCAPE '/' OR 
	upper(t.PROCESSDEFNAME) like #search#  ESCAPE '/'
)@}
@pageIgnoreTag(){
	@if(isEmpty(sort)){
		order by t.UPDATETIME desc
	@}else{
		order by #text(sort)# #text(order)#
	@}
@}

getFlowNameByProcessinstid
===
SELECT 
	t.PROCESSDEFNAME,
	t.PROCESSDEFID
FROM `wf_processdefine_processinst` t  
WHERE t.PROCESSINSTID = #processinstid#

findByFlowNo
===
SELECT *
FROM bas_flow_print t
WHERE t.FLOW_NO = #flowNo# AND t.IS_USE="Y" AND t.PROCESSDEFID = #processdefid#
ORDER by t.PRINT_ID DESC
LIMIT 1


getFlowAdvice
===
SELECT
b.workmemory advice,
(
CASE
WHEN b.currentstate = '12' THEN
( SELECT group_concat( a.account_name ) FROM bas_emp_account a WHERE a.account_id = b.participant ) ELSE ( SELECT group_concat( d.participant2 ) FROM wf_participant d WHERE d.workitemid = b.workitemid )
END
) sender,
DATE_FORMAT( b.endtime, '%Y-%m-%d %H:%i:%s' ) advice_Time,
a.activitydefid AS act,
b.WORKITEMNAME ITEM_NAME
FROM
(
SELECT
rank() over ( PARTITION BY a.processinstid, a.activitydefid ORDER BY a.activityinstid DESC ) ver,
a.*
FROM
wf_activityinst a
) a,
wf_workitem b
WHERE
a.ver = 1
AND a.activityinstid = b.activityinstid
AND a.processinstid = b.processinstid
AND a.processinstid = #processinstid#
AND FIND_IN_SET(a.activitydefid, #acts#)
AND b.workmemory IS NOT NULL
ORDER BY
b.endtime DESC
limit 1


findActListByFlowName
===
SELECT
	x.activitydefid AS `VALUE`,
	CONCAT(x.actname,'(', x.activitydefid, ')') AS `text`
FROM
(
WITH flow_act AS (
	SELECT
	ExtractValue(t.PROCESSDEFCONTENT,'/ProcessDefine/Activitys/Activity/@id') acts_id,
	REGEXP_REPLACE( ExtractValue ( t.PROCESSDEFCONTENT, '/ProcessDefine/Activitys/Activity/@name' ), '\\\\s+', ' ' ) NAMES
	FROM
	wf_processdefine t
	WHERE
	t.PROCESSDEFNAME = #flowName#
	AND t.currentstate = '3'
) 
SELECT
	SUBSTRING_INDEX ( SUBSTRING_INDEX( a.acts_id, ' ', b.ID + 1 ), ' ',- 1 ) AS activitydefid,
	SUBSTRING_INDEX( SUBSTRING_INDEX( a.NAMES, ' ', b.ID + 1 ), ' ',- 1 ) AS actname
FROM
	flow_act A
	JOIN sys_ROW b ON b.ID < ( length( a.acts_id ) - length( REPLACE ( a.acts_id, ' ', '' ) ) + 1 )) X
WHERE
	x.activitydefid <> 'act_start'
	AND x.activitydefid <> 'act_finish'
ORDER BY
cast(substr( x.activitydefid, 5 ) AS SIGNED INTEGER)