pageAll
===
SELECT
    t.SETTING_FILTER_ID,
    t.WARNING_SETTING_ID,
    t.LEFT_BRACKET,
    t.FILTER_CONDITION,
    t1.MODEL_NAME AS FILTER_CONDITION_NAME,
    t.COMPARE_MARK,
    t.COMPARE_VALUE,
    t.RIGHT_BRACKET,
    t.LOGICAL_MARK,
    t.REMARK,
    t.ORDER_NUM,
    t.IS_USE 
FROM
    bas_early_warning_setting_filter t
    LEFT JOIN bas_model_manage t1 ON t.FILTER_CONDITION = t1.MODEL_ID 
WHERE
    t.IS_USE = 'Y' 
    AND t.WARNING_SETTING_ID = #mainId# 
ORDER BY
    t.ORDER_NUM

delBasEarlyWarningSettingFilterBySettingId
===
UPDATE bas_early_warning_setting_filter t 
SET t.IS_USE = 'N',
t.MODIFY_ACCOUNT = #modifyAccount#,
t.MODIFY_TIME = SYSDATE() 
WHERE
    t.WARNING_SETTING_ID = #mainId#

findDataModelList
===    
SELECT
    t.MODEL_ID AS value,
    t.MODEL_NAME AS text,
    t1.MODEL_NAME pname
FROM
    bas_model_manage t,
    bas_model_manage t1 
WHERE
     t.IS_USE = 'Y'
        AND t1.IS_USE = 'Y'
    AND t.MODEL_PID = t1.MODEL_ID 
    AND t1.MODEL_PID = #modelId#  
        AND t.MODEL_TYPE NOT IN ('condition')
ORDER BY
t1.ORDER_NUM,
    t.ORDER_NUM
    
getFilterData
===
SELECT
    x.WARNING_SETTING_ID,
    x.ORDER_NUM,
    concat(
        x.LEFT_BRACKET,
        ' ',
        ( CASE WHEN b.model_Type = 'computedColumn' THEN b.express ELSE CONCAT( c.MODEL_CODE, '.', b.MODEL_CODE ) END ),
        ' ',
        x.COMPARE_MARK,
        ' ',
        (case when instr(x.COMPARE_MARK,' null')>0 then '' else 
        concat('''',
        x.COMPARE_VALUE,
        '''')   end )
        ,
        x.RIGHT_BRACKET,
        ' ',
        x.LOGICAL_MARK 
    ) exp 
FROM
    bas_early_warning_setting_filter x
    INNER JOIN bas_model_manage b ON b.model_id = x.FILTER_CONDITION
    INNER JOIN bas_model_manage c ON b.MODEL_PID = c.MODEL_ID 
WHERE
    x.is_use = 'Y' 
    AND FIND_IN_SET( x.WARNING_SETTING_ID, #warningSettingIds# ) > 0 
ORDER BY
    x.WARNING_SETTING_ID, x.ORDER_NUM