<%@ page language="java" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<c:set var="ctx" value="${pageContext.request.contextPath}" />
<!DOCTYPE html>
<html>
<head>
<title>空间预览</title>
<jsp:include page="../common/common.jsp"></jsp:include>
<link rel="stylesheet" type="text/css" href="${ctx}/static/style/space/css/index.css">
<link rel="stylesheet" type="text/css" href="${ctx}/static/style/space/css/layout.css">
<script src="${ctx}/static/plugins/muuri/web-animations.min.js"></script>
<script src="${ctx}/static/plugins/muuri/muuri.js"></script>
<link href="${ctx}/static/plugins/swiper-4.5.0/dist/css/swiper.css" rel="stylesheet" type="text/css"/>
<script type="text/javascript" src="${ctx}/static/plugins/swiper-4.5.0/dist/js/swiper.min.js"></script>
<%-- <link rel="stylesheet" type="text/css" href="${ctx}/static/style/staticCore/jquery-easyui-1/themes/default/easyui.css">
		<link rel="stylesheet" type="text/css" href="${ctx}/static/style/staticCore/jquery-easyui-1/themes/icon.css">
		<script type="text/javascript" src="${ctx}/static/style/staticCore/jquery-easyui-1/jquery.min.js"></script>
		<script type="text/javascript" src="${ctx}/static/style/staticCore/jquery-easyui-1/jquery.easyui.min.js"></script> --%>
		<script src="${ctx}/static/style/staticCore/js/co-tabs.js"></script>
		<!-- import CSS -->
		<!-- <link rel="stylesheet" href="staticCore/css/co-textbox.css"> -->
		<!-- <link rel="stylesheet" href="staticCore/css/co-combobox.css"> -->
<link rel="stylesheet" href="${ctx}/static/style/staticCore/css/comment.css">
<link rel="stylesheet" href="${ctx}/static/style/staticCore/font/iconfont.css">
<link rel="stylesheet" href="${ctx}/static/plugins/iconfontbase/iconfont.css" type="text/css">
<link rel="stylesheet" href="${ctx}/static/style/staticCore/css/home.css">
<link rel="stylesheet" href="${ctx}/static/plugins/iconfont/iconfont.css">
<link rel="stylesheet" href="${ctx}/static/style/custom/space.css">
<%
	String spaceId = request.getParameter("spaceId");
%>
<style>
/*自己给页面定义的样式*/
.layui-form-label{
	width:82px
}

.layui-form-item>div{
	margin-left:83px;
}

.layui-form-select .layui-input{ 
	width: 144px; 
	height: 34px;
	padding-right: 30px;
}

.layui-input{
	 width: 144px;
}

#saveComponent{
	top: 0px;
	right: -82px;
	background: #e9effe;
}

#saveSpace{
	top: 0px;
	right: -82px;
	background: #e9effe;
}

#addComponent{
	top: 50px;
	background: #e9effe;
}
.panel-icon.iconfont,span.iconfont,i.iconfont{
   background: transparent!important;
   }


</style>
</head>

<body style="width:100%">
	<div class="easyui-layout" data-options="fit:true">
		<div data-options="region:'west',split:true" title="空间预览" id="mainarea" style="background: #f0f2f5!important;"
			 split="false"> 
			<div class="areaScroll"> 
		      <!-- 内容主体区域 -->
		        <div class="layui-fluid" style="margin: 5px;">
					<!-- 内容主体区域 -->
					<div class="grid">
						<input id="spaceComponentAssociated" value="${item.associated}" hidden="true">	
						<input id="basSpaceComponentType" value="${item.componentType}" hidden="true">	
						<c:forEach items="${itemList}" var="item" varStatus="status">
							<div id="panel_${item.associated}" class="item"
								style="width:${item.componentWidth};height:${item.componentHeight}px;">
								<script type="text/javascript">
						 		$("#panel_${item.associated}").load('${ctx}${item.linkAddress}',function(){
						 			$.parser.parse('#panel_${item.associated}');  
						 		})
						 		</script>
							</div>
						</c:forEach>
				   </div>
			   </div>
		   </div>
		   </div>

		<div data-options="region:'center',split:true" title="组件属性">
			<div class="layui-tab layui-tab-brief" lay-filter="docDemoTabBrief">
				<ul class="layui-tab-title">
					<li class="layui-this">组件</li>
					<li>主页</li>
				</ul>
				<div class="layui-tab-content" style="height: 500px;">
					<div class="layui-tab-item layui-show">
						<form class="layui-form" action="">
							<div class="layui-form-item">
								<label class="layui-form-label">类型</label>
								<div class="layui-input-block">
									<select id="componentType" name="componentType">
										<option value="1">栏目</option>
										<option value="2">组件</option>
										<option value="3">报表</option>
									</select>
									<input type="text" id="associated" name="associated" hidden="true">
								</div>
							</div>
							<div class="layui-form-item">
								<label class="layui-form-label">组件/栏目/报表</label>
								<div class="layui-input-block">
									<input type="text" id="componentName" name="componentName" laceholder=""
										autocomplete="off" class="layui-input">
									<input type="text" id="componentId" name="componentId" hidden="true">
								</div>
							</div>
							<div class="layui-form-item">
								<label class="layui-form-label">顺序</label>
								<div class="layui-input-block">
									<input type="text" id="squence" name="squence" laceholder=""
										autocomplete="off" class="layui-input">
								</div>
							</div>
							<div class="layui-form-item">
								<label class="layui-form-label">展示名称</label>
								<div class="layui-input-block">
									<input type="text" id="displayName" name="displayName" laceholder=""
										autocomplete="off" class="layui-input">
								</div>
							</div>
							<div class="layui-form-item">
								<label class="layui-form-label">组件宽度</label>
								<div class="layui-input-block">
									<select id="componentWidth" name="componentWidth" required="true">
										<c:forEach items="${comboxNodeList}" var="comboxNode"> 
											<option value="${comboxNode.value}">${comboxNode.text}</option>
										</c:forEach>
									</select>
								</div>
							</div>
							<div class="layui-form-item">
								<label class="layui-form-label">组件高度</label>
								<div class="layui-input-block">
									<select id="componentHeight" name="componentHeight" required="true">
										<c:forEach items="${comboxHList}" var="comboxNode"> 
											<option value="${comboxNode.value}">${comboxNode.text}</option>
										</c:forEach>
									</select>
								</div>
							</div>
							<button type="button" id="saveComponent" 
								class="layui-btn layui-btn-sm" lay-submit lay-filter="saveComponent">保存组件</button>
						</form>	
					</div>
					
					<div class="layui-tab-item">
							<button  type="button" id="saveSpace" class="layui-btn layui-btn-normal layui-btn-radius" 
								onclick="saveSpace()">保存顺序</button>
							<button  type="button" id="addComponent" class="layui-btn layui-btn-normal layui-btn-radius" 
							onclick="addComponent()">添加组件</button>
					</div>
				</div>
			</div>
		</div>
	</div>

	<script>
	$("#mainarea").width($("body").width()-250);
		var grid = new Muuri('.grid', {
			// Drag & Drop
			items : '.item',
			dragEnabled : true,
			layoutOnResize:true,
			layout : {
			    fillGaps: false,
			    horizontal: false,
			    alignRight: false,
			    alignBottom: false,
			    rounding: false//四舍五入
			}
		});
		
		grid.refreshItems().layout();

		layui.use('element', function() {
			var $ = layui.jquery, element = layui.element; //Tab的切换功能，切换事件监听等，需要依赖element模块

			//触发事件
			var active = {
				tabAdd : function() {
					//新增一个Tab项
					element.tabAdd('demo', {
						title : '新选项' + (Math.random() * 1000 | 0) //用于演示
						,
						content : '内容' + (Math.random() * 1000 | 0),
						id : new Date().getTime()
					//实际使用一般是规定好的id，这里以时间戳模拟下
					})
				},
				tabDelete : function(othis) {
					//删除指定Tab项
					element.tabDelete('demo', '44'); //删除：“商品管理”

					othis.addClass('layui-btn-disabled');
				},
				tabChange : function() {
					//切换到指定Tab项
					element.tabChange('demo', '22'); //切换到：用户管理
				}
			};

			$('.site-demo-active').on('click', function() {
				var othis = $(this), type = othis.data('type');
				active[type] ? active[type].call(this, othis) : '';
			});

			//Hash地址的定位
			var layid = location.hash.replace(/^#test=/, '');
			element.tabChange('test', layid);

			element.on('tab(test)', function(elem) {
				location.hash = 'test=' + $(this).attr('lay-id');
			});

		});

		layui.use([ 'carousel', 'form' ],
				function() {
					var carousel = layui.carousel, form = layui.form;

					//常规轮播
					carousel.render({
						elem : '#test1',
						width : '100%',
						height : '215px',
						arrow : 'none'

					});

					carousel.render({
						elem : '#test2',
						width : '100%',
						interval : 1800,
						anim : 'fade',
						height : '215px'
					});

					//事件
					carousel.on('change(test4)', function(res) {
						console.log(res)
					});

					var $ = layui.$, active = {
						set : function(othis) {
							var THIS = 'layui-bg-normal', key = othis
									.data('key'), options = {};

							othis.css('background-color', '#fff').siblings()
									.removeAttr('style');
							options[key] = othis.data('value');
							ins3.reload(options);
						}
					};

					//监听开关
					form.on('switch(autoplay)', function() {
						ins3.reload({
							autoplay : this.checked
						});
					});
					
					
					//保存组件  按钮的触发事件
					form.on('submit(saveComponent)', function(data){
						//console.info(data.field);
						var dataStr = JSON.stringify(data.field);
						var associated = $('#associated').val();
						if (""==associated){
							alertInfo("请选择组件");
							return;
						}
						var spaceId = '<%=spaceId%>';
						$.ajax({
					    	url : ctx+ "/BasSpaceComponentAssociated/saveBasSpaceComponentAssociated",
							type : "POST",
							data : {
								dataStr :dataStr,
								spaceId :spaceId
							},
							dataType : 'json',
							success : function(result) {
								if(result.success){
									alertInfo(result.msg);
								}else{
									alertError(result.msg);
								}
							}
					    });
					});
					

					$('.demoSet').on('keyup', function() {
						var value = this.value, options = {};
						if (!/^\d+$/.test(value))
							return;

						options[this.name] = value;
						ins3.reload(options);
					});
					

					//其它示例
					$('.demoTest .layui-btn').on('click', function() {
						var othis = $(this), type = othis.data('type');
						active[type] ? active[type].call(this, othis) : '';
					});

				});
		

		//保存页面(保存拖动后的组件顺序)
		function saveSpace() {
			var allItems = grid.getItems();
			//ajax传送至后台的请求参数
			var data = [];
			//获取隐藏的input(空间组件关联表的主键ASSOCIATED)
			for (var i = 0; i < allItems.length; i++) {
				data.push({
					associated : allItems[i]._element.id.replace("panel_",""),
					squence : i + 1
				});
			}
			var dataStr = JSON.stringify(data);
			$.ajax({
					url : ctx+ "/BasSpaceComponentAssociated/saveSpaceComponentSquence",
					type : "POST",
					data : {
						dataStr : dataStr
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							alertInfo("顺序保存成功");
						}else{
							alertError(result.msg);
						}
					}
			});
		}
		
		$('a').bind('click', function(event) {
			  event.preventDefault();  
		});

		//组件的点击事件    在表单显示相应的组件信息
		$(".grid").on("click",".item",function(){	
		    var panel_Id=$(this).attr("id");
		    var associated =panel_Id.substr(6,panel_Id.length-6);
		    var componentType=$('#'+panel_Id+" #basSpaceComponentType").val();
		  //  console.info(componentType);
		    
			//card的遮罩
			$(".sapce-shade").remove();
			$(this).append('<div class="sapce-shade" id="space-layer-shade6" times="6" style="" align="center" >'+
			'<div class="sapcebtn">'+
			'<a onclick="addComponentAssociatedInCard('+associated+','+componentType+',\''+panel_Id+'\')"><i  class="icon spaceiconfont icon-edit"></i></a>'+
			'<a onclick=" delComponentAssociated('+associated+')"><i  style="color:red" class="icon spaceiconfont icon-del "></i></a>'+
			'</div></div>')
	
		    //给被点击的组件进行高亮显示 delComponentAssociated(associated)
		    $('.layui-card').css("border","1px solid d7dbe4");
		    $('#'+panel_Id+' .layui-card').css("border","1px solid #5FB878");
		    
		    
		    $.ajax({
		    	url : ctx+ "/BasSpaceComponentAssociated/findBasSpaceComponentAssociated",
				type : "POST",
				data : {
					id : associated
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						$('#associated').val(result.o.associated);
						$('#componentType').val(result.o.componentType);
						$('#componentName').val(result.o.componentName);
						$('#componentId').val(result.o.componentId);
						$('#squence').val(result.o.squence);
						$('#displayName').val(result.o.displayName);
						$('#componentWidth').val(result.o.componentWidth);
						$('#componentHeight').val(result.o.componentHeight);
						//重新渲染表单   form = layui.form指的是页面中的所有表单
						layui.use('form', function() {
			                var form = layui.form;
			                form.render();
			            });
					}else{
						alertError(result.msg);
					}
				}
		    });
		});

		
		//给页面添加组价或栏目
		function addComponent(){	
			openChooseDialog({
				title : "选择组件/栏目",
				contenturl :'/BasSpaceComponentAssociated/allocateBasSpaceComponent',
				width : 650,
				height : 550,
				okhandler : function(){
					var chooseRows=$('#choosegrid').datagrid('getRows');
					if(chooseRows==null||chooseRows.length==0){
						alertInfo("请选择数据!");
						return false;
					}
					var data=[];
					for(var i=0;i<chooseRows.length;i++){
						data.push({componentType:chooseRows[i].componentType,componentId:chooseRows[i].componentId});
					}
					var dataStr = JSON.stringify(data);
					var spaceId = '<%=spaceId%>';
					var maxSquence = grid.getItems().length;
					
					$.ajax({
						url : ctx+ "/BasSpaceComponentAssociated/addComponentAssociated",
						type : "POST",
						data : {
							dataStr :dataStr,
							spaceId :spaceId,
							maxSquence:maxSquence
						},
						dataType : 'json',
						success : function(result) {
							if(result.success){
								//在页面添加card
								for(var i=0;i<result.o.length;i++){
									var str=
									"<div id=\"panel_"+result.o[i].associated+"\" class=\"item\" style=\"width:"+result.o[i].componentWidth+";height:"+result.o[i].componentHeight+"px\">"
			                        +"<input id=\"spaceComponentAssociated\" value=\""+result.o[i].associated+"\" hidden=\"true\">"
			                        +"<input id=\"basSpaceComponentType\" value=\""+result.o[i].componentType+"\" hidden=\"true\">"
									+"</div>"
									var panelId="panel_"+result.o[i].associated;
									 $(".grid").append(str);
									 grid.add([$("#"+panelId).get(0)],{index:result.o[i].squence});
						            $("#"+panelId).load('${ctx}/BasSpaceComponentDefinition/viewContentListByIds?contentHeight='+result.o[i].componentHeight+'&componentIds='+result.o[i].componentId+'&type='+result.o[i].componentType,function(){
						            	$.parser.parse(); 
						            })
								}		
							}else{
								alertError(result.msg);
							}
						}
					});
					return true;
				}	    
			});	
		}
		
		//在卡片内  添加栏目或组件
		function addComponentAssociatedInCard(associated,componentType,panelId){	
			if(componentType==1){
				contenturl='/BasSpaceComponentAssociated/showInfoTypeSelectWin?associated='+associated;
			}else{
				contenturl='/BasSpaceComponentAssociated/showComponentSelectWin';
			}
			openChooseDialog({
				title : "选择组件/栏目",
				contenturl :contenturl,
				width : 650,
				height : 450,
				okhandler : function(){
					var chooseRows=$('#choosegrid').datagrid('getRows');
					if(chooseRows==null||chooseRows.length==0){
						alertInfo("请选择数据 ");
						return false;
					}
					var data=[];
					for(var i=0;i<chooseRows.length;i++){
						data.push({componentType:chooseRows[i].componentType,componentId:chooseRows[i].componentId});
					}
					var dataStr = JSON.stringify(data);
					var spaceId = '<%=spaceId%>';
					var items = grid.getItems();
					var index;
		            var item =grid.remove($("#"+panelId)[0],{removeElements: true});
		            for (var i = 0; i < items.length; i++) {
		                if(item[0]._id==items[i]._id){
		                    index = i;
		                    break;
		                }
		            }
					$.ajax({
						url : ctx+ "/BasSpaceComponentAssociated/addComponentAssociatedInCard",
						type : "POST",
						data : {
							dataStr :dataStr,
							associated:associated
						},
						dataType : 'json',
						success : function(result) {
							if(result.success){
					                var str=
									"<div id=\"panel_"+result.o.associated+"\" class=\"item\" style=\"width:"+result.o.componentWidth+";height:"+result.o.componentHeight+"px\">"
			                        +"<input id=\"spaceComponentAssociated\" value=\""+result.o.associated+"\" hidden=\"true\">"
			                        +"<input id=\"basSpaceComponentType\" value=\""+result.o.componentType+"\" hidden=\"true\">"
									+"</div>"
									var panelId="panel_"+result.o.associated;
									 $(".grid").append(str);
									 grid.add([$("#"+panelId).get(0)],{index:index});
						            $("#"+panelId).load('${ctx}/BasSpaceComponentDefinition/viewContentListByIds?contentHeight='+result.o.componentHeight+'&componentIds='+result.o.componentId+'&type='+result.o.componentType,function(){
						            	$.parser.parse("#"+panelId); 
						            })
							}else{
								alertError(result.msg);
							}
						}
					});
					return true;
				}
			});
		}
		
		
		//删除一个card
		function delComponentAssociated(associated){
			index=layer.confirm('确认删除？', {
			  btn: ['确定','取消'] //按钮
			}, function(){	
				$.ajax({
					url : ctx+ "/BasSpaceComponentAssociated/delBasSpaceComponentAssociated",
					type : "POST",
					data : {
						id:associated
					},
					dataType : 'json',
					success : function(result) {
						if(result.success){
							$(".sapce-shade").remove();
							grid.remove($("#panel_"+associated)[0],{removeElements: true});
							layer.close(index);
						}else{
							alertError(result.msg);	
						}
					}
				}); 
			}, function(){
				layer.close(index);
			});
			
		}
		
		
		//重新加载card
		function reloadcard(that,type,typeIds){
			if(type=='1'){//单组件
				var panel = $(that).closest(".layui-card").find(".layui-card-body");
				panel.html("<div class=\"spaceloading\" style=\"position:relative;\"></div>");
				panel.load(panel.attr("linkAddress"));
			}else if(type=='2'){//多组件
				var tab = $(that).closest(".layui-tab").find(".layui-show");
				tab.html("<div class=\"spaceloading\" style=\"position:relative;\"></div>");
				tab.load(tab.attr("linkAddress"));
			}else if(type=='3'){//栏目
				var panel = $(that).closest(".layui-tab").find(".layui-show");
				panel.html("<div class=\"spaceloading\" style=\"position:relative;\"></div>");
				panel.load(ctx+"/GmInfoContent/viewContentListByIds?refresh=true&typeIds="+panel.attr("typeId"));
			}
		}
		
		// 如果<a>定义了 target="_blank“ 需要这句来阻止打开新页面  
	/* 	$('a').each(function(i) {  
			 $(this).attr('href', 'javascipt:void(0);');
			 $(this).removeAttr("onclick")
			 $(this).click(function (event) {  
		                    event.preventDefault();   
		     });  
		}); */

	</script>
</body>
</html>