
var pubAssetsSourceGrid = $("#pubAssetsSourceGrid");
$(function(){
	initPubAssetsSourceGrid();
});


/**
 * 初始化
 */
function initPubAssetsSourceGrid(){
	pubAssetsSourceGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#pubAssetsSourceGridTbar",
	    url:ctx+'/pubAssetsSource/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="pubAssetsSourceFormDetail('+row.sourceId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'sourceName',title:'来源名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'sourceCode',title:'来源编码',width:100,align:'center',halign:'center',sortable:true},
	    {field:'bizTypeText',title:'适用业务',width:100,align:'center',halign:'center',sortable:true},
	    {field:'statusText',title:'状态',width:100,align:'center',halign:'center'},
	    {field:'isHandworkText',title:'手工创建',width:100,align:'center',halign:'center'},
		{field:'orderNum',title:'排序值',width:40,align:'right',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			pubAssetsSourceFormDetail(row.sourceId);
	    }
	});
	
    pubAssetsSourceGrid.datagrid('doCellTip');
    var pager = pubAssetsSourceGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('pubAssetsSourceGrid',"资产来源")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function pubAssetsSourceFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubAssetsSource&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadPubAssetsSource(){
	pubAssetsSourceGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchPubAssetsSource(){
	pubAssetsSourceGrid.datagrid('load',{
		fuzzy : $("#fuzzy").textbox("getValue"),
		status : $("#statusQuery").combobox("getValue")
	});
}


/**
 * 增加
 */
function addPubAssetsSource() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=PubAssetsSource",
		submiturl : "/pubAssetsSource/savePubAssetsSource?formcode=PubAssetsSource",
		callback : reloadPubAssetsSource
	});
	
}


/**
 * 修改
 */
function editPubAssetsSource() {

	var row = pubAssetsSourceGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubAssetsSource&id=" + row.sourceId,
		submiturl:"/pubAssetsSource/savePubAssetsSource?formcode=PubAssetsSource",
		callback : reloadPubAssetsSource
	});
}


/**
 * 删除
 */
function delPubAssetsSource() {

	var row = pubAssetsSourceGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/pubAssetsSource/delPubAssetsSource",
				data : {
					id : row.sourceId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						pubAssetsSourceGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
