
var genFormAdvicesGrid = $("#genFormAdvicesGrid");
$(function(){
	initGenFormAdvicesGrid();
});


/**
 * 初始化
 */
function initGenFormAdvicesGrid(){
	genFormAdvicesGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#genFormAdvicesGridTbar",
	    url:ctx+'/genFormAdvices/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="genFormAdvicesFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			genFormAdvicesFormDetail(row.id);
	    }
	});
	
    genFormAdvicesGrid.datagrid('doCellTip');
    var pager = genFormAdvicesGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('genFormAdvicesGrid',"表单意见")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function genFormAdvicesFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GenFormAdvices&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadGenFormAdvices(){
	genFormAdvicesGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchGenFormAdvices(){
	genFormAdvicesGrid.datagrid('load',{

	});
}


/**
 * 增加
 */
function addGenFormAdvices() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=GenFormAdvices",
		submiturl : "/genFormAdvices/saveGenFormAdvices?formcode=GenFormAdvices",
		callback : reloadGenFormAdvices
	});
	
}


/**
 * 修改
 */
function editGenFormAdvices() {

	var row = genFormAdvicesGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GenFormAdvices&id=" + row.id,
		submiturl:"/genFormAdvices/saveGenFormAdvices?formcode=GenFormAdvices",
		callback : reloadGenFormAdvices
	});
}


/**
 * 删除
 */
function delGenFormAdvices() {

	var row = genFormAdvicesGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/genFormAdvices/delGenFormAdvices",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						genFormAdvicesGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
