
var basQuerySettingdGrid = $("#basQuerySettingdGrid");
$(function(){
	initBasQuerySettingdGrid();
});


/**
 * 初始化
 */
function initBasQuerySettingdGrid(){
	basQuerySettingdGrid.datagrid({
		height : $("body").height()*0.5-104,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		// pagination:true,
		queryParams:{
			//dataPerm : 'group'
		},
		cls:'md',
		toolbar:"#basQuerySettingdGridTbar",
	    url:ctx+'/basQuerySettingd/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:20,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basQuerySettingdFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
			}},
			{field:'dataPermText',title: '数据权限',width:80,align:'center'},
			{field:'participantName',title:'授权人员',width:200,align:'center',halign:'center',sortable:true},
		    {field:'det',title:'操作',align:'center',halign:'center',width:80,formatter:function(value,row,index){	
		    	
		    	return '<a style="cursor: pointer;color:#409eff;" onclick="delBasQuerySettingd('+row.id+')" >删除</a>';
		    }}/*,
			{field:'remark',title: '备注',width:40,align:'center'},*/
		]],

	    onDblClickRow:function(index, row){
    		//查看明细
			basQuerySettingdFormDetail(row.id);
	    }
	});
	
    basQuerySettingdGrid.datagrid('doCellTip');
    var pager = basQuerySettingdGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basQuerySettingdGrid',"查询配置表明细")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basQuerySettingdFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : false,
		height: 300,
		width: 600,
		contenturl:"/GenForm/form?formcode=BasQuerySettingd&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasQuerySettingd(){
	basQuerySettingdGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasQuerySettingd(typeId){
	var row = basQuerySettingGrid.datagrid('getSelected');
	if(row){
		typeId = row.id;
	}
	basQuerySettingdGrid.datagrid('load',{
		typeId: typeId,
		dataPerm : queryApp.dataPerm
	});
}


/**
 * 增加
 */
function addBasQuerySettingd() {
	var row = basQuerySettingGrid.datagrid('getSelected');
	if(!queryApp.dataPerm){
		alertWarn("请选择数据权限");
		return;
	}
	if (row) {
		var typeId = row.id;
		openChooseDialog({
		  title: "人员选择",
		  contenturl: '/view/base/baseQueryPersonSelect?typeId='+row.id+"&dataPerm="+queryApp.dataPerm,
		  width: 750,
		  height: 450,
		  okhandler: function () {
		      return true;
		  }
		})
	}else {
		alertInfo("请选择综合查询过滤规则");
	}
}


/**
 * 修改
 */
function editBasQuerySettingd() {

	var row = basQuerySettingdGrid.datagrid('getSelected');
	if(!row){
		alertInfo('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : false,
		height: 300,
		width: 600,
		contenturl:"/GenForm/form?formcode=BasQuerySettingd&id=" + row.id,
		submiturl:"/basQuerySettingd/saveBasQuerySettingd?formcode=BasQuerySettingd",
		callback : reloadBasQuerySettingd
	});
}


/**
 * 删除
 */
function delBasQuerySettingd(id) {

	var row = basQuerySettingdGrid.datagrid('getSelected');
	if(!row&&!id){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basQuerySettingd/delBasQuerySettingd",
				data : {
					id : id||row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basQuerySettingdGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
