
var basEmpDeviceGrid = $("#basEmpDeviceGrid");
$(function(){
	initBasEmpDeviceGrid();
});


/**
 * 初始化
 */
function initBasEmpDeviceGrid(){
	basEmpDeviceGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basEmpDeviceGridTbar",
	    url:ctx+'/basEmpDevice/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basEmpDeviceFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',hidden:true},
	    {field:'imei',title:'手机序列号',width:100,align:'center',halign:'center',sortable:true},
	    {field:'appVersion',title:'app当前版本',width:100,align:'center',halign:'center',sortable:true},
	    {field:'deviceMode',title:'设备型号',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basEmpDeviceFormDetail(row.id);
	    }
	});
	
    basEmpDeviceGrid.datagrid('doCellTip');
    var pager = basEmpDeviceGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basEmpDeviceGrid',"用户设备信息")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basEmpDeviceFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEmpDevice&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasEmpDevice(){
	basEmpDeviceGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasEmpDevice(){
	basEmpDeviceGrid.datagrid('load',{

	});
}


/**
 * 增加
 */
function addBasEmpDevice() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasEmpDevice",
		submiturl : "/basEmpDevice/saveBasEmpDevice?formcode=BasEmpDevice",
		callback : reloadBasEmpDevice
	});
	
}


/**
 * 修改
 */
function editBasEmpDevice() {

	var row = basEmpDeviceGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEmpDevice&id=" + row.id,
		submiturl:"/basEmpDevice/saveBasEmpDevice?formcode=BasEmpDevice",
		callback : reloadBasEmpDevice
	});
}


/**
 * 删除
 */
function delBasEmpDevice() {

	var row = basEmpDeviceGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basEmpDevice/delBasEmpDevice",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basEmpDeviceGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
