var baseGrid = $("#basEarlyWarningSettingGrid");
$(function(){
    initGrid();
});


/**
 * 初始化
 */
function initGrid(){
    baseGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
	    url:ctx+'/basEarlyWarningSetting/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="earlyWarningSettingFormDetail('+ row.warningSettingId +')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
		{field:'settingCode',title:'预警编号',width:120,align:'center'},
        {field:'settingName',title:'预警名称',width:220,align:'center'},
        {field:'warningTypeName',title:'预警业务',width:120,align:'center'},
        {field:'businessTypeName',title:'业务分类',width:120,align:'center'},
        {field:'menuName', title:'关联菜单', width:120, align:'center'},
        {field:'isEnableText',title:'是否启用', width:80, align:'center'}
        ]],
	    onDblClickRow:function(index, row){
	        earlyWarningSettingFormDetail(row.warningSettingId);
	    }
	});
	
    baseGrid.datagrid('doCellTip');
    var pager = baseGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[]   
	});
}


/**
 * 查看表单明细
 */
function earlyWarningSettingFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEarlyWarningSetting&isdetail=true&id="+id,
		onload: function() {
		    $("#businessType_span").html($("#businessTypeName").val());
		}
	});
}


/**
 * 重新加载
 */
function reloadEarlyWarningSetting(){
    baseGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchEarlyWarningSetting(){
    baseGrid.datagrid('load',{
        search: $("#search").textbox("getValue"),
        warningType: $("#modelTypeQ").combotree("getValue")
	});
}


/**
 * 增加
 */
function addEarlyWarningSetting() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasEarlyWarningSetting&isdetail=false",
		submiturl : "/basEarlyWarningSetting/saveBasEarlyWarningSetting?formcode=BasEarlyWarningSetting",
		callback : reloadEarlyWarningSetting,
		onsubmit:function(param){
            param.data = getBasEarlyWarningUseData();
            return true;
        }
	});
}


/**
 * 修改
 */
function editEarlyWarningSetting() {
	var row = baseGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasEarlyWarningSetting&isdetail=false&id=" + row.warningSettingId,
		submiturl:"/basEarlyWarningSetting/saveBasEarlyWarningSetting?formcode=BasEarlyWarningSetting",
		callback : reloadEarlyWarningSetting,
		onload: function() {
	        $("#businessType").combobox("reload", ctx + "/basModelManage/findThemeListByWorkspace?modelId=" + $("#warningType").combotree("getValue"));
		},
		onsubmit:function(param){
            param.data = getBasEarlyWarningUseData();
            return true;
        }
	});
}


/**
 * 删除
 */
function delEarlyWarningSetting() {
	var row = baseGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx + "/basEarlyWarningSetting/delBasEarlyWarningSetting",
				data : {
					id : row.warningSettingId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
					    baseGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}

//表单操作事件可放此js
function selWaringType(node){
    $("#businessType").combobox("reload", ctx + "/basModelManage/findThemeListByWorkspace?modelId=" + node.id);
}

// 选择图标
function chooseIco(){
    openChooseDialog({
        title:'选择图标',
        contenturl: "/BasMenu/chooseIcons",
        width:600,
        height:400,
        okhandler:function(){
            if($('#chooseico').val()){
                $('#warningIcon').textbox('setValue', $('#chooseico').val());
                return true;
            } else {
                alertWarn('请选择一个图标');
                return false;
            }
        }
    });
}

// 是否比选表单编码
function changeFormReq(newVal, oldVal) {
    if(newVal == "Y") {
        $("#formCode").textbox({
            required: true
        });
    } else {
        $("#formCode").textbox({
            required: false
        });
    }
}

function btnshowFormWinFun() {
    openChooseDialog({
        title: "表单选择",
        contenturl: '/view/base/FormSelectWin',
        width: 450,
        height: 450,
        okhandler: function () {
            var r = $('#FormId_datagrid').datagrid('getSelected');
            if (r) {
                $('#formCode').textbox('setValue', r.FORM_CODE);
                return true;
            } else {
                alertWarn("请选择表单");
                return false;
            }
        }
    })
}