
var basEarlyWarningLevelGrid = $("#basEarlyWarningLevelGrid");
$(function(){
	initBasEarlyWarningLevelGrid();
});


/**
 * 初始化
 */
function initBasEarlyWarningLevelGrid(){
	basEarlyWarningLevelGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
		},
		cls:'md',
		toolbar:"#basEarlyWarningLevelGridTbar",
	    url:ctx+'/basEarlyWarningLevel/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basEarlyWarningLevelFormDetail('+row.levelId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
		{field:'levelText', title:'风险等级名称', width:250,align:'center'},
		{field:'levelColor', title:'显示颜色', width:250,align:'center',
			formatter:function(value,row,index){
			return '	<div class="layui-inline" style="width:20px;height:20px;background-color:  '+value+';"></div>';
			}
		}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basEarlyWarningLevelFormDetail(row.levelId);
	    }
	});

    basEarlyWarningLevelGrid.datagrid('doCellTip');
    var pager = basEarlyWarningLevelGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basEarlyWarningLevelGrid',"风险等级维护")
	        }    
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basEarlyWarningLevelFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : false,
		 width: 500,
         height: 300,
		contenturl:"/GenForm/form?formcode=BasEarlyWarningLevel&isdetail=true&id="+id
	});
}


/**
 * 重新加载
 */
function reloadBasEarlyWarningLevel(){
	basEarlyWarningLevelGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasEarlyWarningLevel(){
	basEarlyWarningLevelGrid.datagrid('load',{
		search: $("#search").textbox("getValue")
	});
}


/**
 * 增加
 */
function addBasEarlyWarningLevel() {
	openSaveDialog({
		title : "添加记录",
		maximized : false,
		contenturl : "/GenForm/form?formcode=BasEarlyWarningLevel",
		submiturl : "/basEarlyWarningLevel/saveBasEarlyWarningLevel?formcode=BasEarlyWarningLevel",
		callback : reloadBasEarlyWarningLevel
	});
	
}


/**
 * 修改
 */
function editBasEarlyWarningLevel() {

	var row = basEarlyWarningLevelGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : false,
		contenturl:"/GenForm/form?formcode=BasEarlyWarningLevel&id=" + row.levelId,
		submiturl:"/basEarlyWarningLevel/saveBasEarlyWarningLevel?formcode=BasEarlyWarningLevel",
		callback : reloadBasEarlyWarningLevel
	});
}


/**
 * 删除
 */
function delBasEarlyWarningLevel() {

	var row = basEarlyWarningLevelGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basEarlyWarningLevel/delBasEarlyWarningLevel",
				data : {
					id : row.levelId
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basEarlyWarningLevelGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}
