
var basDemandApplyGrid = $("#basDemandApplyGrid");

$(function(){
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchBasDemandApply();
			}
		}
	});
	initBasDemandApplyGrid();
	bindEnterKey('#searchBasDemandApply',searchBasDemandApply);
});


/**
 * 初始化
 */
function initBasDemandApplyGrid(){
	basDemandApplyGrid.datagrid({
		height : getMixGridHeight(),
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
            flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):""
		},
		cls:'md',
		toolbar:"#basDemandApplyGridTbar",
	    url:ctx+'/basDemandApply/pageAll',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){
				return '<div onclick="basDemandApplyFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
		{field:'remark',title:'需求说明',width:200,align:'center',halign:'center',sortable:true},
		{field:'applyManText',title:'申请人',width:90,align:'center',halign:'center',sortable:true},
		{field:'applyDate',title:'申请日期',width:90,align:'center',halign:'center',sortable:true},
		{field:'workflowStatusText',title:'审批状态',width:90,align:'center',halign:'center',sortable:true},
		{field:'handleStatus',title:'处理状态',width:90,align:'center',halign:'center',sortable:true,formatter: function (value, row, index) {
			 if (row.handleStatus && row.handleStatus== 2) {
                // 点击跳转到支付信息，ID 为reimburseId + "demand"，跳转方法为findPayData(' + row.reimburseId + ",\'" + row.reimburseNo + '\')"
				 return '<button id= "' + row.id + "demand" + '" type="button" class="layui-btn layui-bg-green " onmouseover="findDemandData(' + row.id  + ",3,\'" + row.handleManText + '\')">已解决</button>';
            }else if (!row.workflowStatus||row.workflowStatus == 1) {
				 return '<button id= "' + row.id + "demand" + '" type="button" class="layui-btn layui-bg-cyan " onmouseover="findDemandData(' + row.id +   ",1,\'" + row.handleManText + '\')">待提交</button>';
            }else if (row.workflowStatus != 3) {
                // 点击跳转到支付信息，ID 为reimburseId + "demand"，跳转方法为findPayData(' + row.reimburseId + ",\'" + row.reimburseNo + '\')"
				 return '<button id= "' + row.id + "demand" + '" type="button" class="layui-btn layui-bg-blue " onmouseover="findDemandData(' + row.id  + ",2,\'" + row.handleManText + '\')">审批中</button>';
            } else{
				 return '<button id= "' + row.id + "demand" + '" type="button" class="layui-btn layui-bg-red " onmouseover="findDemandData(' + row.id  + ",4,\'" + row.handleManText + '\')">待解决</button>';
            }
        }},
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			basDemandApplyFormDetail(row.id);
	    }
	});
	
    basDemandApplyGrid.datagrid('doCellTip');
    var pager = basDemandApplyGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('basDemandApplyGrid',"信息化需求申请")
	        } 
	    }]   
	});
}


/**
 * 查看表单明细
 */
function basDemandApplyFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasDemandApply&isdetail=true&id="+id
	});
}

function findDemandData(pkId,type, name ) {
	//定义提示语  前台固定 便于维护
	var  msgTitle = "申请审批流程正在进行";
	if(type ==1){
		msgTitle = "待提交需求申请流程";
	}else if(type ==2){
		msgTitle = "申请审批流程正在进行";
	}else if(type ==3){
		msgTitle = "需求申请已处理，解决人：<br>"+name;
	}else{
		msgTitle = "待管理员处理";
	}

    layer.tips(msgTitle, "#" + pkId + "demand", {
        tips: [1, 'rgb(128 192 50 / 100%)'],
        time: 100000,
        area: ['200px', 'auto'],
    });
}


/**
 * 重新加载
 */
function reloadBasDemandApply(){
	basDemandApplyGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasDemandApply(){
	basDemandApplyGrid.datagrid('load',{
		flowDone : haseasyui('#flow_combo') ? $('#flow_combo').combobox('getValue'):"",
		search: $("#searchBasDemandApply").textbox("getValue"),

	});
}


/**
 * 增加
 */
function addBasDemandApply() {
	openSaveDialog({
		title : "添加记录",
		maximized : true,
		contenturl : "/GenForm/form?formcode=BasDemandApply",
		submiturl : "/basDemandApply/saveBasDemandApply?formcode=BasDemandApply",
		callback : reloadBasDemandApply
	});
	
}


/**
 * 修改
 */
function editBasDemandApply() {

	var row = basDemandApplyGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}
	
	if(row.workflowStatus.toString().indexOf('1') == -1){
		alertWarn('数据已经上报过,不能修改');
		return;
	}

	openSaveDialog({
		title : "修改记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasDemandApply&id=" + row.id,
		submiturl:"/basDemandApply/saveBasDemandApply?formcode=BasDemandApply",
		callback : reloadBasDemandApply
	});
}


/**
 * 删除
 */
function delBasDemandApply() {

	var row = basDemandApplyGrid.datagrid('getSelected');
	if(!row){
		alertWarn('请选择记录!');
		return;
	}

    if(row.workflowStatus.toString().indexOf('1') == -1){
        alertWarn('数据已经上报过,不能删除');
        return;
    }
	alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
		if (r) {
			$.ajax({
				type : "post",
				url : ctx+"/basDemandApply/delBasDemandApply",
				data : {
					id : row.id
				},
				dataType : 'json',
				success : function(result) {
					if (result.success) {
						basDemandApplyGrid.datagrid('reload');
						alertInfo(result.msg);
					}else{
						alertError(result.msg);
					}
				}
			});
		}
	});
	
}


/**
 * 发送
 */
function doFlow(){
	var row = basDemandApplyGrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus == '3'){
			alertWarn('数据已通过');
			return;
		}
		
		//起草中,直接调用修改方法
		if(row.workflowStatus == '1'){
			editBasDemandApply();
			return ;
		}
		
		//有消息记录时,利用gotoDetail参数,调用待办审批页面
		openFlowDialog({
    		processInstId : row.processinstid,
			businessMainId : row.id,
			formCode : "BasDemandApply",
			callback : reloadBasDemandApply,
			gotoDetail : true
        });
        
	} else {
		alertWarn('请先选择一条数据信息');
	}
}


/**
 * 查看
 */
function viewFlow(){
	var row = basDemandApplyGrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}


//确认
function handBasDemandApply(){
	
	//获取选中数据
	var row = basDemandApplyGrid.datagrid('getSelected');
 
	if(row.handleStatus&&row.handleStatus==2){//已确认不可重复确认
		alertWarn('请勿重复确认');
		return;
		}
	
	if(row&&(!row.workflowStatus&&row.workflowStuts!=3)){
		alertConfirmYes('流程未结束，是否确认处理？', function(r) {
		if (r) {
			   $('<div/>').dialog({
			        href: ctx + "/view/base/BasDemandApplyform",
			        style: {overflowX: 'hidden'},
			        width: 350,
			        height: 200,
			        modal: true,
			        title: "确认",
			        // 关闭事件
			        onClose: function () {
			            $(this).dialog('destroy');
			        },
			        // 确定按钮
			        buttons: [{
			            text: "确定",
			            iconCls: 'icon-disk',
			            handler: function () {
			                var okbutton = $(this);
			                var d = $(this).closest('.window').find('.window-body');
			                var submitform = $("#BasDemandApply_Form");
			                submitform.form('enableValidation');
			                submitform.form('submit', {
			                    dataType: 'json',
			                    method: "POST",
			                    url: ctx + "/basDemandApply/handleBasDemandApply?id="+row.id,
			                    // 提交事件
			                    onSubmit: function () {
			                        if (submitform.form('validate')) {
			                            okbutton.linkbutton('disable');//防止重复发送
			                            $.messager.progress({
			                                title: "请稍等",
			                                msg: "数据确认中...",
			                                text: "",
			                                interval: 500
			                            });
			                            return true;
			                        } else {
			                            return false;
			                        }
			                    },
			                    // 发送成功
			                    success: function (result) {
			                        okbutton.linkbutton('disable');//防止重复发送
			                        $.messager.progress('close');
			                        var data = JSON.parse(result);
			                        if (data.success) {
			                            d.dialog('destroy');
			                            basDemandApplyGrid.datagrid('reload');
			                        } else {
			                            okbutton.linkbutton('enable');//信息错误 则启用按钮
			                            alertWarn(data.msg);
			                            basDemandApplyGrid.datagrid('reload');
			                        }
			                    }
			                });
			            }
			        }],
			        inline: false
			    });
		}
	});

	}else if (row&&row.workflowStatus==3) {
		   $('<div/>').dialog({
		        href: ctx + "/view/base/BasDemandApplyform",
		        style: {overflowX: 'hidden'},
		        width: 350,
		        height: 200,
		        modal: true,
		        title: "确认",
		        // 关闭事件
		        onClose: function () {
		            $(this).dialog('destroy');
		        },
		        // 确定按钮
		        buttons: [{
		            text: "确定",
		            iconCls: 'icon-disk',
		            handler: function () {
		                var okbutton = $(this);
		                var d = $(this).closest('.window').find('.window-body');
		                var submitform = $("#BasDemandApply_Form");
		                submitform.form('enableValidation');
		                submitform.form('submit', {
		                    dataType: 'json',
		                    method: "POST",
		                    url: ctx + "/basDemandApply/handleBasDemandApply?id="+row.id,
		                    // 提交事件
		                    onSubmit: function () {
		                        if (submitform.form('validate')) {
		                            okbutton.linkbutton('disable');//防止重复发送
		                            $.messager.progress({
		                                title: "请稍等",
		                                msg: "数据确认中...",
		                                text: "",
		                                interval: 500
		                            });
		                            return true;
		                        } else {
		                            return false;
		                        }
		                    },
		                    // 发送成功
		                    success: function (result) {
		                        okbutton.linkbutton('disable');//防止重复发送
		                        $.messager.progress('close');
		                        var data = JSON.parse(result);
		                        if (data.success) {
		                            d.dialog('destroy');
		                            basDemandApplyGrid.datagrid('reload');
		                        } else {
		                            okbutton.linkbutton('enable');//信息错误 则启用按钮
		                            alertWarn(data.msg);
		                            basDemandApplyGrid.datagrid('reload');
		                        }
		                    }
		                });
		            }
		        }],
		        inline: false
		    });
	} else {
		alertInfo('请先选择一条数据信息');
	}
	
 
}



function printBasDemandApply(){
	var row = basDemandApplyGrid.datagrid('getSelected');
	if (row) {
		window.open(ctx + "/basDemandApply/basDemandApplyPrintTable?id=" + row.id);
	} else {
		alertInfo('请先选择要打印的数据信息');
	}
}