var basBankMaintainGrid = $("#basBankMaintainGrid");
$(function () {
    initBasBankMaintainGrid();
    bindEnterKey("#fuzzy", searchBasBankMaintain);
});


/**
 * 初始化
 */
function initBasBankMaintainGrid() {
    basBankMaintainGrid.datagrid({
        height: getMixGridHeight(),
        border: false,
        singleSelect: true,
        rownumbers: true,
        fitColumns: true,
        pagination: true,
        queryParams: {},
        cls: 'md',
        toolbar: "#basBankMaintainGridTbar",
        url: ctx + '/basBankMaintain/pageAll',
        columns: [[
            // {
            //     field: 'opt', title: '明细', width: 40, align: 'center',
            //     formatter: function (value, row, index) {
            //         return '<div onclick="basBankMaintainFormDetail(' + row.bankMaintainId + ')" class="icon-detail iconfont blue">&nbsp;</div>';
            //     }
            // },
            {field: 'bankMaintainId', hidden: true},
            {field:'bankType',title:'银行类型',width:300,align:'center',halign:'center',sortable:true},
            {field:'bankName',title:'银行名称',width:300,align:'center',halign:'center',sortable:true}
        ]],
        // onDblClickRow: function (index, row) {
        //     //查看明细
        //     basBankMaintainFormDetail(row.bankMaintainId);
        // }
    });

    basBankMaintainGrid.datagrid('doCellTip');
    var pager = basBankMaintainGrid.datagrid('getPager');
    pager.pagination({
        buttons: [{
            iconCls: 'icon-page_excel',
            handler: function () {
                exportExcel('basBankMaintainGrid', "银行维护")
            }
        }]
    });
}


/**
 * 查看表单明细
 */
// function basBankMaintainFormDetail(id) {
//     openDetailDialog({
//         title: "查看记录",
//         maximized: true,
//         contenturl: "/view/base/basBankMaintainForm&isdetail=true&id=" + id
//     });
// }


/**
 * 重新加载
 */
function reloadBasBankMaintain() {
    basBankMaintainGrid.datagrid('reload');
}


/**
 * 查询
 */
function searchBasBankMaintain() {
    basBankMaintainGrid.datagrid('load', {
        fuzzy: $("#fuzzy").textbox("getValue")
    });
}


/**
 * 增加
 */
function addBasBankMaintain() {
    openSaveDialog({
        title: "添加记录",
        maximized: false,
        width : 350,
        height: 200,
        // contenturl: "/GenForm/form?formcode=BasBankMaintain",
        // submiturl: "/basBankMaintain/saveBasBankMaintain?formcode=BasBankMaintain",
        contenturl:"/view/base/basBankMaintainForm",
        submiturl:"/basBankMaintain/saveBasBankMaintain",
        callback: reloadBasBankMaintain
    });

}


/**
 * 修改
 */
function editBasBankMaintain() {

    var row = basBankMaintainGrid.datagrid('getSelected');
    if (!row) {
        alertWarn('请选择记录!');
        return;
    }

    openSaveDialog({
        title: "修改记录",
        maximized: false,
        width : 350,
        height: 200,
        // contenturl: "/GenForm/form?formcode=BasBankMaintain&id=" + row.bankMaintainId,
        // submiturl: "/basBankMaintain/saveBasBankMaintain?formcode=BasBankMaintain",
        contenturl:"/view/base/basBankMaintainForm",
        submiturl:"/basBankMaintain/saveBasBankMaintain",
        onload : "/basBankMaintain/findBasBankMaintain?id=" + row.bankMaintainId,
        callback: reloadBasBankMaintain
    });
}


/**
 * 删除
 */
function delBasBankMaintain() {

    var row = basBankMaintainGrid.datagrid('getSelected');
    if (!row) {
        alertWarn('请选择记录!');
        return;
    }

    alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
        if (r) {
            $.ajax({
                type: "post",
                url: ctx + "/basBankMaintain/delBasBankMaintain",
                data: {
                    id: row.bankMaintainId
                },
                dataType: 'json',
                success: function (result) {
                    if (result.success) {
                        basBankMaintainGrid.datagrid('reload');
                        alertInfo(result.msg);
                    } else {
                        alertError(result.msg);
                    }
                }
            });
        }
    });

}
