var BasInterfaceInfoDataGrid=$('#BasInterfaceInfo_datagrid');
$(function(){
	initBasInterfaceInfoGrid();
	bindEnterKey('#searchBasInterfaceInfo',searchBasInterfaceInfo);
});

function initBasInterfaceInfoGrid(){
	BasInterfaceInfoDataGrid.datagrid({
		height:$("body").height()-200,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		queryParams:{
			// startDate:$('#sDate').datebox('getValue'),
			// endDate:$('#eDate').datebox('getValue')
		},
		cls:'md',
		toolbar:"#BasInterfaceInfo_datagrid_tb",
	    url:ctx+'/BasInterfaceInfo/pageBasInterfaceInfo',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="BasInterfaceInfoFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'interfaceName',title:'接口名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'interfaceCode',title:'接口编码',width:100,align:'center',halign:'center',sortable:true},
	    {field:'typeIdText',title:'接口目录',width:100,align:'center',halign:'center',sortable:true},
	    {field:'interfaceTypeText',title:'接口类型',width:100,align:'center',halign:'center',sortable:true},
	    {field:'interfaceUrl',title:'接口地址',width:100,align:'center',halign:'center',sortable:true},
	    {field:'displayNo',title:'顺序',width:100,align:'center',halign:'center',sortable:true},
	    {field:'isEnableText',title:'是否启用',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'id',title:'主键',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'interfaceParams',title:'接口参数',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'wsdlFile',title:'接口描述文档',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'remark',title:'说明',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			BasInterfaceInfoFormDetail(row.id);
	    }
	});
    BasInterfaceInfoDataGrid.datagrid('doCellTip');
    var pager = BasInterfaceInfoDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasInterfaceInfo_datagrid',"接口信息维护");
	        }    
	    }]   
	});
}
//查看表单明细
function BasInterfaceInfoFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasInterfaceInfo&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadBasInterfaceInfo(){
	BasInterfaceInfoDataGrid.datagrid('reload');
}
//查询表格
function searchBasInterfaceInfo(){
	BasInterfaceInfoDataGrid.datagrid('load',{
		search:$("#searchBasInterfaceInfo").val(),
		// startDate:$('#sDate').datebox('getValue'),
		// endDate:$('#eDate').datebox('getValue'),
		// applyPerson: $("#applyPerson").textbox('getValue'),
		// applyDept :$("#applyDept").combobox('getValue')
	});
}

//增加记录
function addBasInterfaceInfo() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=BasInterfaceInfo",
		submiturl:"/BasInterfaceInfo/saveBasInterfaceInfo?formcode=BasInterfaceInfo",
//		contenturl:"/view/business/bas/BasInterfaceInfo",
//		submiturl:"/BasInterfaceInfo/saveBasInterfaceInfo",
		callback:reloadBasInterfaceInfo
	});
	
}

//修改记录
function editBasInterfaceInfo() {
	var row = BasInterfaceInfoDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=BasInterfaceInfo&id=" + id,
			submiturl:"/BasInterfaceInfo/saveBasInterfaceInfo?formcode=BasInterfaceInfo",
//			contenturl : "/view/business/bas/BasInterfaceInfo",
//			submiturl : "/BasInterfaceInfo/saveBasInterfaceInfo",
//			onload : "/BasInterfaceInfo/findBasInterfaceInfo?id=" + id,
			callback : reloadBasInterfaceInfo
		});
		
	} else {
		alertWarn('请选择一条记录进行修改');
	}
}

//删除记录
function delBasInterfaceInfo() {
	var row = BasInterfaceInfoDataGrid.datagrid('getSelected');
	if(	row.isEnableText == '启用'){
		alertWarn('状态已启用无法删除');
		return;
	}
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasInterfaceInfo/delBasInterfaceInfo",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							BasInterfaceInfoDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertWarn('请先选择要删除的数据信息');
	}
}
