/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.workflow.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.entity.BasMessage;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.workflow.dao.WfWorkitemAddDao;
import com.guochuang.imp.workflow.entity.WfWorkitemAdd;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class WfWorkitemAddService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private WfWorkitemAddDao wfWorkitemAddDao;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;

    public WfWorkitemAdd findWfWorkitemAdd(Long id) {
        WfWorkitemAdd entity = (WfWorkitemAdd)this.wfWorkitemAddDao.findById(id).get();
        return entity;
    }

    public void saveWfWorkitemAdd(WfWorkitemAdd entity) {
        this.wfWorkitemAddDao.save(entity);
    }

    public void delWfWorkitemAdd(Long id) {
        WfWorkitemAdd entity = (WfWorkitemAdd)this.wfWorkitemAddDao.findById(id).get();
        entity.setIsUse("N");
        this.wfWorkitemAddDao.save(entity);
    }

    public List<WfWorkitemAdd> findByWorkitemid(String addType, Long workitemid) {
        List<WfWorkitemAdd> workitems = this.wfWorkitemAddDao.findByAddTypeAndWorkitemidAndIsUse(addType, workitemid, "Y");
        return workitems;
    }

    public PageObject PageAll(String search, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (applyDept != null) {
            params.put("applyDept", applyDept);
        }
        return this.bSqlHelper.serachPage("workflow.WfWorkitemAdd.select", params, PageRequest.of((int)page, (int)rows));
    }

    public JsonMsg checkSign(Long msgId, String accountIds) {
        JsonMsg jsonmsg = new JsonMsg();
        BasMessage msg = this.msgService.findBasMessage(msgId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processinstid", msg.getProcessinstid());
        for (String accountId : accountIds.split(",")) {
            if (!StringUtils.isNotBlank((String)accountId)) continue;
            params.put("accountId", accountId);
            int cou = this.bSqlHelper.getIntValue("workflow.WfWorkitemAdd.getUndoWorkItem", params);
            if (cou > 0) {
                jsonmsg.setSuccess(false);
                jsonmsg.setMsg(this.basEmpAccountService.findByAccountId(Long.parseLong(accountId)).getAccountName() + "\u5df2\u7ecf\u5728\u5ba1\u6279\u4eba\u5458\u4e2d\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u8bd5");
                return jsonmsg;
            }
            cou = this.bSqlHelper.getIntValue("workflow.WfWorkitemAdd.getUndoAddWorkItem", params);
            if (cou <= 0) continue;
            jsonmsg.setSuccess(false);
            jsonmsg.setMsg(this.basEmpAccountService.findByAccountId(Long.parseLong(accountId)).getAccountName() + "\u5df2\u7ecf\u5904\u4e8e\u52a0\u7b7e\u961f\u5217\u4e2d\uff08\u6d41\u7a0b\u63d0\u4ea4\u540e\u751f\u6548\uff09\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u8bd5");
            return jsonmsg;
        }
        return jsonmsg;
    }
}

