/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.workflow.controller;

import cn.hutool.core.date.DateBetween;
import cn.hutool.core.date.DateUnit;
import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.base.common.spring.SystemControllerLog;
import com.guochuang.imp.base.common.support.LockByKey;
import com.guochuang.imp.base.common.support.SimultaneousEntriesLockByKey;
import com.guochuang.imp.base.common.support.SysConfigEnum;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.entity.BasMessage;
import com.guochuang.imp.base.entity.BasRoles;
import com.guochuang.imp.base.extend.IBasMessageAdditional;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.base.service.BasOrgService;
import com.guochuang.imp.base.service.BasRolesService;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.workflow.controller.FlowSpringBeanUtil;
import com.guochuang.imp.workflow.controller.StrUtil;
import com.guochuang.imp.workflow.controller.WfProcessDefine;
import com.guochuang.imp.workflow.entity.ComparatorLine;
import com.guochuang.imp.workflow.entity.StfBusinessProcess;
import com.guochuang.imp.workflow.entity.StfBusinessType;
import com.guochuang.imp.workflow.entity.StfPageTemplate;
import com.guochuang.imp.workflow.entity.WfActivityParams;
import com.guochuang.imp.workflow.service.FlowUtilService;
import com.guochuang.imp.workflow.service.StfBusinessProcessService;
import com.guochuang.imp.workflow.service.StfBusinessTypeService;
import com.guochuang.imp.workflow.service.StfPageTemplateService;
import com.guochuang.imp.workflow.service.WfConfirmPersonsService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/wf"})
public class WorkFlowController
extends BaseController {
    private final int maxThreadEachKey = 1;
    private final LockByKey<String> lockByKey = new SimultaneousEntriesLockByKey<String>(1);
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private StfBusinessTypeService sbtservice;
    @Autowired
    private StfPageTemplateService sptservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private BasRolesService basRolesService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private WfConfirmPersonsService wfConfirmPersonsService;

    @RequestMapping(value={"/delMydealByProcessinstid"})
    @ResponseBody
    public JsonMsg delMydealByProcessinstid(Long processinstid) {
        this.basmessageService.delMydealByProcessinstid(processinstid);
        return new JsonMsg(true, "\u6570\u636e\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getLineCondition"})
    @ResponseBody
    public Object getLineCondition(HttpServletRequest requestServlet, HttpServletResponse response, String formCode, Long processInstId, String conditon, Long msgid, boolean showtodo, @RequestParam(value="msglevel", defaultValue="0") Long msglevel) throws Exception {
        Map cond = StringUtils.isEmpty((String)conditon) ? new HashMap() : (Map)JSON.parseObject((String)conditon, Map.class);
        cond.put("formCode", formCode);
        LoginUser user = this.getLoginUser(requestServlet);
        ModelAndView modelview = new ModelAndView();
        WfActivityParams params = this.flowUtilservice.getLineCondition(processInstId, user.getAccountid(), cond, formCode);
        if (params.getLines() == null) {
            modelview.addObject("flag", (Object)"0");
        } else {
            ComparatorLine comparator = new ComparatorLine();
            Collections.sort(params.getLines(), comparator);
        }
        if (msgid != null) {
            BasMessage message = this.basmessageService.findBasMessage(msgid);
            modelview.addObject("message", (Object)message);
            modelview.addObject("msglevel", (Object)message.getMsgLevel());
        } else {
            modelview.addObject("msglevel", (Object)msglevel);
        }
        modelview.addObject("params", (Object)params);
        modelview.addObject("showtodo", (Object)showtodo);
        modelview.setViewName("workflow/flowSubmit");
        return modelview;
    }

    @RequestMapping(value={"/getWfActivityParams"})
    @ResponseBody
    public Object getWfActivityParams(HttpServletRequest requestServlet, HttpServletResponse response, Long processInstId, String conditon, String formCode) throws Exception {
        Map cond = StringUtils.isEmpty((String)conditon) ? new HashMap() : (Map)JSON.parseObject((String)conditon, Map.class);
        JsonMsg msg = cond.containsKey("corgCode") && cond.containsKey("corgName") ? this.docFormFileService.checkBillInfo(formCode, Objects.toString(cond.get("businessMainId"), ""), Objects.toString(cond.get("corgName"), ""), Objects.toString(cond.get("corgCode"), ""), formCode) : this.docFormFileService.checkBillInfo(formCode, Objects.toString(cond.get("businessMainId"), ""), new String[0]);
        if (!"Y".equals(MemCache.getConfigValue(SysConfigEnum.INVOICE_INVALITE_SUBMIT.toString())) && !msg.isSuccess()) {
            msg.setAlertType("alert");
            return msg;
        }
        cond.put("formCode", formCode);
        return new JsonMsg(true, "\u67e5\u8be2\u6210\u529f", this.flowUtilservice.getLineCondition(processInstId, this.getLoginUser(requestServlet).getAccountid(), cond, formCode));
    }

    @RequestMapping(value={"/getLineConditionDD"})
    @ResponseBody
    public Object getLineConditionDD(HttpServletRequest requestServlet, HttpServletResponse response, String formCode, Long processInstId, String conditon, Long msgid, boolean showtodo, @RequestParam(value="msglevel", defaultValue="0") Long msglevel) throws Exception {
        Map cond = StringUtils.isEmpty((String)conditon) ? new HashMap() : (Map)JSON.parseObject((String)conditon, Map.class);
        cond.put("formCode", formCode);
        LoginUser user = this.getLoginUser(requestServlet);
        HashMap<String, Object> map = new HashMap<String, Object>();
        WfActivityParams params = this.flowUtilservice.getLineCondition(processInstId, user.getAccountid(), cond, formCode);
        if (params.getLines() == null) {
            map.put("flag", "0");
        } else {
            ComparatorLine comparator = new ComparatorLine();
            Collections.sort(params.getLines(), comparator);
        }
        if (msgid != null) {
            BasMessage message = this.basmessageService.findBasMessage(msgid);
            map.put("message", message);
            map.put("msglevel", message.getMsgLevel());
        } else {
            map.put("msglevel", msglevel);
        }
        map.put("params", params);
        map.put("showtodo", showtodo);
        return map;
    }

    @RequestMapping(value={"/getNextWFParticipant"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getNextWFParticipant(HttpServletRequest request, long processinstid, String toActId, String isCopy, String formCode) throws Exception {
        PageObject<Map<String, String>> page = new PageObject<Map<String, String>>();
        page.setRows(this.flowUtilservice.getNextWFParticipant(processinstid, toActId, isCopy, formCode));
        return page;
    }

    @RequestMapping(value={"/getNextWFParticipantIds"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getNextWFParticipantIds(HttpServletRequest request, long processinstid, String toActId, String isCopy, String formCode) {
        HashMap<String, Object> formparams = new HashMap();
        try {
            formparams = this.flowUtilservice.getFormParams(processinstid, formCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JsonMsg(true, this.flowUtilservice.getNextWFParticipantIds(processinstid, toActId, isCopy, formCode, formparams));
    }

    @RequestMapping(value={"/getRollableAct"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getRollableAct(Long msgId, String busiMainId, Long processinstid, String formCode) {
        ModelAndView view = new ModelAndView();
        this.flowUtilservice.getRollableAct(view, msgId, busiMainId, processinstid, formCode);
        return view.getModelMap();
    }

    @RequestMapping(value={"/excuteFlowWithMsgIds"})
    @ResponseBody
    public Object excuteFlowWithMsgIds(HttpServletRequest request, Long[] msgIds, String flowline, String advice) {
        JsonMsg msg = this.flowUtilservice.excuteFlowWithMsgIds(msgIds, flowline, advice, this.getLoginUser(request).getAccountid());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/excuteFlow"})
    @ResponseBody
    @SystemControllerLog(description="\u6267\u884c\u6d41\u7a0b")
    public Object excuteFlow(HttpServletRequest requestServlet, Long processInstId, String formCode, String businessMainId, String captcha, String condition, String toActId, String TH, String advice, String follows, String jumpacts, String conds, String title, Long msglevel, String listUrl, String nextPerson, String backActId, Long workItemId, String signpic, String copyPersons, String backoptions, String fileIds, String actAttitude, String attitudeOptions) throws DocumentException {
        this.lockByKey.lock(processInstId.toString());
        try {
            if ("0".equals(attitudeOptions)) {
                this.flowUtilservice.stopFlow(formCode, processInstId, businessMainId, workItemId, signpic, follows, actAttitude, attitudeOptions);
                JsonMsg jsonMsg = new JsonMsg(true, "\u6d41\u7a0b\u6d41\u8f6c\u53d1\u9001\u6210\u529f");
                return jsonMsg;
            }
            if (StringUtils.isBlank((String)backActId) && this.wfConfirmPersonsService.findAffirmWayByAccountId(SysUtils.getLoginAccountId(), this.flowUtilservice.getFlowIdByProcessinstId(processInstId)) != null) {
                Date sendTime = (Date)requestServlet.getSession().getAttribute("flowCaptchaSendtime");
                String roundCode = (String)requestServlet.getSession().getAttribute("flowCaptcha");
                if (sendTime != null && DateBetween.create((Date)sendTime, (Date)new Date()).between(DateUnit.SECOND) > 600L) {
                    requestServlet.getSession().removeAttribute("flowCaptchaSendtime");
                    requestServlet.getSession().removeAttribute("flowCaptcha");
                    JsonMsg jsonMsg = new JsonMsg(false, "\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
                    return jsonMsg;
                }
                if (!StringUtils.equals((String)captcha, (String)roundCode)) {
                    JsonMsg jsonMsg = new JsonMsg(false, "\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                    return jsonMsg;
                }
                requestServlet.getSession().removeAttribute("flowCaptchaSendtime");
                requestServlet.getSession().removeAttribute("flowCaptcha");
            }
            HashMap<String, Object> cond = new HashMap<String, Object>();
            cond.put("formCode", formCode);
            cond.put("businessMainId", businessMainId);
            if (StringUtils.isNotBlank((String)jumpacts)) {
                for (int i = 0; i < Arrays.asList(jumpacts.split("@#@")).size(); ++i) {
                    String jumpact = Arrays.asList(jumpacts.split("@#@")).get(i);
                    String condtion = Arrays.asList(conds.split("@#@")).get(i);
                    if (!StringUtils.isNotBlank((String)jumpact)) continue;
                    for (int j = 0; j < Arrays.asList(jumpact.split(",")).size(); ++j) {
                        String act = Arrays.asList(jumpact.split(",")).get(j);
                        String con = Arrays.asList(condtion.split(",", -1)).get(j);
                        this.flowUtilservice.excuteFlow(processInstId, this.getLoginUser(requestServlet).getAccountid(), this.getLoginUser(requestServlet).getOrgid(), formCode, businessMainId, con, act, TH, advice, title, msglevel, null, null, backActId, workItemId, signpic, copyPersons, backoptions, follows, fileIds, actAttitude, attitudeOptions);
                        WfActivityParams params = this.flowUtilservice.getWfActivityParams(processInstId, this.getLoginUser(requestServlet).getAccountid(), cond);
                        workItemId = params.getWorkItem().getWorkItemId();
                        if (params.isValidate()) continue;
                        JsonMsg jsonMsg = new JsonMsg(false, params.getUnvalidateMsg());
                        return jsonMsg;
                    }
                }
            }
            this.flowUtilservice.excuteFlow(processInstId, this.getLoginUser(requestServlet).getAccountid(), this.getLoginUser(requestServlet).getOrgid(), formCode, businessMainId, condition, toActId, TH, advice, title, msglevel, listUrl, nextPerson, backActId, workItemId, signpic, copyPersons, backoptions, follows, fileIds, actAttitude, attitudeOptions);
            JsonMsg jsonMsg = new JsonMsg(true, "\u6d41\u7a0b\u53d1\u9001\u6210\u529f");
            return jsonMsg;
        }
        catch (GEPSBisException e) {
            JsonMsg jsonMsg = new JsonMsg(false, e.getMessage());
            return jsonMsg;
        }
        finally {
            this.lockByKey.unlock(processInstId.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/rollbackFlow"})
    @ResponseBody
    @SystemControllerLog(description="\u6d41\u7a0b\u64a4\u56de")
    public Object rollbackFlow(HttpServletRequest requestServlet, Long msgId, String busiMainId, Long processinstid, String formCode, String workmemory, String roleType) throws DocumentException {
        this.lockByKey.lock(processinstid.toString());
        try {
            if (msgId != null) {
                this.flowUtilservice.rollbackFlow(msgId, workmemory, roleType);
            } else {
                this.flowUtilservice.rollbackFlow(busiMainId, processinstid, formCode, workmemory, roleType);
            }
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                bma.onRollbackFlow(requestServlet, msgId, busiMainId, processinstid, formCode);
            }
            JsonMsg jsonMsg = new JsonMsg(true, "\u6d41\u7a0b" + roleType + "\u6210\u529f");
            return jsonMsg;
        }
        catch (GEPSBisException e) {
            JsonMsg jsonMsg = new JsonMsg(false, e.getMessage());
            return jsonMsg;
        }
        finally {
            this.lockByKey.unlock(processinstid.toString());
        }
    }

    @RequestMapping(value={"/addSign"})
    @ResponseBody
    @SystemControllerLog(description="\u6d41\u7a0b\u52a0\u7b7e")
    public Object addSign(HttpServletRequest requestServlet, Long msgId, String accoundIds, String type) throws DocumentException {
        try {
            this.flowUtilservice.addSign(msgId, accoundIds, type);
            return new JsonMsg(true, "\u6d41\u7a0b\u52a0\u7b7e\u6210\u529f");
        }
        catch (GEPSBisException e) {
            return new JsonMsg(false, e.getMessage());
        }
    }

    public void stfBusinessProcessSave(StfBusinessProcess entity) {
        this.sbpservice.save(entity);
    }

    public void stfBusinessProcessUpdate(StfBusinessProcess entity) {
        this.sbpservice.update(entity);
    }

    public void stfBusinessProcessDelete(StfBusinessProcess entity) {
        this.sbpservice.delete(entity);
    }

    public void findStfBusinessProcess(Long id) {
        this.sbpservice.find(id);
    }

    public void findStfBusinessProcessByType(Object businessTypeId) {
        this.sbpservice.findByBusinessTypeId(businessTypeId);
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object findAll(HttpServletRequest requestServlet, Integer start, Integer limit, String flowName, String designName, String type, String level) throws IOException {
        List<StfBusinessProcess> list = this.sbpservice.findAll(flowName, designName, type, level);
        PageObject<StfBusinessProcess> result = new PageObject<StfBusinessProcess>();
        result.setRows(list.subList(start, start + limit > list.size() ? list.size() : start + limit));
        result.setTotal(list.size());
        return result;
    }

    @RequestMapping(value={"/queryWorkFlowVersion"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryWorkFlowVersion(HttpServletRequest requestServlet) throws Exception {
        String processDefName = requestServlet.getParameter("processDefName");
        List<?> tmp = this.sbpservice.queryWorkFlowVersion(processDefName);
        ArrayList<WfProcessDefine> list = new ArrayList<WfProcessDefine>();
        for (int i = 0; i < tmp.size(); ++i) {
            WfProcessDefine wf = new WfProcessDefine();
            Map map = (Map)tmp.get(i);
            wf.setProcessDefId(Long.valueOf(map.get("PROCESSDEFID").toString()));
            wf.setProcessDefName(map.get("PROCESSDEFNAME").toString());
            if (map.get("PROCESSCHNAME") != null) {
                wf.setProcesschname(map.get("PROCESSCHNAME").toString());
            }
            wf.setDescription(map.get("DESCRIPTION").toString());
            wf.setCurrentstate(Integer.parseInt(map.get("CURRENTSTATE").toString()));
            wf.setCurrentstateText(map.get("CURRENTSTATETEXT").toString());
            wf.setVersionsign(map.get("VERSIONSIGN").toString());
            wf.setLimittime(map.get("LIMITTIME").toString());
            wf.setCreateName(map.get("CREATENAME").toString());
            wf.setCreatetime((Date)map.get("CREATETIME"));
            wf.setUpdatetime((Date)map.get("UPDATETIME"));
            list.add(wf);
        }
        PageObject<WfProcessDefine> result = new PageObject<WfProcessDefine>();
        result.setRows(list);
        result.setTotal(tmp.size());
        return result;
    }

    @RequestMapping(value={"/queryFlowContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processinstid, String actid, HttpServletResponse reponse) throws IOException, SQLException {
        return this.sbpservice.queryFlowContent(id, processinstid);
    }

    @RequestMapping(value={"/queryWorkItem"})
    @ResponseBody
    public Object queryWorkItem(HttpServletRequest requestServlet) throws IOException {
        List<StfBusinessType> list = this.sbtservice.findAll();
        ArrayList<StfBusinessType> temp = new ArrayList<StfBusinessType>();
        for (StfBusinessType businessType : list) {
            if (businessType.getParentId() != 0L) continue;
            temp.add(businessType);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        for (int i = 0; i < temp.size(); ++i) {
            sb.append("<node id=\"" + ((StfBusinessType)temp.get(i)).getResId() + "\" label=\"" + StrUtil.encodeString(((StfBusinessType)temp.get(i)).getName()) + "\" level=\"" + ((StfBusinessType)temp.get(i)).getLevels() + "\" type=\"organization\" >\n");
            if ("N".equals(((StfBusinessType)temp.get(i)).getLeafName())) {
                this.getAllParentLabel((StfBusinessType)temp.get(i), list, sb);
            }
            sb.append("</node>\n");
        }
        return sb.toString();
    }

    @RequestMapping(value={"/querySpringBean"}, method={RequestMethod.POST})
    @ResponseBody
    public Object querySpringBean(HttpServletRequest requestServlet) throws IOException {
        String type = "";
        if (!StringUtils.isEmpty((String)requestServlet.getParameter("type"))) {
            type = requestServlet.getParameter("type").toString();
        }
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        if ("IActivityTriggerEvent".equals(type)) {
            List<String> worklist;
            if (list == null) {
                list = new ArrayList<String>();
            }
            if ((worklist = FlowSpringBeanUtil.querySpringBean("IWorkItemTriggerEvent")) != null) {
                list.addAll(worklist);
            }
        }
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        if (list != null && !list.isEmpty()) {
            for (String name : list) {
                sb.append("<node value=\"" + name + "\" name=\"" + name + "\" />\n");
            }
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryPageTemplates4Flex"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryPageTemplates4Flex(HttpServletRequest requestServlet) throws IOException {
        Long busiId = 0L;
        if (requestServlet.getParameter("busiId") != null && !"".equals(requestServlet.getParameter("busiId"))) {
            busiId = Long.valueOf(requestServlet.getParameter("busiId").toString());
        }
        List<StfPageTemplate> list = this.sptservice.findByBusinessTypeId(busiId);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (StfPageTemplate template : list) {
            sb.append("<node id=\"" + template.getResId() + "\" name=\"" + template.getName() + "\" />\n");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryParticipant4Org"}, method={RequestMethod.GET})
    @ResponseBody
    public Object queryParticipant4Org(HttpServletRequest requestServlet, Long id) throws IOException {
        if (id == null) {
            id = 0L;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        List<ComBoxTreeNode> orglist = this.basOrgService.findOrgTree(id);
        for (ComBoxTreeNode node : orglist) {
            sb.append("<node id=\"" + node.getId() + "\" name=\"" + node.getText() + "\" type=\"organization\" >");
            sb.append("</node>");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryParticipant4User"})
    @ResponseBody
    public void queryParticipant4User(HttpServletResponse response, HttpServletRequest requestServlet, Long orgId) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (orgId == null) {
            orgId = 0L;
        }
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        List<BasEmpAccount> accountlist = this.basEmpAccountService.findByOrgId(orgId);
        for (BasEmpAccount account : accountlist) {
            sb.append("<node id=\"" + account.getAccountId() + "\" name=\"" + account.getAccountName() + "\" type=\"person\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryParticipant4Role"}, method={RequestMethod.GET})
    @ResponseBody
    public Object queryParticipant4Role(HttpServletRequest requestServlet) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<BasRoles> rolelist = this.basRolesService.findAll();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (BasRoles role : rolelist) {
            sb.append("<node id=\"" + role.getRoleId() + "\" name=\"" + role.getRoleName() + "\" type=\"role\" />\n");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryParticipant"}, method={RequestMethod.GET})
    @ResponseBody
    public Object queryParticipant(HttpServletRequest requestServlet) throws IOException {
        List<BasRoles> rolelist = this.basRolesService.findAll();
        ArrayList nodes = new ArrayList(rolelist.size());
        for (BasRoles role : rolelist) {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("id", role.getRoleId().toString());
            node.put("text", role.getRoleName());
            node.put("leaf", true);
            node.put("type", "role");
            nodes.add(node);
        }
        return nodes;
    }

    @RequestMapping(value={"/queryOrgModel"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryOrgModel(HttpServletRequest requestServlet) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("</menuitem>");
        return sb.toString();
    }

    @RequestMapping(value={"/querySubFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object querySubFlow(HttpServletRequest requestServlet) throws IOException {
        Long id = 0L;
        if (!StringUtils.isEmpty((String)requestServlet.getParameter("id"))) {
            id = Long.valueOf(requestServlet.getParameter("id").toString());
        }
        List<StfBusinessType> busiTypes = null;
        List<StfBusinessProcess> busiProcesses = null;
        if (id == 0L) {
            busiTypes = this.sbtservice.findByParentId(id);
        } else {
            StfBusinessType businessType = this.sbtservice.findById(id);
            if ("N".equals(businessType.getLevels())) {
                busiTypes = this.sbtservice.findByParentId(id);
            } else {
                busiProcesses = this.sbpservice.findByBusinessTypeId((Object)id);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        if (busiTypes != null) {
            for (StfBusinessType busiType : busiTypes) {
                sb.append("<node id=\"" + busiType.getResId() + "\" name=\"" + busiType.getName() + "\" type=\"busi\" />\n");
            }
        }
        if (busiProcesses != null) {
            for (StfBusinessProcess busiProcess : busiProcesses) {
                if (!"subflow".equals(busiProcess.getType())) continue;
                sb.append("<node id=\"flow." + busiProcess.getId() + "\" name=\"" + busiProcess.getText() + "\" type=\"subflow\" />\n");
            }
        }
        sb.append("</node>");
        return sb.toString();
    }

    private void getAllParentLabel(StfBusinessType bt, List<StfBusinessType> list, StringBuilder sb) {
        ArrayList<StfBusinessType> temp2 = new ArrayList<StfBusinessType>();
        for (StfBusinessType businessType : list) {
            if (!businessType.getParentId().equals(bt.getResId())) continue;
            temp2.add(businessType);
            sb.append("<node id=\"" + businessType.getResId() + "\" label=\"" + StrUtil.encodeString(businessType.getName()) + "\" level=\"" + businessType.getLevels() + "\" type=\"organization\" >\n");
            if ("N".equals(businessType.getLeafName())) {
                this.getAllParentLabel(businessType, list, sb);
            }
            sb.append("</node>\n");
        }
    }

    @RequestMapping(value={"/getLastDealPersonMap"})
    @ResponseBody
    public Object getLastDealPerson(Long processinstId, String toActId) {
        List<Map<String, Object>> list = this.flowUtilservice.getLastDealPersonMap(processinstId, toActId);
        PageObject<Map<String, Object>> pb = new PageObject<Map<String, Object>>(list, Long.valueOf(list.size()));
        return pb;
    }

    @RequestMapping(value={"/judgeIsCreator"})
    @ResponseBody
    public Object judgeIsCreator(HttpServletRequest request, String accountId, String processinstId) {
        JsonMsg msg = new JsonMsg();
        msg = this.flowUtilservice.judgeIsCreator(accountId, processinstId);
        return msg;
    }

    @RequestMapping(value={"/transferWorkitem"})
    @ResponseBody
    public Object transferWorkitem(HttpServletRequest request, Long msgId, Long toPerson, String remark) throws GEPSBisException, DocumentException {
        JsonMsg msg = new JsonMsg();
        this.flowUtilservice.transferWorkitem(msgId, toPerson, remark);
        return msg;
    }

    @RequestMapping(value={"/delMydealByProcessinstidAll"})
    @ResponseBody
    public JsonMsg delMydealByProcessinstidAll(String processinstid) {
        this.basmessageService.delMydealByProcessinstidAll(processinstid);
        return new JsonMsg(true, "\u6570\u636e\u5220\u9664\u6210\u529f");
    }
}

