/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.util;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.font.FontProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class PDFUtil {
    private static final Logger logger = Logger.getLogger(PDFUtil.class);
    private static final String WATERMARK_TEXT = "sy";
    private static final String FONT_PATH = "/static/style/font/simsun.ttf";

    public static void convertToPdf(InputStream inputStream, OutputStream outputStream) throws IOException {
        PdfWriter pdfWriter = new PdfWriter(outputStream);
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(PageSize.A4);
        ConverterProperties properties = new ConverterProperties();
        FontProvider fontProvider = new FontProvider();
        ClassPathResource classPathFontResource = new ClassPathResource(FONT_PATH);
        String font_resource_path = "";
        font_resource_path = classPathFontResource.getURL().getPath();
        PdfFont microsoft = PdfFontFactory.createFont((String)font_resource_path, (String)"Identity-H", (boolean)false);
        fontProvider.addFont(microsoft.getFontProgram(), "Identity-H");
        properties.setFontProvider(fontProvider);
        inputStream = PDFUtil.readInputStream(inputStream);
        if (inputStream != null) {
            HtmlConverter.convertToPdf((InputStream)inputStream, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        } else {
            logger.error((Object)"PDF\u8f6c\u6362\u5931\u8d25\uff01");
        }
    }

    private static InputStream readInputStream(InputStream inputStream) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            String content = baos.toString();
            inputStream.close();
            baos.close();
            Pattern compile = Pattern.compile("&[a-zA-Z]{1,10};", 2);
            Matcher matcher = compile.matcher(content);
            String replaceAll = matcher.replaceAll("");
            return PDFUtil.getStringStream(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static InputStream getStringStream(String sInputString) {
        if (sInputString != null && !sInputString.trim().equals("")) {
            try {
                return new ByteArrayInputStream(sInputString.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

