/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DEFAULT_DATETIME = "yyyy-MM-dd HH:mm:ss";

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static <T> T str2Obj(String str, Class<T> clazz) {
        if (str != null && !"".equals(str.trim()) && clazz != null) {
            try {
                return (T)(clazz.equals(String.class) ? str : objectMapper.readValue(str, clazz));
            }
            catch (Exception e) {
                logger.error("Parse String to Object error : {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static <T> T str2Obj(String str, TypeReference<T> typeReference) {
        if (str != null && !"".equals(str.trim()) && typeReference != null) {
            try {
                return (T)(typeReference.getType().equals(String.class) ? str : objectMapper.readValue(str, typeReference));
            }
            catch (Exception e) {
                logger.error("Parse String to Object error : {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static <T> T str2Obj(String str, Class<?> collectionClazz, Class<?> ... elementClazzes) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClazz, (Class[])elementClazzes);
        try {
            return (T)objectMapper.readValue(str, javaType);
        }
        catch (IOException e) {
            logger.warn("Parse String to Object error : {}" + e.getMessage());
            return null;
        }
    }

    public static <T> String obj2Str(T obj) {
        if (obj != null) {
            try {
                return obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                logger.warn("Parse Object to String error : {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static <T> String obj2StrPretty(T obj) {
        if (obj != null) {
            try {
                return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                logger.warn("Parse Object to String error : {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<?> clazz) {
        try {
            Object obj = clazz.newInstance();
            if (map != null && !map.isEmpty() && map.size() > 0) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String propertyName = entry.getKey();
                    Object value = entry.getValue();
                    String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                    Field field = JsonUtil.getClassField(clazz, propertyName);
                    if (field == null) continue;
                    Class<?> fieldTypeClass = field.getType();
                    value = JsonUtil.convertValType(value, fieldTypeClass);
                    try {
                        clazz.getMethod(setMethodName, field.getType()).invoke(obj, value);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
            }
            return (T)obj;
        }
        catch (Exception e1) {
            logger.error("Map\u8f6cBean\u5931\u8d25\uff01", (Throwable)e1);
            return null;
        }
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        if (Object.class.getName().equals(clazz.getName())) {
            return null;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return JsonUtil.getClassField(superClass, fieldName);
        }
        return null;
    }

    private static Object convertValType(Object value, Class<?> fieldTypeClass) {
        Object retVal = null;
        retVal = Long.class.getName().equals(fieldTypeClass.getName()) || Long.TYPE.getName().equals(fieldTypeClass.getName()) ? Long.valueOf(Long.parseLong(value.toString())) : (Integer.class.getName().equals(fieldTypeClass.getName()) || Integer.TYPE.getName().equals(fieldTypeClass.getName()) ? Integer.valueOf(Integer.parseInt(value.toString())) : (Float.class.getName().equals(fieldTypeClass.getName()) || Float.TYPE.getName().equals(fieldTypeClass.getName()) ? Float.valueOf(Float.parseFloat(value.toString())) : (Double.class.getName().equals(fieldTypeClass.getName()) || Double.TYPE.getName().equals(fieldTypeClass.getName()) ? Double.valueOf(Double.parseDouble(value.toString())) : value)));
        return retVal;
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(DEFAULT_DATETIME));
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

