/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.util;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlPage;

public class HtmlUnitUtil {
    private static final Logger logger = Logger.getLogger(HtmlUnitUtil.class);

    public static void webClient(String url, String savePath, List<String> needRemoveElementIdList) throws IOException {
        try {
            WebClient webClient = new WebClient(BrowserVersion.CHROME);
            webClient.getOptions().setJavaScriptEnabled(true);
            webClient.getOptions().setCssEnabled(true);
            webClient.getOptions().setThrowExceptionOnScriptError(false);
            webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
            webClient.getOptions().setUseInsecureSSL(false);
            webClient.getOptions().setRedirectEnabled(false);
            HtmlPage page = (HtmlPage)webClient.getPage(url);
            for (String id : needRemoveElementIdList) {
                try {
                    page.getHtmlElementById(id).remove();
                }
                catch (ElementNotFoundException e) {
                    logger.warn((Object)(id + "\u5f85\u5220\u9664\u8282\u70b9\u672a\u627e\u5230"));
                }
            }
            webClient.waitForBackgroundJavaScript(1000L);
            String htmlContent = page.asXml();
            try (FileWriter writer = new FileWriter(savePath);){
                writer.write(htmlContent);
            }
            webClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

