/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.sys.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.entity.PubArea;
import com.guochuang.imp.pub.service.PubAreaService;
import com.guochuang.imp.sys.dao.BasCourtDao;
import com.guochuang.imp.sys.entity.BasCourt;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasCourtService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasCourtDao bascourtDao;
    @Autowired
    private PubAreaService pubAreaService;

    public BasCourt findBasCourt(Long id) {
        BasCourt basCourt = (BasCourt)this.bascourtDao.findById(id).get();
        if (basCourt.getRegionId() != null) {
            PubArea pubArea = this.pubAreaService.findPubArea(basCourt.getRegionId());
            basCourt.setRegionName(pubArea.getAreaFullName());
        }
        return basCourt;
    }

    public void saveBasCourt(BasCourt entity) {
        this.bascourtDao.save(entity);
    }

    public void delBasCourt(Long id) {
        BasCourt entity = (BasCourt)this.bascourtDao.getOne(id);
        entity.setIsUse("N");
        this.bascourtDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("sys.BasCourt.select", params, PageRequest.of((int)page, (int)rows));
    }
}

