/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.report.service;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.DataSourceutil;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.report.dao.ReportBaseDsDao;
import com.guochuang.imp.report.entity.ReportBaseDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ReportBaseDsService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private ReportBaseDsDao reportbasedsDao;
    @Autowired
    private DataSourceutil dataSourceutil;
    private static final Logger logger = Logger.getLogger(ReportBaseDsService.class);

    public ReportBaseDs findReportBaseDs(Long id) {
        ReportBaseDs entity = (ReportBaseDs)this.reportbasedsDao.findById(id).get();
        return entity;
    }

    public void saveReportBaseDs(ReportBaseDs entity) {
        this.reportbasedsDao.save(entity);
    }

    public void delReportBaseDs(Long id) {
        ReportBaseDs entity = (ReportBaseDs)this.reportbasedsDao.findById(id).get();
        entity.setIsUse("N");
        this.reportbasedsDao.save(entity);
    }

    public List<ComBoxTreeNode> treeReportBaseDs(Long reportId) {
        List<ReportBaseDs> dslist = this.reportbasedsDao.findByReportIdAndIsUse(reportId, "Y");
        ArrayList<ComBoxTreeNode> treeList = new ArrayList<ComBoxTreeNode>(dslist.size());
        for (ReportBaseDs ds : dslist) {
            ComBoxTreeNode node = new ComBoxTreeNode();
            node.setId(ds.getId().toString());
            node.setText(ds.getDsName());
            node.setState("closed");
            node.setIconCls("icon-datasource");
            if (ds.getSqlScript() != null) {
                logger.info((Object)("[\u89e3\u6790sql\u5b57\u6bb5]\uff1a\n" + ds.getSqlScript()));
                Map<String, Map<String, Object>> sqlcolumns = this.dataSourceutil.getColunms(ds.getSqlScript());
                for (String field : sqlcolumns.keySet()) {
                    ComBoxTreeNode child = new ComBoxTreeNode();
                    child.setId(field);
                    child.setText(field);
                    child.setIconCls("icon-field");
                    node.addChild(child);
                }
            }
            treeList.add(node);
        }
        return treeList;
    }
}

