/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubContactDao;
import com.guochuang.imp.pub.entity.PubContact;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContactService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubContactDao pubContactDao;

    public PubContact findPubContact(Long id) {
        PubContact entity = (PubContact)this.pubContactDao.findById(id).get();
        return entity;
    }

    public List<Map<String, Object>> findByForeignId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", id);
        return this.bSqlHelper.getMapList("pub.PubContact.select", params);
    }

    public void savePubContact(PubContact entity) {
        this.pubContactDao.save(entity);
    }

    public void delPubContact(Long id) {
        PubContact entity = (PubContact)this.pubContactDao.findById(id).get();
        entity.setIsUse("N");
        this.pubContactDao.save(entity);
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + " \n");
        }
        return this.bSqlHelper.serachPage("pub.PubContact.select", params, PageRequest.of((int)page, (int)rows));
    }
}

