/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubAssetsSourceDao;
import com.guochuang.imp.pub.entity.PubAssetsSource;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PubAssetsSourceService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubAssetsSourceDao pubAssetsSourceDao;

    public PageObject pageAll(String fuzzy, String status, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        if (!StringUtil.isEmpty(status)) {
            params.put("status", status);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("pub.PubAssetsSource.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("statusText", MemCache.getDicText("IS_ENABLE", StringUtil.null2String(map.get("status"))));
            map.put("isHandworkText", MemCache.getDicText("IS_USE", StringUtil.null2String(map.get("isHandwork"))));
        }
        return pageObject;
    }

    @Transactional
    public void savePubAssetsSource(PubAssetsSource entity) {
        this.pubAssetsSourceDao.save(entity);
    }

    public PubAssetsSource findPubAssetsSource(Long id) {
        PubAssetsSource entity = (PubAssetsSource)this.pubAssetsSourceDao.findById(id).get();
        return entity;
    }

    public void delPubAssetsSource(Long id) {
        PubAssetsSource entity = (PubAssetsSource)this.pubAssetsSourceDao.findById(id).get();
        entity.setIsUse("N");
        this.pubAssetsSourceDao.save(entity);
    }

    public List<ComboxNode> getAssetsSourceCombo(String bizType, String isHandWork) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(bizType)) {
            params.put("bizType", bizType);
        }
        if (!StringUtil.isEmpty(isHandWork)) {
            params.put("isHandWork", isHandWork);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubAssetsSource.getAssetsSourceCombo", params);
        return ComboxUtils.buildComboxNodes(list);
    }
}

