/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.pub.dao.PubAssetsAttrDao;
import com.guochuang.imp.pub.entity.PubAssetsAttr;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PubAssetsAttrService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubAssetsAttrDao pubAssetsAttrDao;

    public List<Map<String, Object>> pageAll(Long mainId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mainId", mainId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubAssetsAttr.pageAll", params);
        return list;
    }

    @Transactional
    public void savePubAssetsAttr(String data) {
        List list = JSON.parseArray((String)data, PubAssetsAttr.class);
        for (PubAssetsAttr entiy : list) {
            if (entiy.getAttrId() == null) {
                entiy.setCreateTime(new Date());
                entiy.setCreateAccount(SysUtils.getLoginAccountId());
            } else {
                entiy.setModifyTime(new Date());
                entiy.setModifyAccount(SysUtils.getLoginAccountId());
            }
            entiy.setIsUse("Y");
        }
        this.pubAssetsAttrDao.saveAll(list);
    }

    public PubAssetsAttr findPubAssetsAttr(Long id) {
        PubAssetsAttr entity = (PubAssetsAttr)this.pubAssetsAttrDao.findById(id).get();
        return entity;
    }

    public void delPubAssetsAttr(Long id) {
        PubAssetsAttr entity = (PubAssetsAttr)this.pubAssetsAttrDao.findById(id).get();
        entity.setIsUse("N");
        this.pubAssetsAttrDao.save(entity);
    }

    public List<ComBoxTreeNode> getGroupAccount() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", SysContent.GROUP_ORG);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubAssetsAttr.getGroupAccount", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComboxNode> getComboByCategoryId(Long categoryId, String detailId) {
        if (categoryId == null) {
            if (StringUtils.isEmpty((String)detailId)) {
                return Collections.emptyList();
            }
            List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubAssetsAttr.getComboByCategoryId", MapUtil.builder().put((Object)"categoryId", (Object)detailId).build());
            return ComboxUtils.buildComboxNodes(list);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubAssetsAttr.getComboByCategoryId", MapUtil.builder().put((Object)"categoryId", (Object)categoryId).build());
        return ComboxUtils.buildComboxNodes(list);
    }
}

