/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.pub.dao.PubAreaDao;
import com.guochuang.imp.pub.entity.PubArea;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubAreaService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private PubAreaDao basareaDao;

    public PubArea findPubArea(Long id) {
        PubArea entity = (PubArea)this.basareaDao.findById(id).get();
        return entity;
    }

    @CacheEvict(cacheNames={"AreaCache"}, allEntries=true)
    public void savePubArea(PubArea entity) {
        this.basareaDao.save(entity);
    }

    @CacheEvict(cacheNames={"AreaCache"}, allEntries=true)
    public void delPubArea(Long id) {
        this.basareaDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        String sql = "select * from PUB_AREA t  order by t.AREA_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from PUB_AREA t where   upper(t.AREA_TYPE) like ?1  or upper(t.COUNTRY_ID) like ?1  or upper(t.AREA_ID) like ?1  or upper(t.AREA_CODE) like ?1  or upper(t.AREA_NAME) like ?1  or upper(t.PAREA_ID) like ?1  or upper(t.IN_OUTSIDE_CODE) like ?1  or upper(t.IN_OUTSIDE) like ?1  or upper(t.DELTA_AREA_CODE) like ?1  or upper(t.DELTA_AREA_NAME) like ?1  or upper(t.COUNTRY_PROVINCE_ID) like ?1  or upper(t.COUNTRY_PROVINCE_CODE) like ?1  or upper(t.COUNTRY_PROVINCE_NAME) like ?1  or upper(t.UNION_CODE) like ?1  or upper(t.UNION_NAME) like ?1  or upper(t.IS_USE) like ?1  or upper(t.AREA_FULL_NAME) like ?1  order by t.AREA_ID";
            return this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        }
        return this.sqlHelper.pagerNativeSQL(sql, page, rows);
    }

    @CacheEvict(cacheNames={"AreaCache"}, allEntries=true)
    public void delPubAreaAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive AREA as\n\t (select m.* from PUB_AREA m \n\t where   m.AREA_ID = ?1  and m.is_use='Y' \n\t union all\n\t select m.* from PUB_AREA m,AREA  where  m.PAREA_ID=AREA.AREA_ID and m.is_use='Y'\n\t )\tDELETE FROM \tPUB_AREA T \n\tWHERE \tT.AREA_ID in ( \n\t\tSELECT \tA.AREA_ID \n\t\tFROM \tAREA A) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    @Cacheable(cacheNames={"AreaCache"}, key="targetClass + '.' + methodName + '.'+#root.args[0]")
    public List<ComBoxTreeNode> treePubArea(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive menu as\n\t (select m.* from PUB_AREA m \n\t where   m.PAREA_ID = ?1  and m.is_use='Y' \n\t union all\n\t select m.* from PUB_AREA m,menu  where  m.PAREA_ID=menu.AREA_ID and m.is_use='Y'\n\t )\n select \n\t\t\tt.AREA_ID id, \n\t\t\tT.PAREA_ID PID, \n\t\t\tt.AREA_NAME text, \n\t\t\tt.area_full_name \n from menu t");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treePubAreaAnsy(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.AREA_ID id, \n\t\t\tT.PAREA_ID PID, \n     \tt.AREA_NAME text, \n     \t (case when (select count(1) from PUB_AREA where parea_id = t.area_id) =0 then 'open' else 'closed' end ) as state, \n     \tt.area_full_name \n FROM \tPUB_AREA T where T.PAREA_ID = ?1 and t.is_use='Y' order by t.area_code");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComboxNode> queryPubAreaByCity(String levels) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)levels)) {
            params.put("levels", levels);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubArea.queryPubAreaByCity", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<String> getCityPickerData() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getList("pub.PubArea.getCityPickerData", params, String.class);
    }

    public PubArea findByRegionCode(String regionCode) {
        List<PubArea> list = this.basareaDao.findByAreaCodeAndIsUse(regionCode, "Y");
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }
}

