/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.controller.LoginController;
import com.guochuang.imp.base.entity.BasInterfaceInfo;
import com.guochuang.imp.base.service.BasInterfaceInfoService;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.pub.dao.PubContactOrgAccountDao;
import com.guochuang.imp.pub.dao.PubContactOrgDao;
import com.guochuang.imp.pub.entity.PubArea;
import com.guochuang.imp.pub.entity.PubContactOrg;
import com.guochuang.imp.pub.entity.PubContactOrgType;
import com.guochuang.imp.pub.service.PubAreaService;
import com.guochuang.imp.pub.service.PubContactOrgService;
import com.guochuang.imp.pub.service.PubContactOrgTypeService;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.webservice.IQianZhanOrgService;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/PubContactOrg"})
public class PubContactOrgController
extends BaseController {
    @Autowired
    private PubContactOrgService pubContactOrgService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubContactOrgTypeService pubContactOrgTypeService;
    @Autowired
    private PubAreaService pubareaService;
    @Autowired
    private PubContactOrgAccountDao pubContactOrgAccountDao;
    @Autowired
    private PubContactOrgDao pubContactOrgDao;
    @Autowired(required=false)
    private IQianZhanOrgService qianZhanOrgService;
    @Autowired
    private BasInterfaceInfoService basInterfaceInfoService;
    private static Logger loger = LoggerFactory.getLogger(LoginController.class);

    @RequestMapping(value={"/pagePubContactOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactOrg(HttpServletRequest request, Long flowDone, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, Long contactOrgTypeId, String type, String contactType) {
        return this.pubContactOrgService.PageAll(flowDone, search, page, rows, sort, order, contactOrgTypeId, type, contactType);
    }

    @RequestMapping(value={"/findPubContactOrg"})
    @ResponseBody
    public Object findPubContactOrg(Long id) {
        PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(id);
        if (entity != null) {
            PubArea area;
            PubContactOrgType type;
            if (entity.getContactOrgTypeId() != null && (type = this.pubContactOrgTypeService.findPubContactOrgType(entity.getContactOrgTypeId())) != null) {
                entity.setContactOrgTypeId_TEXT_(type.getContactOrgTypeName());
            }
            if (entity.getAreaId() != null && (area = this.pubareaService.findPubArea(entity.getAreaId())) != null) {
                entity.setAreaId_TEXT_(area.getAreaFullName());
            }
        }
        return entity;
    }

    @RequestMapping(value={"/toOrgAccountPage"})
    public String toOrgAccountPage(Long id, Model model) {
        BasInterfaceInfo info;
        if (id != null) {
            List<Map<String, Object>> dataPCOAList = this.pubContactOrgService.findByContactOrgId(id);
            model.addAttribute("dataPCOAList", dataPCOAList);
        }
        if ((info = this.basInterfaceInfoService.findByInterfaceCodeAndIsUse("bank")) != null && "1".equals(info.getIsEnable())) {
            model.addAttribute("isChoose", (Object)true);
        }
        return "/pub/PubContactOrgAccount";
    }

    @RequestMapping(value={"/savePubContactOrg"})
    @ResponseBody
    public Object savePubContactOrg(HttpServletRequest request, PubContactOrg entity, FormFileBean formfile, String formcode) throws GEPSBisException {
        LoginUser user = this.getLoginUser(request);
        Long id = entity.getContactOrgId();
        entity.setContactOrgName(StrKit.replaceAllBlank(entity.getContactOrgName()));
        entity.setContactOrgName(StrKit.replaceChSign(entity.getContactOrgName()));
        JsonMsg msg = this.pubContactOrgService.checkrepeat(entity);
        if (!msg.isSuccess()) {
            return msg;
        }
        entity.setModifyAccount(user.getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (StringUtils.isBlank((CharSequence)entity.getContactType())) {
            entity.setContactType("1");
        }
        if ((entity.getWorkflowStatus() == null || entity.getWorkflowStatus().toString().indexOf("1") != -1) && StringUtil.isEmpty(entity.getType())) {
            msg.setSuccess(false);
            msg.setMsg("\u5ba2\u6237/\u4f9b\u5e94\u5546\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg;
        }
        entity = this.pubContactOrgService.savePubContactOrg(entity, formfile);
        if (id == null || entity.getProcessinstid() == null) {
            try {
                Long processinstid = this.flowUtilService.createAndStartProcess(user.getAccountid(), formcode, entity.getContactOrgId());
                entity.setProcessinstid(processinstid);
            }
            catch (Exception e) {
                loger.error("\u5ba2\u5546\u521b\u5efa\u6d41\u7a0b\u5931\u8d25", (Object)e.getMessage());
            }
        }
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delPubContactOrg"})
    @ResponseBody
    public Object delPubContactOrg(Long id) {
        this.pubContactOrgService.delPubContactOrg(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/pullPubContactOrg"})
    @ResponseBody
    public Object pullPubContactOrg(HttpServletRequest request, Long id, String formcode) throws GEPSBisException {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        if (id != null) {
            this.flowUtilService.createAndStartProcess(this.getLoginUser(request).getAccountid(), formcode, id);
            PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(id);
            msg.setO(entity);
        } else {
            msg.setMsg("\u8bf7\u5148\u9009\u62e9\u6765\u5f80\u5355\u4f4d\u6570\u636e");
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/initFLow"})
    @ResponseBody
    public Object initFLow(HttpServletRequest request, Long contactOrgId, String formcode) throws GEPSBisException {
        LoginUser user = this.getLoginUser(request);
        JsonMsg msg = new JsonMsg();
        if (contactOrgId != null) {
            PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(contactOrgId);
            if (entity.getProcessinstid() == null || SysContent.DEFAULT_STATUS.equals(entity.getWorkflowStatus())) {
                this.flowUtilService.createAndStartProcess(user.getAccountid(), formcode, entity.getContactOrgId());
            }
            entity = this.pubContactOrgService.findPubContactOrg(contactOrgId);
            msg.setO(entity);
        } else {
            msg.setMsg("\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u5355\u4f4d\u6570\u636e");
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/pagePubContactOrgSelWin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactOrgSelWin(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="type", defaultValue="1") String type, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="100") int rows, @RequestParam(value="pubContactOrgIds", defaultValue="") String pubContactOrgIds, String sort, String order, Long contactOrgTypeId, Long contactOrgTypeCode) {
        return this.pubContactOrgService.PageAllSelWin(type, pubContactOrgIds, search, page, rows, sort, order, contactOrgTypeId, contactOrgTypeCode);
    }

    @RequestMapping(value={"/pagePubContactBlockSelWin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactBlockSelWin(HttpServletRequest request, String contactOrgTypeId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="type", defaultValue="1") String type, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="100") int rows, String sort, String order) {
        return this.pubContactOrgService.pagePubContactBlockSelWin(contactOrgTypeId, type, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findPubContactOrgTypeByPubContactOrgId"})
    @ResponseBody
    public PubContactOrgType findPubContactOrgTypeByPubContactOrgId(Long id) {
        return this.pubContactOrgService.findPubContactOrgTypeByPubContactOrgId(id);
    }

    @RequestMapping(value={"/checkContactOrgData"})
    @ResponseBody
    public Object checkContactOrgData(HttpServletRequest request, String orgName, String contactOrgCode, String type, Long contactOrgId) throws GEPSBisException {
        orgName = StrKit.replaceAllBlank(orgName);
        contactOrgCode = StrKit.replaceChSign(contactOrgCode);
        JsonMsg msg = this.pubContactOrgService.checkContactOrgData(orgName, contactOrgCode, type, contactOrgId);
        return msg;
    }

    @RequestMapping(value={"/getContractOrgByCon"}, method={RequestMethod.POST})
    @ResponseBody
    public Object gegContractOrgByCon(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="100") int rows, String sort, String order, String currentLat, String currentLng, String distance, String type) {
        return this.pubContactOrgService.getContractOrgByCon(currentLat, currentLng, distance, type, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/getOrgInfoByName"})
    @ResponseBody
    public Object getOrgInfoByName(HttpServletRequest request, String name, String type, Long orgId) {
        if (this.pubContactOrgService.hasrepeatOrgName(name, orgId, type)) {
            return new JsonMsg(false, "\u5355\u4f4d\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5f55\u5165");
        }
        String msg = this.qianZhanOrgService.listOrgInfoByName(name);
        JSONObject obj = JSON.parseObject((String)msg);
        if (obj == null) {
            return new JsonMsg(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", null);
        }
        return new JsonMsg(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", obj.getJSONArray("result"));
    }
}

