/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.service;

import com.alibaba.fastjson.JSONArray;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.gen.dao.GenActItemDao;
import com.guochuang.imp.gen.entity.GenActItem;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenActItemService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GenActItemDao genactitemDao;

    public GenActItem findGenActItem(String id) {
        GenActItem entity = (GenActItem)this.genactitemDao.findById(id).get();
        return entity;
    }

    public List<GenActItem> findBySettingId(String settingId) {
        return this.genactitemDao.findBySettingIdAndIsUse(settingId, "Y");
    }

    public void saveGenActItem(GenActItem entity) {
        this.genactitemDao.save(entity);
    }

    public void saveGenActItemList(String data, String settingId, String actId, String panelType) {
        List list = JSONArray.parseArray((String)data, GenActItem.class);
        Long i = 0L;
        for (GenActItem item : list) {
            item.setSettingId(settingId);
            item.setActId(actId);
            item.setIsUse("Y");
            item.setModifyAccount(SysUtils.getLoginAccountId());
            item.setModifyTime(new Date());
            item.setPanelType(panelType);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
            item.setDisplayNo(l);
            if (item.getId() != null) continue;
            item.setCreateAccount(item.getModifyAccount());
            item.setCreateTime(item.getModifyTime());
        }
        this.genactitemDao.saveAll(list);
    }

    public void delGenActItem(String id) {
        GenActItem entity = (GenActItem)this.genactitemDao.findById(id).get();
        entity.setIsUse("N");
        this.genactitemDao.save(entity);
    }

    public void delGenActItemBySetting(String settingId) {
        List<GenActItem> entities = this.findBySettingId(settingId);
        for (GenActItem entity : entities) {
            entity.setIsUse("N");
        }
        this.genactitemDao.saveAll(entities);
    }

    public PageObject PageAll(Long accountId, String id, String actId, String panelType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("actId", actId);
        if (StrKit.notNull(panelType)) {
            params.put("panelType", panelType);
        }
        return this.bSqlHelper.serachPage("gen.GenActItem.select", params);
    }
}

