/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.controller;

import com.guochuang.imp.base.common.support.LockByKey;
import com.guochuang.imp.base.common.support.SimultaneousEntriesLockByKey;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.gen.entity.GenActItem;
import com.guochuang.imp.gen.service.GenActItemService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/GenActItem"})
public class GenActItemController
extends BaseController {
    @Autowired
    private GenActItemService genactitemService;
    private final int maxThreadEachKey = 1;
    private final LockByKey<String> lockByKey = new SimultaneousEntriesLockByKey<String>(1);
    private static Logger loger = LoggerFactory.getLogger(GenActItemController.class);

    @RequestMapping(value={"/pageGenActItem"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGenActItem(HttpServletRequest request, String id, String actId, String panelType) {
        Long accountId = this.getLoginUser(request).getAccountid();
        return this.genactitemService.PageAll(accountId, id, actId, panelType);
    }

    @RequestMapping(value={"/findGenActItem"})
    @ResponseBody
    public Object findGenActItem(String id) {
        GenActItem entity = this.genactitemService.findGenActItem(id);
        return entity;
    }

    @RequestMapping(value={"/saveGenActItem"})
    @ResponseBody
    public Object saveGenActItem(HttpServletRequest request, GenActItem entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.genactitemService.saveGenActItem(entity);
        msg.setO(entity);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/saveGenActItemList"})
    @ResponseBody
    public Object saveGenActItemList(HttpServletRequest request, String data, String settingId, String actId, String panelType) {
        JsonMsg msg;
        this.lockByKey.lock(settingId);
        try {
            msg = new JsonMsg();
            this.genactitemService.saveGenActItemList(data, settingId, actId, panelType);
            msg.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            loger.error("", (Throwable)e);
            msg = new JsonMsg();
            msg.setSuccess(false);
            msg.setMsg("\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        finally {
            this.lockByKey.unlock(settingId);
        }
        return msg;
    }

    @RequestMapping(value={"/delGenActItem"})
    @ResponseBody
    public Object delGenActItem(String id) {
        this.genactitemService.delGenActItem(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/changeStatus"})
    @ResponseBody
    public Object changeStatus(HttpServletRequest request, GenActItem entity) {
        if (entity.getId() != null) {
            GenActItem model = this.genactitemService.findGenActItem(entity.getId());
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            entity.setCreateAccount(model.getCreateAccount());
            entity.setCreateTime(model.getCreateTime());
            entity.setOrgId(model.getOrgId());
        } else {
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
            entity.setOrgId(this.getLoginUser(request).getOrgid());
        }
        this.genactitemService.saveGenActItem(entity);
        return new JsonMsg();
    }
}

