/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.service;

import com.guochuang.imp.base.common.util.FileUtils;
import com.guochuang.imp.doc.common.FileService;
import com.guochuang.imp.doc.service.DocFileService;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.service.GenFormService;
import com.guochuang.imp.util.HtmlUnitUtil;
import com.guochuang.imp.util.PDFUtil;
import com.guochuang.imp.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PdfService {
    public static Logger loger = Logger.getLogger(DocFileService.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private GenFormService genFormService;

    public void getPdfFile(HttpServletRequest request, HttpServletResponse response, String JSESSIONID, String printUrl) {
        String requestUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String fileName = "tempFileFolder\\html\\" + UUID.randomUUID() + ".html";
        printUrl = printUrl + "&JSESSIONID=" + JSESSIONID;
        try {
            ArrayList<String> needRemoveElementIdList = new ArrayList<String>();
            needRemoveElementIdList.add("printDiv");
            needRemoveElementIdList.add("getPDF");
            HtmlUnitUtil.webClient(requestUrl + printUrl, fileName, needRemoveElementIdList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            List<String> downFiles = PdfService.generatePdf(fileName);
            this.fileService.downloadFilesByLocalPaths(response, downFiles);
        }
        catch (Exception e) {
            e.printStackTrace();
            loger.error((Object)"\u8f6c\u6362PDF\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPdfFileByBusinessInfo(HttpServletRequest request, HttpServletResponse response, String JSESSIONID, String businessInfo) {
        List<Map<String, Object>> downloadList = this.getDownloadInfo(businessInfo);
        String requestUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        List<String> fileNames = this.downloadHtml(requestUrl, JSESSIONID, downloadList);
        ArrayList<String> downFiles = new ArrayList();
        try {
            downFiles = PdfService.generatePdf(fileNames);
            this.fileService.downloadFilesByLocalPaths(response, downFiles);
        }
        catch (Exception e) {
            e.printStackTrace();
            loger.error((Object)"\u8f6c\u6362PDF\u5931\u8d25");
        }
        finally {
            fileNames.forEach(fileName -> {
                File file = new File((String)fileName);
                file.delete();
            });
            downFiles.forEach(fileName -> {
                File file = new File((String)fileName);
                file.delete();
            });
        }
    }

    private List<String> downloadHtml(String requestUrl, String JSESSIONID, List<Map<String, Object>> downloadList) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            ArrayList<String> needRemoveElementIdList = new ArrayList<String>();
            needRemoveElementIdList.add("printDiv");
            needRemoveElementIdList.add("getPDF");
            for (Map<String, Object> downloadItem : downloadList) {
                if (StringUtil.isEmpty(downloadItem.get("printUrl")) || downloadItem.get("busiMainId") == null) continue;
                String businessInfo = downloadItem.get("printUrl").toString() + "?id=" + downloadItem.get("busiMainId");
                businessInfo = businessInfo + "&JSESSIONID=" + JSESSIONID;
                String folderName = "tempFileFolder\\html\\";
                File folder = new File(folderName);
                if (!folder.exists()) {
                    FileUtils.createFolder(folderName);
                }
                String fileName = folderName + downloadItem.get("fileName").toString() + ".html";
                fileNames.add(fileName);
                HtmlUnitUtil.webClient(requestUrl + businessInfo, fileName, needRemoveElementIdList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileNames;
    }

    private List<Map<String, Object>> getDownloadInfo(String businessInfo) {
        String[] businessInfoArray;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String string : businessInfoArray = businessInfo.split(",")) {
            if (StringUtil.isEmpty(string) || string.split(":").length != 2) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formCode", string.split(":")[0]);
            map.put("busiMainId", string.split(":")[1]);
            map.put("printUrl", "");
            map.put("fileName", "");
            list.add(map);
        }
        HashMap<String, String> printMap = new HashMap<String, String>();
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        for (Map map : list) {
            if (StringUtil.isNotEmpty(printMap.get(map.get("formCode").toString()))) {
                map.put("printUrl", printMap.get(map.get("formCode").toString()));
                continue;
            }
            GenForm genForm = this.genFormService.findByFormCode(map.get("formCode").toString());
            map.put("printUrl", genForm.getPrintAddr());
            printMap.put(map.get("formCode").toString(), genForm.getPrintAddr());
            fileNameMap.put(map.get("formCode").toString(), genForm.getFormName());
        }
        for (Map map : list) {
            map.put("fileName", fileNameMap.get(map.get("formCode").toString()) + map.get("busiMainId").toString());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFile(String urlParam, String filepath, boolean needCreateFolder) {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = new URL(urlParam);
            File file = new File(filepath);
            if (needCreateFolder) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filepath, new String[0]), new OpenOption[0]));
            conn = url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static List<String> generatePdf(String path) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(path);
        return PdfService.generatePdf(fileNames);
    }

    private static List<String> generatePdf(List<String> fileNames) throws Exception {
        String pdfDirPath = "tempFileFolder\\pdf\\";
        File file = new File(pdfDirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        ArrayList<String> pdfPaths = new ArrayList<String>();
        for (String fileName : fileNames) {
            String fileNameFinal = fileName.replace("tempFileFolder\\html\\", "");
            fileNameFinal = fileNameFinal.replace(".html", "");
            String pdfPath = pdfDirPath + fileNameFinal + ".pdf";
            pdfPaths.add(pdfPath);
            FileInputStream inputStream = new FileInputStream(new File(fileName));
            FileOutputStream outputStream = new FileOutputStream(pdfPath);
            PDFUtil.convertToPdf(inputStream, outputStream);
        }
        return pdfPaths;
    }
}

