/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.controller;

import cn.dev33.satoken.temp.SaTempUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpUtil;
import com.guochuang.imp.base.common.spring.SystemControllerLog;
import com.guochuang.imp.base.common.support.FileType;
import com.guochuang.imp.base.common.support.SysConfigEnum;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.PdfWaterMark;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.fileupload.ProgressEntity;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.doc.common.FileService;
import com.guochuang.imp.doc.common.ocr.AipOcrCilentUtils;
import com.guochuang.imp.doc.common.ocr.InvoiceInfo;
import com.guochuang.imp.doc.common.persist.FileInfo;
import com.guochuang.imp.doc.common.util.BillInfo;
import com.guochuang.imp.doc.common.util.FileHelper;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.doc.common.util.ScanResult;
import com.guochuang.imp.doc.entity.DocFileType;
import com.guochuang.imp.doc.entity.DocFileVersion;
import com.guochuang.imp.doc.entity.DocFormFile;
import com.guochuang.imp.doc.service.DocFileLogService;
import com.guochuang.imp.doc.service.DocFileService;
import com.guochuang.imp.doc.service.DocFileTypeService;
import com.guochuang.imp.doc.service.DocFileVersionService;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.dao.GenPanelFileDao;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.entity.GenPanelFile;
import com.guochuang.imp.gen.service.GenFormService;
import com.guochuang.imp.gen.util.FreeMarkerUtil;
import com.guochuang.imp.sys.util.ListUtils;
import com.guochuang.imp.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaTypeFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/file"})
public class FileController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private FileHelper fileHelper;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocFileService docfileService;
    @Autowired
    private DocFileVersionService docfileversionService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private DocFileTypeService docFileTypeService;
    @Autowired
    private GenFormService genformService;
    @Autowired
    private GenPanelFileDao genpanelfileDao;
    @Autowired
    private DocFileLogService docFileLogService;
    @Autowired
    private BasMessageService basMessageService;
    @Autowired
    private AipOcrCilentUtils aipOcrCilentUtils;

    @RequestMapping(value={"/filechoose"})
    public ModelAndView choosefile(HttpServletRequest request, FileInfo fileinfo, String fileTypeId, @RequestParam(value="showlocal", defaultValue="true") boolean showlocal, @RequestParam(value="showvisual", defaultValue="true") boolean showvisual, @RequestParam(value="showscan", defaultValue="true") boolean showscan, @RequestParam(value="filtersql", defaultValue="") String filtersql, String accept) {
        ModelAndView view = new ModelAndView();
        String scantype = "1";
        if (fileTypeId != null) {
            DocFileType filetype = this.docFileTypeService.findDocFileType(fileTypeId);
            if (filetype != null && filetype.getFileNature() != null && filetype.getFileNature() == 2L) {
                scantype = "3";
            }
            if (filetype != null && filetype.getFileNature() != null) {
                view.addObject("fileNature", (Object)filetype.getFileNature());
            }
            if (filetype != null && StringUtils.isNotBlank((CharSequence)filetype.getAllowTypes())) {
                accept = Stream.of(filetype.getAllowTypes().replaceAll(";", ",").replaceAll("^,|,$", "").split(",")).map(type -> MediaTypeFactory.getMediaType((String)("file." + type)).orElse(null)).filter(type -> type != null).map(type -> type.toString()).collect(Collectors.joining(","));
            }
        }
        view.setViewName("/common/filechoose");
        view.addObject("accept", (Object)accept);
        view.addObject("scantype", (Object)scantype);
        view.addObject("fileinfo", (Object)fileinfo);
        view.addObject("showlocal", (Object)showlocal);
        view.addObject("showvisual", (Object)showvisual);
        view.addObject("showscan", (Object)showscan);
        view.addObject("filtersql", (Object)filtersql);
        view.addObject("jsessionid", (Object)request.getSession().getId());
        view.addObject("IOPServer", (Object)request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath())));
        return view;
    }

    @RequestMapping(value={"/multifile"})
    public ModelAndView multifile(HttpServletRequest request, FileInfo fileinfo, String fileTypeId, @RequestParam(value="muli", defaultValue="true") boolean muli, @RequestParam(value="showlocal", defaultValue="true") boolean showlocal, @RequestParam(value="showvisual", defaultValue="true") boolean showvisual, @RequestParam(value="showscan", defaultValue="true") boolean showscan, @RequestParam(value="filtersql", defaultValue="") String filtersql) {
        ModelAndView view = new ModelAndView();
        String scantype = "1";
        if (fileTypeId != null) {
            DocFileType filetype = this.docFileTypeService.findDocFileType(fileTypeId);
            if (filetype != null && filetype.getFileNature() != null && filetype.getFileNature() == 2L) {
                scantype = "3";
            }
            if (filetype != null && filetype.getFileNature() != null) {
                view.addObject("fileNature", (Object)filetype.getFileNature().toString());
            }
            if (filetype != null && StringUtils.isNotBlank((CharSequence)filetype.getAllowTypes())) {
                view.addObject("allowTypes", (Object)filetype.getAllowTypes().replaceAll(";", ",").replaceAll("^,|,$", ""));
            }
        }
        view.setViewName("/common/multifile");
        view.addObject("scantype", (Object)scantype);
        view.addObject("fileinfo", (Object)fileinfo);
        view.addObject("showlocal", (Object)showlocal);
        view.addObject("showvisual", (Object)showvisual);
        view.addObject("showscan", (Object)showscan);
        view.addObject("jsessionid", (Object)request.getSession().getId());
        view.addObject("filtersql", (Object)filtersql);
        view.addObject("muli", (Object)muli);
        view.addObject("IOPServer", (Object)request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath())));
        return view;
    }

    @RequestMapping(value={"/multiupload"})
    @ResponseBody
    public Object multiupload(HttpServletRequest request, HttpServletResponse response, FileInfo fileinfo, String base64, String catalogid, String fileName) throws IllegalStateException, IOException, FileStoreException, InterruptedException, ExecutionException {
        CommonsMultipartResolver multipartResolver;
        fileinfo.setLoginuser(this.getLoginUser(request));
        if (StringUtil.isNotEmpty(base64)) {
            File file = this.fileService.base64ToFile(base64, fileName.replace(fileName.substring(fileName.indexOf(".")), ""));
            MultipartFile multipartFile = this.fileService.getMultipartFile(file);
            fileinfo.setCatalogid(catalogid);
            fileinfo = this.fileService.upLoadFile(multipartFile, fileinfo);
            fileinfo.setLoginuser(null);
        }
        if ((multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext())).isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String apppath;
                MultipartFile file = multiRequest.getFile((String)iter.next());
                fileinfo = this.fileService.upLoadFile(file, fileinfo);
                Long versionid = fileinfo.getVersionid();
                String string = apppath = !"-".equals(this.fileService.getServerUrl()) ? this.fileService.getServerUrl() : request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath()));
                if (!this.fileHelper.isOffice(file.getOriginalFilename())) continue;
                new Thread(() -> {
                    try {
                        String url = apppath + "/file/download/" + SaTempUtil.createToken((Object)versionid, (long)30L) + "." + FilenameUtils.getExtension((String)file.getOriginalFilename()) + "?versionid=" + versionid + "&usebase=true&fullfilename=" + versionid + "." + FilenameUtils.getExtension((String)file.getOriginalFilename());
                        String result1 = HttpUtil.get((String)(this.fileService.getPreviewserver() + "/addTask?url=" + URLEncoder.encode(url, "utf-8")));
                        logger.info(versionid + "\u8c03\u7528\u6587\u4ef6\u8f6c\u6362\u7ed3\u679c\uff1a" + result1);
                    }
                    catch (Exception e) {
                        logger.error(versionid + "\u8c03\u7528\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                    }
                }).start();
            }
            fileinfo.setLoginuser(null);
        }
        return fileinfo.getVersionid();
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public Object upload(HttpServletRequest request, HttpServletResponse response, FileInfo fileinfo) throws IllegalStateException, IOException, FileStoreException, InterruptedException, ExecutionException {
        Object uploadprogress = request.getSession().getAttribute("uploadprogress");
        fileinfo.setLoginuser(this.getLoginUser(request));
        if (uploadprogress != null) {
            ProgressEntity progress = (ProgressEntity)uploadprogress;
            progress.setPercent(96L);
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (multipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
                Iterator iter = multiRequest.getFileNames();
                progress.setPercent(97L);
                while (iter.hasNext()) {
                    MultipartFile file = multiRequest.getFile((String)iter.next());
                    fileinfo = this.fileService.upLoadFile(file, fileinfo);
                    progress.setPercent(99L);
                }
                progress.setPercent(100L);
                fileinfo.setLoginuser(null);
            }
        }
        return new JsonMsg(true, "\u4e0a\u4f20\u5b8c\u6210", fileinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/multiuploadscan"})
    @ResponseBody
    public Object multiuploadscan(HttpServletRequest request, HttpServletResponse response, FileInfo fileinfo) throws IllegalStateException, IOException, FileStoreException, InterruptedException, ExecutionException {
        fileinfo.setLoginuser(this.getLoginUser(request));
        ArrayList<InvoiceInfo> list = new ArrayList<InvoiceInfo>();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                InvoiceInfo info = new InvoiceInfo();
                FileInfo fi = new FileInfo();
                fi.setCatalogid(fileinfo.getCatalogid());
                fi.setProjectid(fileinfo.getProjectid());
                fi.setLoginuser(fileinfo.getLoginuser());
                MultipartFile file = multiRequest.getFile((String)iter.next());
                fi = this.fileService.upLoadFile(file, fi);
                if ("3".equals(request.getParameter("scantype"))) {
                    fi = this.fileService.getFileInfo(fi);
                    String path = this.fileService.getLocalpath() + "/invoice/" + System.currentTimeMillis() + file.getOriginalFilename();
                    File temp = new File(path);
                    if (!new File(this.fileService.getLocalpath() + "/invoice/").exists()) {
                        new File(this.fileService.getLocalpath() + "/invoice/").mkdirs();
                    }
                    FileUtil.writeFromStream((InputStream)fi.getIs(), (String)path);
                    info.setFileName(file.getOriginalFilename());
                    try {
                        info = this.aipOcrCilentUtils.getInvoiceInfo(path);
                    }
                    catch (Exception e) {
                        logger.error("\u53d1\u7968ocr\u8bc6\u522b\u5931\u8d25\uff1a" + e);
                        JsonMsg jsonMsg = new JsonMsg(false, "\u53d1\u7968ocr\u8bc6\u522b\u5931\u8d25\uff1a", info);
                        return jsonMsg;
                    }
                    finally {
                        temp.delete();
                    }
                }
                list.add(info);
                info.setFileName(fi.getFilename());
                info.setVersionid(fi.getVersionid());
            }
            fileinfo.setLoginuser(null);
        }
        return new JsonMsg(true, "\u53d1\u7968\u8bc6\u522b\u6210\u529f", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/multiuploadocr1"})
    @ResponseBody
    public Object multiuploadocr1(HttpServletRequest request, HttpServletResponse response, FileInfo fileinfo) throws IllegalStateException, IOException, FileStoreException, InterruptedException, ExecutionException {
        fileinfo.setLoginuser(this.getLoginUser(request));
        ArrayList<InvoiceInfo> list = new ArrayList<InvoiceInfo>();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                InvoiceInfo info = new InvoiceInfo();
                FileInfo fi = new FileInfo();
                fi.setCatalogid(fileinfo.getCatalogid());
                fi.setProjectid(fileinfo.getProjectid());
                fi.setLoginuser(fileinfo.getLoginuser());
                MultipartFile file = multiRequest.getFile((String)iter.next());
                fi = this.fileService.upLoadFile(file, fi);
                fi = this.fileService.getFileInfo(fi);
                String path = this.fileService.getLocalpath() + "/invoice/" + System.currentTimeMillis() + file.getOriginalFilename();
                File temp = new File(path);
                if (!new File(this.fileService.getLocalpath() + "/invoice/").exists()) {
                    new File(this.fileService.getLocalpath() + "/invoice/").mkdirs();
                }
                FileUtil.writeFromStream((InputStream)fi.getIs(), (String)path);
                info.setFileName(file.getOriginalFilename());
                try {
                    info = this.aipOcrCilentUtils.getInvoiceInfo(path);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u7968ocr\u8bc6\u522b\u5931\u8d25\uff1a" + e);
                    JsonMsg jsonMsg = new JsonMsg(false, "\u53d1\u7968ocr\u8bc6\u522b\u5931\u8d25\uff1a", info);
                    return jsonMsg;
                }
                finally {
                    temp.delete();
                }
                list.add(info);
                info.setFileName(fi.getFilename());
                info.setVersionid(fi.getVersionid());
            }
            fileinfo.setLoginuser(null);
        }
        return new JsonMsg(true, "\u53d1\u7968\u8bc6\u522b\u6210\u529f", list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/multiuploadocr"})
    @ResponseBody
    public Object multiuploadocr(HttpServletRequest request, HttpServletResponse response, FileInfo fileinfo) throws IllegalStateException, IOException, FileStoreException, InterruptedException, ExecutionException {
        fileinfo.setLoginuser(this.getLoginUser(request));
        InvoiceInfo info = new InvoiceInfo();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)iter.next());
                fileinfo = this.fileService.upLoadFile(file, fileinfo);
                fileinfo = this.fileService.getFileInfo(fileinfo);
                String path = this.fileService.getLocalpath() + "/invoice/" + System.currentTimeMillis() + file.getOriginalFilename();
                File temp = new File(path);
                if (!new File(this.fileService.getLocalpath() + "/invoice/").exists()) {
                    new File(this.fileService.getLocalpath() + "/invoice/").mkdirs();
                }
                FileUtil.writeFromStream((InputStream)fileinfo.getIs(), (String)path);
                info.setFileName(file.getOriginalFilename());
                try {
                    info = this.aipOcrCilentUtils.getInvoiceInfo(path);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u7968ocr\u8bc6\u522b\u5931\u8d25\uff1a" + e);
                    JsonMsg jsonMsg = new JsonMsg(false, "\u53d1\u7968ocr\u8bc6\u522b\u5931\u8d25\uff1a", info);
                    return jsonMsg;
                }
                finally {
                    temp.delete();
                }
            }
            fileinfo.setLoginuser(null);
        }
        info.setVersionid(fileinfo.getVersionid());
        return new JsonMsg(true, "\u53d1\u7968\u8bc6\u522b\u6210\u529f", info);
    }

    @RequestMapping(value={"/getIfExist"})
    @ResponseBody
    public Object getIfExist(HttpServletRequest request, HttpServletResponse response, String md5, String scantype, FileInfo fileinfo) {
        this.docfileversionService.findByMd5(md5);
        List<DocFileVersion> versions = this.docfileversionService.findByMd5(md5);
        if (!versions.isEmpty() && !"3".equals(scantype)) {
            fileinfo.setMd5(versions.get(0).getMd5());
            fileinfo.setUUID(versions.get(0).getUUID());
            fileinfo.setSha1(versions.get(0).getSha1());
            fileinfo.setAppType(SysContent.APP_TYPE_IOP);
            this.fileService.saveFileVersion(fileinfo);
            return new JsonMsg(true, "\u627e\u5230\u5bf9\u5e94\u6587\u4ef6", fileinfo);
        }
        return new JsonMsg(false, "\u6ca1\u6709\u5bf9\u5e94\u6587\u4ef6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/appUpload"})
    @ResponseBody
    public Object appUpload(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="fileName", defaultValue="") String fileName) throws IOException {
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        Iterator iter = multiRequest.getFileNames();
        while (iter.hasNext()) {
            MultipartFile multipartFile = multiRequest.getFile((String)iter.next());
        }
        ServletOutputStream outStream = response.getOutputStream();
        String imgStr = request.getParameter("filestr");
        byte[] b = Base64.decodeBase64((String)imgStr);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        Date dte = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String strDate = sdf.format(dte);
        try (OutputStream out = null;){
            String imgFilePath = "D:\\app\\" + fileName + strDate + ".jpg";
            out = new FileOutputStream(imgFilePath);
            out.write(b);
            out.flush();
        }
        return null;
    }

    @RequestMapping(value={"/uploadprogress"})
    @ResponseBody
    public Object uploadprogress(HttpServletRequest request, HttpServletResponse response) throws IllegalStateException, IOException {
        Object o = request.getSession().getAttribute("uploadprogress");
        JsonMsg msg = new JsonMsg();
        if (o != null) {
            ProgressEntity progress = (ProgressEntity)request.getSession().getAttribute("uploadprogress");
            msg.setO(progress.getPercent());
        } else {
            msg.setO(0L);
        }
        return msg;
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    @CrossOrigin
    @SystemControllerLog(description="\u6587\u4ef6\u4e0b\u8f7d")
    public void download(HttpServletRequest request, HttpServletResponse response, Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase, String isView) throws FileStoreException {
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        fileinfo.setIsView(isView);
        this.fileService.download(response, fileinfo);
        this.docFileLogService.saveFileLog(this.getLoginUser(request), versionid, request, "\u6587\u4ef6\u4e0b\u8f7d");
    }

    @RequestMapping(value={"/canDownload"})
    @ResponseBody
    public JsonMsg canDownload(HttpServletRequest request, HttpServletResponse response, Long versionid) throws FileStoreException {
        return new JsonMsg(this.fileService.canDownLoadsource(versionid), "");
    }

    @CrossOrigin
    @RequestMapping(value={"/download/{token}"})
    @ResponseBody
    @SystemControllerLog(description="\u6587\u4ef6\u4e0b\u8f7d")
    public void downloadForView(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="token") String token, @RequestParam(value="usebase", defaultValue="true") boolean usebase) throws FileStoreException {
        Long versionid;
        if (this.getLoginUser(request) == null) {
            try {
                versionid = (Long)SaTempUtil.parseToken((String)token, Long.class);
            }
            catch (Exception e) {
                logger.warn("\u83b7\u53d6token\u53c2\u6570\u5931\u8d25\uff1atoken\u3010" + token + "\u3011 \u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
                return;
            }
        }
        try {
            versionid = Long.parseLong(token);
        }
        catch (Exception e) {
            try {
                versionid = (Long)SaTempUtil.parseToken((String)token, Long.class);
            }
            catch (Exception e1) {
                logger.warn("\u83b7\u53d6token\u53c2\u6570\u5931\u8d25\uff1atoken\u3010" + token + "\u3011 \u9519\u8bef\u539f\u56e0\uff1a" + e1.getMessage());
                return;
            }
        }
        if (("0".equals(token) || versionid == 0L) && "Y".equals(request.getParameter("yozo"))) {
            String fileType = request.getParameter("fileType");
            FreeMarkerUtil.instance().generFile(request, response, "xls".equals(fileType) ? "/template/newexcel.ftl" : "/template/newword.ftl", request.getParameter("fileName"), MapUtil.of((Object)"fileType", (Object)fileType));
            return;
        }
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        this.fileService.download(response, fileinfo);
        if (token.length() < 30) {
            this.docFileLogService.saveFileLog(this.getLoginUser(request), versionid, request, "\u6587\u4ef6\u4e0b\u8f7d");
        }
    }

    @RequestMapping(value={"/downloadhelpfile"})
    @ResponseBody
    public void helpfile(HttpServletRequest request, HttpServletResponse response, String filename) throws FileStoreException {
        this.fileService.downloadhelpfile(filename, response);
    }

    @RequestMapping(value={"/preview"})
    @ResponseBody
    @SystemControllerLog(description="\u6587\u4ef6\u9884\u89c8")
    public ModelAndView preview(HttpServletRequest request, Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase, @RequestParam(value="download", defaultValue="true") boolean download) throws Exception {
        ModelAndView view = new ModelAndView();
        String showAll = request.getParameter("showAll");
        List<DocFormFile> formlist = this.docFormFileService.findByFileVersionIdAndIsUse(versionid, "Y");
        if (!"Y".equals(showAll) || formlist.isEmpty()) {
            view.setViewName("/common/preview");
        } else {
            view.setViewName("/common/previewFormFile");
            view.addObject("formId", (Object)formlist.get(0).getFormId());
            view.addObject("primaryKey", (Object)formlist.get(0).getPrimaryKey());
        }
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        fileinfo.setAppType(version.getAppType() == null ? SysContent.APP_TYPE_IOP : version.getAppType());
        fileinfo.setUUID(version.getUUID());
        fileinfo.setFilename(version.getOriginalName());
        if (version.getFileSize() != null && version.getFileSize().longValue() > 0L) {
            view.addObject("fileSize", (Object)DataSizeUtil.format((long)version.getFileSize().longValue()));
        }
        view.addObject("fileinfo", (Object)fileinfo);
        view.addObject("download", (Object)(download && this.fileService.canDownLoadsource(versionid) ? 1 : 0));
        view.addObject("ext", (Object)FilenameUtils.getExtension((String)version.getOriginalName()));
        view.addObject("previewServer", (Object)this.fileService.getPreviewserver());
        view.addObject("supported", (Object)"Y");
        if ("Y".equals(MemCache.getConfigValue(SysConfigEnum.FILE_VIEW_ZIP_CLOSE.getCode())) && FileType.COMPRESS.equals((Object)FileType.typeFromFileName(version.getOriginalName()))) {
            view.addObject("supported", (Object)"N");
        }
        return view;
    }

    @RequestMapping(value={"/viewFile/{versionid}"})
    @CrossOrigin
    @ResponseBody
    public void previewFile(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="versionid") Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase) throws Exception {
        DocFileVersion version;
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        fileinfo = this.fileService.preview(fileinfo);
        do {
            version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
            Thread.sleep(100L);
        } while (version.getConvertStatus() != null && 1L != version.getConvertStatus());
        this.fileService.viewfile(response, fileinfo);
    }

    @RequestMapping(value={"/loadContractFile/{versionid}"})
    public void loadContractFile(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="versionid") Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase) throws Exception {
        DocFileVersion version;
        String pmconId = request.getParameter("pmconId");
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        fileinfo = this.fileService.preview(fileinfo);
        do {
            version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
            Thread.sleep(100L);
        } while (version.getConvertStatus() != null && 1L != version.getConvertStatus());
        String path = this.fileService.getLocalpath() + "/temp/pdf/";
        String filename = version.getPreviewPath().replace(path, "");
        String outputFile = path + "wartermark_" + filename;
        PdfWaterMark.waterMark(version.getPreviewPath(), outputFile, "{formCode:\"PmPmcon\",id:" + versionid + ",pmconId:" + pmconId + "}");
        File file = new File(outputFile);
        FileInputStream stream = FileUtils.openInputStream((File)file);
        try {
            int len;
            response.addHeader("Content-Length", "" + FileUtils.sizeOf((File)file));
            String agent = request.getHeader("User-Agent").toLowerCase();
            if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes("gbk"), "iso-8859-1"));
            }
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            stream.close();
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
            throw new FileStoreException("\u6587\u4ef6ID\uff1a" + fileinfo.getVersionid() + "   \u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/convertprogress"})
    @ResponseBody
    public Object convertprogress(HttpServletRequest request, Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase) throws FileStoreException {
        JsonMsg msg = new JsonMsg();
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        if (version.getConvertStatus() != null && 1L == version.getConvertStatus() && StrKit.notBlank(version.getPreviewPath())) {
            msg.setSuccess(true);
            msg.setMsg("\u6587\u6863\u8f6c\u6362\u6210\u529f");
            msg.setO(1);
        } else if (version.getConvertStatus() != null && -1L == version.getConvertStatus()) {
            msg.setSuccess(true);
            msg.setMsg("\u6587\u6863\u8f6c\u6362\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            msg.setO(-1);
        } else if (version.getConvertStatus() != null && -2L == version.getConvertStatus()) {
            msg.setSuccess(true);
            msg.setMsg("\u6587\u6863\u8f6c\u6362\u51fa\u9519,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            msg.setO(-2);
        } else {
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/viewfile/{previewname}"})
    @ResponseBody
    public void preview(HttpServletRequest request, HttpServletResponse response, String filename, Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase) throws FileStoreException, FileNotFoundException {
        if (versionid == null) {
            return;
        }
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        fileinfo.setPreviewfilename(filename);
        this.fileService.viewfile(response, fileinfo);
    }

    @RequestMapping(value={"/viewPic"})
    @ResponseBody
    public void viewPic(HttpServletRequest request, HttpServletResponse response, String filename, Long versionid, @RequestParam(value="usebase", defaultValue="true") boolean usebase) throws FileStoreException, FileNotFoundException {
        FileInfo fileinfo = new FileInfo();
        fileinfo.setLoginuser(this.getLoginUser(request));
        fileinfo.setVersionid(versionid);
        fileinfo.setUsebase(usebase);
        fileinfo.setPreviewfilename(filename);
        this.fileService.viewPic(response, fileinfo);
    }

    @RequestMapping(value={"/pagechoosefile"})
    @ResponseBody
    public Object pageChoosefile(@RequestParam(value="catalogid", defaultValue="0") Long catalogid, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, @RequestParam(value="filtersql", defaultValue="") String filtersql, String sort, String order) throws FileStoreException {
        return this.docfileService.pageChoosefile(catalogid, search, filtersql, page, rows, sort, order);
    }

    @RequestMapping(value={"/pageEdocfile"})
    @ResponseBody
    public Object pageEdocfile(@RequestParam(value="catalogid", defaultValue="0") Long catalogid, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, @RequestParam(value="filtersql", defaultValue="") String filtersql, String sort, String order) throws FileStoreException {
        return this.docfileService.pageEdocfile(catalogid, search, filtersql, page, rows, sort, order);
    }

    @RequestMapping(value={"/testsearch"})
    @ResponseBody
    public Object testsearch(@RequestParam(value="search", defaultValue="") String search) throws FileStoreException {
        List<String> list = this.fileService.retrieve(search);
        return new JsonMsg(true, "\u6210\u529f", list);
    }

    @RequestMapping(value={"/searchFile"})
    @ResponseBody
    public Object searchFile(String catalogid, String keyword, int page, int rows) throws FileStoreException {
        Map<String, String> uuids = this.fileService.retrieveWithExcerpt(catalogid, keyword);
        PageObject pageObject = this.docfileversionService.searchFile(catalogid, keyword, uuids, page, rows);
        return pageObject;
    }

    @RequestMapping(value={"/scanprogress"})
    @ResponseBody
    public Object scanprogress(HttpServletRequest request) throws FileStoreException {
        Object o = request.getSession().getAttribute("scanresult");
        if (o == null) {
            return new JsonMsg(false);
        }
        ScanResult result = (ScanResult)o;
        request.getSession().removeAttribute("scanresult");
        return new JsonMsg(true, "\u6210\u529f", result);
    }

    @RequestMapping(value={"/scanresult"})
    @ResponseBody
    public Object scanresult(HttpServletRequest request, @RequestBody ScanResult scanresult) throws FileStoreException, IllegalStateException, IOException, InterruptedException, ExecutionException {
        if (scanresult.getResultcode() == 1L) {
            if (scanresult.getScantype() != null && scanresult.getScantype() == 3L) {
                for (BillInfo billinfo : scanresult.getBillist()) {
                    FileInfo fileinfo = new FileInfo();
                    fileinfo.setCatalogid(scanresult.getCatalogid());
                    fileinfo.setLoginuser(this.getLoginUser(request));
                    fileinfo.setProjectid(scanresult.getProjectid());
                    fileinfo.setStanderfileid(scanresult.getStanderfileid());
                    fileinfo.setFilename(billinfo.getFilename());
                    fileinfo.setUUID(billinfo.getUuid());
                    fileinfo.setAppType(SysContent.APP_TYPE_TIMS);
                    fileinfo = this.fileService.saveFileVersion(fileinfo);
                    billinfo.setVersionid(fileinfo.getVersionid());
                }
            } else {
                scanresult.setFilename(StrKit.isBlank(scanresult.getFilename()) ? scanresult.getUuid() + ".zip" : scanresult.getFilename());
                FileInfo fileinfo = new FileInfo();
                fileinfo.setVersionid(scanresult.getVersionid());
                fileinfo.setCatalogid(scanresult.getCatalogid());
                fileinfo.setLoginuser(this.getLoginUser(request));
                fileinfo.setProjectid(scanresult.getProjectid());
                fileinfo.setStanderfileid(scanresult.getStanderfileid());
                fileinfo.setFilename(scanresult.getFilename());
                fileinfo.setUUID(scanresult.getUuid());
                fileinfo.setAppType(SysContent.APP_TYPE_TIMS);
                fileinfo = this.fileService.saveFileVersion(fileinfo);
                BillInfo billinfo = new BillInfo();
                billinfo.setVersionid(fileinfo.getVersionid());
                billinfo.setUuid(fileinfo.getUUID());
                billinfo.setFilename(fileinfo.getFilename());
                scanresult.addBillInfo(billinfo);
            }
            request.getSession().setAttribute("scanresult", (Object)scanresult);
        } else if (scanresult.getResultcode() == 0L) {
            request.getSession().setAttribute("scanresult", (Object)scanresult);
        } else {
            request.getSession().setAttribute("scanresult", (Object)scanresult);
        }
        return new JsonMsg();
    }

    @RequestMapping(value={"/docQuery"})
    @ResponseBody
    public ModelAndView docQuery(String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="20") int rows) throws FileStoreException {
        ModelAndView view = new ModelAndView();
        PageObject pageobject = new PageObject();
        if (StrKit.notBlank(search)) {
            pageobject = this.docfileversionService.docQuery(search, page, rows);
        }
        view.setViewName("/doc/DocQuery");
        view.addObject("page", (Object)pageobject);
        view.addObject("search", (Object)search);
        return view;
    }

    @RequestMapping(value={"/viewfileByVersionId"})
    @ResponseBody
    public ModelAndView viewfileByVersionId(Long versionid) throws FileStoreException {
        ModelAndView view = new ModelAndView();
        DocFileVersion fileVersion = this.docfileversionService.findDocFileVersion(versionid);
        if (fileVersion != null) {
            Object file = this.docfileService.findDocFileObject(fileVersion.getFileId());
            List<Object> versionlist = this.docfileversionService.listVersionByFileId(fileVersion.getFileId());
            List<Object> quotelist = this.docFormFileService.findFormFileByFileVersionId(versionid);
            view.setViewName("/common/viewfileDetail");
            view.addObject("file", file);
            view.addObject("versionlist", versionlist);
            view.addObject("quotelist", quotelist);
        } else {
            view.setViewName("404");
        }
        return view;
    }

    @RequestMapping(value={"/printfiles"})
    @ResponseBody
    public ModelAndView printfiles(String formcode, String Panelid, String PK) throws FileStoreException {
        PrintService[] services;
        ModelAndView view = new ModelAndView();
        ArrayList<DocFormFile> formfilelist = new ArrayList<DocFormFile>();
        GenForm form = this.genformService.findGenFormByCode(formcode);
        List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(Panelid, "Y");
        for (GenPanelFile panelfile : filelist) {
            List<DocFormFile> files = this.docFormFileService.listFormFileByPK(form.getId(), panelfile.getFileTypeId(), PK);
            for (DocFormFile file : files) {
                if (!this.fileHelper.isOffice(file.getOriginalName())) continue;
                formfilelist.add(file);
            }
        }
        ArrayList<String> printerlist = new ArrayList<String>();
        for (PrintService p : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            printerlist.add(p.getName());
        }
        view.setViewName("/common/printPanelFiles");
        view.addObject("formfilelist", formfilelist);
        view.addObject("printerlist", printerlist);
        return view;
    }

    @RequestMapping(value={"/choosedownloadfiles"})
    @ResponseBody
    public ModelAndView choosedownloadfiles(String formcode, String Panelid, String PK, String fileTypeId, String versionId) throws FileStoreException {
        ModelAndView view = new ModelAndView();
        List<Object> formfilelist = new ArrayList();
        GenForm form = this.genformService.findGenFormByCode(formcode);
        if (StringUtils.isNotBlank((CharSequence)fileTypeId)) {
            if ("EdocApply".equals(formcode)) {
                form.setId("1101580");
            }
            formfilelist = this.docFormFileService.listFormFileByPK(form.getId(), fileTypeId, PK);
        } else if (StringUtils.isNotBlank((CharSequence)Panelid)) {
            List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(Panelid, "Y");
            List<String> dealActIds = this.basMessageService.getApproActs(PK, formcode);
            for (GenPanelFile panelfile : filelist) {
                if (StringUtils.isNotBlank((CharSequence)panelfile.getHiddenAct())) {
                    boolean hide = true;
                    for (String dealActId : dealActIds) {
                        if (("," + panelfile.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                        hide = false;
                        break;
                    }
                    if (hide) continue;
                }
                List<DocFormFile> files = this.docFormFileService.listFormFileByPK(form.getId(), panelfile.getFileTypeId(), PK);
                formfilelist.addAll(files);
            }
        } else {
            formfilelist = this.docFormFileService.findByFormCodeAndPrimaryKey(form.getFormCode(), PK);
        }
        if (StringUtils.isNotBlank((CharSequence)versionId)) {
            String[] versionIds;
            for (String vId : versionIds = versionId.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)vId)) continue;
                DocFileVersion version = this.docfileversionService.findDocFileVersion(Long.valueOf(vId));
                DocFormFile file = new DocFormFile();
                file.setFileVersionId(Long.valueOf(vId));
                file.setFileName(version.getOriginalName());
                file.setOriginalName(version.getOriginalName());
                formfilelist.add(file);
            }
        }
        view.setViewName("/common/choosedownloadFiles");
        view.addObject("formfilelist", formfilelist);
        return view;
    }

    @RequestMapping(value={"/getdownloadcount"})
    @ResponseBody
    public Object getdownloadcount(String formcode, String Panelid, String PK, String fileTypeId) throws FileStoreException {
        List<Object> formfilelist = new ArrayList();
        GenForm form = this.genformService.findGenFormByCode(formcode);
        if (fileTypeId != null) {
            if ("EdocApply".equals(formcode)) {
                form.setId("1101580");
            }
            formfilelist = this.docFormFileService.listFormFileByPK(form.getId(), fileTypeId, PK);
        } else if (StringUtils.isNotBlank((CharSequence)Panelid)) {
            List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(Panelid, "Y");
            for (GenPanelFile panelfile : filelist) {
                List<DocFormFile> files = this.docFormFileService.listFormFileByPK(form.getId(), panelfile.getFileTypeId(), PK);
                formfilelist.addAll(files);
            }
        } else {
            formfilelist = this.docFormFileService.findByFormCodeAndPrimaryKey(form.getId(), PK);
        }
        return new JsonMsg(true, "", formfilelist);
    }

    @RequestMapping(value={"/downloadfiles"})
    @ResponseBody
    public void downloadfiles(HttpServletResponse response, String versionids) throws FileStoreException {
        this.fileService.downloadFiles(response, ListUtils.stringToListWithLong(versionids));
    }

    @RequestMapping(value={"/previewfile"})
    public Object previewfile(HttpServletRequest request, HttpServletResponse response, Long versionId) throws FileStoreException, UnsupportedEncodingException {
        String apppath = null;
        apppath = !"-".equals(this.fileService.getServerUrl()) ? this.fileService.getServerUrl() : request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath()));
        DocFileVersion version = this.docfileversionService.findBaseVersionByVersionid(versionId);
        String token = SaTempUtil.createToken((Object)version.getVersionId(), (long)40L);
        String url = apppath + "/file/download/" + token + "." + FilenameUtils.getExtension((String)version.getOriginalName()) + "?usebase=true&fullfilename=" + version.getVersionId() + "." + FilenameUtils.getExtension((String)version.getOriginalName());
        try {
            this.docFileLogService.saveFileLog(this.getLoginUser(request), versionId, request, "\u6587\u4ef6\u9884\u89c8");
        }
        catch (Exception e) {
            logger.warn("\u6587\u4ef6\u9884\u89c8\u65e5\u5fd7\u4fdd\u5b58\u9519\u8bef", (Object)e.getMessage());
        }
        String waterMark = request.getParameter("waterMark");
        if ("Y".equals(MemCache.getConfigValue(SysConfigEnum.FILE_VIEW_WATERMARK.getCode())) && this.getLoginUser(request) != null) {
            waterMark = this.getLoginUser(request).getAccountName();
        }
        return "redirect:" + this.fileService.getPreviewserver() + "/onlinePreview?url=" + URLEncoder.encode(Base64.encodeBase64String((byte[])url.getBytes("UTF-8")), "utf-8") + "&watermarkTxt=" + URLEncoder.encode(waterMark == null ? "" : waterMark, "utf-8") + "&token=" + URLEncoder.encode(token, "utf-8");
    }

    @RequestMapping(value={"/treeFileTypeForFile"})
    @ResponseBody
    public Object treeFileTypeForFile(String formId, String id) {
        return this.docFormFileService.treeFileTypeForFile(formId, id);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public Object delete(String ids) {
        Arrays.asList(ids.split(",")).forEach(id -> {
            FileInfo fileinfo = new FileInfo();
            fileinfo.setUUID((String)id);
            try {
                this.fileService.getPersistInterface().deleteFile(fileinfo);
            }
            catch (Exception e) {
                logger.warn("\u5220\u9664\u6587\u4ef6\u3010" + id + "\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            }
        });
        return new JsonMsg();
    }

    @RequestMapping(value={"/getToken"})
    @ResponseBody
    public Object getToken(Long versionId) {
        return new JsonMsg(true, "", SaTempUtil.createToken((Object)versionId, (long)10L));
    }

    @RequestMapping(value={"/imgThum"}, method={RequestMethod.GET})
    public void imgThum(HttpServletRequest request, HttpServletResponse response, FileInfo fileinfo) throws IOException, FileStoreException {
        this.fileService.imgThum(fileinfo, request, response);
    }
}

