/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common.persist;

import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.doc.common.persist.FileInfo;
import com.guochuang.imp.doc.common.persist.PersistInterface;
import com.guochuang.imp.doc.common.util.FileHelper;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.doc.common.util.JackrabbitHelper;
import com.guochuang.imp.doc.common.util.WaterMarkEnum;
import com.guochuang.imp.doc.common.util.WaterMarkUtil;
import com.guochuang.imp.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.apache.jackrabbit.util.ISO9075;
import org.springframework.web.multipart.MultipartFile;

public class PersistJackRabbit
implements PersistInterface {
    private String xmlPath = "";
    private String storePath = "";
    private String storageNodeName = "";
    private Repository repository;
    FileHelper filehelper = new FileHelper();
    JackrabbitHelper jackHelp = new JackrabbitHelper();
    private String localpath = "";
    private String localvisualpath = "";
    private static PersistJackRabbit instance;

    public PersistJackRabbit(String xp, String sp, String NodeName, String lp, String lvp) throws FileStoreException {
        this.xmlPath = xp;
        this.storePath = sp;
        this.storageNodeName = NodeName;
        this.localpath = lp;
        this.localvisualpath = lvp;
        this.init();
    }

    public static synchronized PersistJackRabbit getInstance(String xp, String sp, String NodeName, String lp, String lvp) throws FileStoreException {
        if (instance == null) {
            instance = new PersistJackRabbit(xp, sp, NodeName, lp, lvp);
        }
        return instance;
    }

    private void init() throws FileStoreException {
        try {
            if (this.xmlPath == null) {
                this.repository = new URLRemoteRepository(this.storePath);
            } else {
                String path = this.getClass().getClassLoader().getResource(this.xmlPath).getPath();
                File file = new File(path);
                File storeDir = new File(this.storePath);
                this.repository = new TransientRepository(file, storeDir);
            }
        }
        catch (MalformedURLException e) {
            throw new FileStoreException("\u5185\u5bb9\u4ed3\u5e93\u8fdc\u7a0b\u8fde\u63a5\u5f02\u5e38!\u8bf7\u68c0\u67e5\u8fdc\u7a0b\u4ed3\u5e93\u8def\u5f84", e);
        }
    }

    private Session CreateSession() throws FileStoreException {
        try {
            Session session = this.repository.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
            Node storageNode = this.jackHelp.getStorageNode(session, this.storageNodeName);
            if (storageNode == null) {
                this.jackHelp.initStorageNode(session, this.storageNodeName);
            }
            return session;
        }
        catch (LoginException e) {
            throw new FileStoreException("\u5185\u5bb9\u4ed3\u5e93\u767b\u5f55\u5931\u8d25!", e);
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u5185\u5bb9\u4ed3\u5e93\u521b\u5efa\u5f02\u5e38\u5f02\u5e38!\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u5185\u5bb9\u4ed3\u5e93\u8def\u5f84", e);
        }
    }

    @Override
    public String uploadFile(MultipartFile file, FileInfo fileinfo) throws FileStoreException {
        String filename = this.filehelper.replaceBlank(file.getOriginalFilename());
        fileinfo.setFilename(filename);
        InputStream is = null;
        String UUID2 = "";
        Session session = this.CreateSession();
        try {
            is = file.getInputStream();
            String waterMarkType = fileinfo.getWaterMarkType();
            String markContent = fileinfo.getMarkContent();
            String fileExt = FilenameUtils.getExtension((String)filename);
            String tempPath = SpringContextHolder.getProperty("fileserver.waterMarkTemp");
            if (StringUtil.isNotEmpty(waterMarkType) && StringUtil.isNotEmpty(markContent) && StringUtil.isNotEmpty(tempPath) && ("pdf".equals(fileExt) || "doc".equals(fileExt) || "docx".equals(fileExt))) {
                File diskpath = new File(tempPath);
                if (!diskpath.exists()) {
                    diskpath.mkdirs();
                }
                String diskfilepath = tempPath + "/" + filename;
                File diskfile = this.filehelper.generFile(diskfilepath);
                if (WaterMarkEnum.IMG_MARK.getType().equals(waterMarkType)) {
                    FileInfo imgFile = new FileInfo();
                    imgFile.setUUID(fileinfo.getMarkContent());
                    imgFile = this.downloadFile(imgFile);
                    WaterMarkUtil.addImageWaterMark(file.getInputStream(), filename, diskfile.getAbsolutePath(), imgFile.getIs());
                } else if (WaterMarkEnum.TEXT_MARK.getType().equals(waterMarkType)) {
                    WaterMarkUtil.addTextWaterMark(file.getInputStream(), filename, diskfile.getAbsolutePath(), fileinfo.getMarkContent());
                }
                try (FileInputStream isMd5 = new FileInputStream(diskfile.getAbsolutePath());){
                    String md5 = DigestUtils.md5Hex((InputStream)isMd5);
                    fileinfo.setMd5(md5);
                }
                var15_18 = null;
                try (FileInputStream isSha1 = new FileInputStream(diskfile.getAbsolutePath());){
                    String sha1 = DigestUtils.sha1Hex((InputStream)isSha1);
                    fileinfo.setSha1(sha1);
                }
                catch (Throwable throwable) {
                    var15_18 = throwable;
                    throw throwable;
                }
                is = new FileInputStream(diskfile.getAbsolutePath());
            }
            UUID2 = this.jackHelp.writerBinProperty(session, this.storageNodeName, is, fileinfo);
        }
        catch (IOException e) {
            throw new FileStoreException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", e);
        }
        catch (Exception e) {
            throw new FileStoreException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new FileStoreException("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u9519\u8bef!", e);
                }
            }
            session.logout();
        }
        return UUID2;
    }

    @Override
    public FileInfo downloadFile(FileInfo fileinfo) throws FileStoreException {
        Session newSession = this.CreateSession();
        try {
            Node node = newSession.getNodeByIdentifier(fileinfo.getUUID());
            NodeIterator contentNodes = node.getNodes();
            Node contNode = null;
            while (contentNodes.hasNext()) {
                contNode = contentNodes.nextNode();
            }
            fileinfo.setIs(contNode.getProperty("jcr:data").getBinary().getStream());
            fileinfo.setFilesize(contNode.getProperty("jcr:data").getLength());
            FileInfo fileInfo = fileinfo;
            return fileInfo;
        }
        catch (ValueFormatException e1) {
            throw new FileStoreException("\u503c\u683c\u5f0f\u5316\u5931\u8d25!", e1);
        }
        catch (PathNotFoundException e1) {
            throw new FileStoreException("\u6587\u4ef6\u8def\u5f84\u6ca1\u627e\u5230!", e1);
        }
        catch (RepositoryException e1) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e1);
        }
        finally {
            if (newSession != null) {
                newSession.logout();
            }
        }
    }

    @Override
    public FileInfo viewFile(FileInfo fileinfo) throws FileStoreException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(FileInfo fileinfo) throws FileStoreException {
        Session session = this.CreateSession();
        this.jackHelp.deleteNode(session, fileinfo.getUUID(), this.storageNodeName);
        SessionImpl si = (SessionImpl)session;
        try (GarbageCollector gc = null;){
            gc = si.createDataStoreGarbageCollector();
            gc.mark();
            gc.sweep();
        }
        return true;
    }

    @Override
    public void replaceFile(MultipartFile file, FileInfo fileinfo) throws FileStoreException {
    }

    @Override
    public List<String> searchFile(FileInfo fileinfo) throws FileStoreException {
        Session session = this.CreateSession();
        try {
            String catalogidpath = "";
            if (!StringUtil.isEmpty(fileinfo.getCatalogid())) {
                catalogidpath = "/" + ISO9075.encode((String)(StringUtil.str2Int(fileinfo.getProjectid()) + "")) + "/" + ISO9075.encode((String)fileinfo.getCatalogid());
            }
            List<Node> list = this.jackHelp.fullTextSearchForNode(session, this.storageNodeName, catalogidpath, fileinfo.getKeyword());
            ArrayList<String> listIds = new ArrayList<String>();
            for (Node n : list) {
                listIds.add(n.getIdentifier());
            }
            ArrayList<String> arrayList = listIds;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean exist(FileInfo fileinfo) throws FileStoreException {
        Session newSession = this.CreateSession();
        try {
            Node node = newSession.getNodeByIdentifier(fileinfo.getUUID());
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u4ed3\u5e93\u8fde\u63a5\u51fa\u9519");
        }
        finally {
            if (newSession != null) {
                newSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> searchFileWithExcerpt(FileInfo fileinfo) throws FileStoreException {
        HashMap<String, String> resultmapMap = new HashMap<String, String>();
        Session session = this.CreateSession();
        try {
            if (!"".equals(fileinfo.getKeyword())) {
                try {
                    String catalogidpath = "";
                    if (!StringUtil.isEmpty(fileinfo.getCatalogid())) {
                        catalogidpath = this.storageNodeName + "/" + ISO9075.encode((String)(StringUtil.str2Int(fileinfo.getProjectid()) + "")) + "/" + ISO9075.encode((String)fileinfo.getCatalogid()) + "/";
                    }
                    String xPath = "//" + catalogidpath + "element(*, nt:file)[(jcr:contains(jcr:content,\"" + fileinfo.getKeyword() + "\"))]";
                    Workspace ws = session.getWorkspace();
                    QueryManager qm = ws.getQueryManager();
                    Query query = qm.createQuery(xPath, "xpath");
                    RowIterator rows = query.execute().getRows();
                    while (rows.hasNext()) {
                        Row r = rows.nextRow();
                        Node file = (Node)session.getItem(r.getValue("jcr:path").getString());
                        resultmapMap.put(file.getIdentifier(), r.getValue("rep:excerpt(jcr:content)").getString());
                    }
                }
                catch (InvalidQueryException e) {
                    throw new FileStoreException("\u65e0\u6548\u7684\u67e5\u8be2\u8bed\u53e5!", e);
                }
                catch (RepositoryException e) {
                    throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
                }
            }
            HashMap<String, String> hashMap = resultmapMap;
            return hashMap;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

