/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.business.cn.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.business.cn.dao.ConInfoApiLogDao;
import com.guochuang.imp.business.cn.entity.ConInfoApiLog;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConInfoApiLogService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private ConInfoApiLogDao conInfoApiLogDao;

    public PageObject pageAll(String logType, String logTimeStart, String logTimeEnd, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(logType)) {
            params.put("logType", logType);
        }
        if (!StringUtil.isEmpty(logTimeStart)) {
            params.put("logTimeStart", logTimeStart);
        }
        if (!StringUtil.isEmpty(logTimeEnd)) {
            params.put("logTimeEnd", logTimeEnd);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("business.cn.ConInfoApiLog.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("logTypeText", MemCache.getDicText("MIDDLE_LOG", StringUtil.null2String(map.get("logType"))));
            map.put("createAccountText", MemCache.getEmpAccountName(StringUtil.null2String(map.get("createAccount"))));
        }
        return pageObject;
    }

    @Transactional
    public void saveConInfoApiLog(ConInfoApiLog entity) {
        this.conInfoApiLogDao.save(entity);
    }

    public ConInfoApiLog findConInfoApiLog(Long id) {
        ConInfoApiLog entity = (ConInfoApiLog)this.conInfoApiLogDao.findById(id).get();
        return entity;
    }

    public void delConInfoApiLog(Long id) {
        ConInfoApiLog entity = (ConInfoApiLog)this.conInfoApiLogDao.findById(id).get();
        entity.setIsUse("N");
        this.conInfoApiLogDao.save(entity);
    }
}

