/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.map.MapUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasSpaceComponentDefinitionDao;
import com.guochuang.imp.base.dao.BasSpaceComponentUserDao;
import com.guochuang.imp.base.entity.BasSpaceComponentDefinition;
import com.guochuang.imp.base.entity.BasSpaceComponentUser;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSpaceComponentDefinitionService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasSpaceComponentDefinitionDao basspacecomponentdefinitionDao;
    @Autowired
    private BasSpaceComponentUserDao basSpaceComponentUserDao;

    public BasSpaceComponentDefinition findBasSpaceComponentDefinition(Long id) {
        BasSpaceComponentDefinition entity = (BasSpaceComponentDefinition)this.basspacecomponentdefinitionDao.findById(id).get();
        return entity;
    }

    public void saveBasSpaceComponentDefinition(BasSpaceComponentDefinition entity, List<BasSpaceComponentUser> list) {
        this.basspacecomponentdefinitionDao.save(entity);
        if (list != null) {
            for (BasSpaceComponentUser user : list) {
                user.setComponentId(entity.getComponentId());
                if (user.getUserId() == null) {
                    user.setCreateAccount(SysUtils.getLoginUser().getAccountid());
                    user.setCreateTime(new Date());
                }
                user.setIsUse("Y");
                user.setModifyAccount(SysUtils.getLoginUser().getAccountid());
                user.setModifyTime(new Date());
                this.basSpaceComponentUserDao.save(user);
            }
        }
    }

    public JsonMsg delBasSpaceComponentDefinition(Long id) {
        JsonMsg msg = new JsonMsg();
        String useSapce = this.bSqlHelper.getStringValue("base.BasSpaceComponentDefinition.getUseSpace", MapUtil.of((Object)"id", (Object)id));
        if (StringUtils.isNotBlank((String)useSapce)) {
            msg.setSuccess(false);
            msg.setMsg("\u5f53\u524d\u7ec4\u4ef6\u5df2\u88ab\u7a7a\u95f4[" + useSapce + "]\u5f15\u7528,\u6682\u65f6\u65e0\u6cd5\u5220\u9664");
            return msg;
        }
        BasSpaceComponentDefinition entity = (BasSpaceComponentDefinition)this.basspacecomponentdefinitionDao.findById(id).get();
        entity.setIsUse("N");
        this.basspacecomponentdefinitionDao.save(entity);
        return msg;
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order, String componentName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)componentName)) {
            params.put("componentName", "%" + componentName.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasSpaceComponentDefinition.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<ComBoxTreeNode> spaceComponentTree() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasSpaceComponentDefinition.spaceComponentTree", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> spaceComponentTreeFilter(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("spaceId", spaceId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasSpaceComponentDefinition.spaceComponentTreeFilter", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<Map<String, Object>> getSpaceComponentByCategory(String category) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("category", category);
        return this.bSqlHelper.getMapList("base.BasSpaceComponentDefinition.getSpaceComponentByCategory", params);
    }

    public PageObject pageSpaceComponentTreeFilter(int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasSpaceComponentDefinition.pageSpaceComponentTreeFilter", params, PageRequest.of((int)page, (int)rows));
        pageObject.getRows().forEach(map -> {
            if (map.get("showForm") != null) {
                map.put("componentName", map.get("componentName") + "(" + MemCache.getDicText("SHOW_FORM", StringUtil.null2String(map.get("showForm"))) + ")");
            }
        });
        return pageObject;
    }
}

