/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasSpaceComponentCustomDao;
import com.guochuang.imp.base.dao.BasSpaceComponentDefinitionDao;
import com.guochuang.imp.base.entity.BasSpaceComponentCustom;
import com.guochuang.imp.base.entity.BasSpaceComponentDefinition;
import com.guochuang.imp.base.entity.GmInfoType;
import com.guochuang.imp.base.service.GmInfoTypeService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSpaceComponentCustomService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasSpaceComponentCustomDao basSpaceComponentCustomDao;
    @Autowired
    private GmInfoTypeService gminfotypeService;
    @Autowired
    private BasSpaceComponentDefinitionDao basSpaceComponentDefinitionDao;

    public BasSpaceComponentCustom findBasSpaceComponentCustom(Long id) {
        Optional optional = this.basSpaceComponentCustomDao.findById(id);
        return optional.isPresent() ? (BasSpaceComponentCustom)optional.get() : null;
    }

    public void saveBasSpaceComponentCustom(BasSpaceComponentCustom entity) {
        this.basSpaceComponentCustomDao.save(entity);
    }

    public void delBasSpaceComponentCustom(Long id) {
        BasSpaceComponentCustom entity = (BasSpaceComponentCustom)this.basSpaceComponentCustomDao.findById(id).get();
        entity.setIsUse("N");
        this.basSpaceComponentCustomDao.save(entity);
    }

    public PageObject PageAll(String search, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (applyDept != null) {
            params.put("applyDept", applyDept);
        }
        return this.bSqlHelper.serachPage("base.BasSpaceComponentCustom.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void deleteByUserAndSpace(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userId != null) {
            params.put("userId", userId);
            params.put("spaceId", spaceId);
        }
        this.bSqlHelper.updateOrDelete("base.BasSpaceComponentCustom.deleteByUserAndSpace", params);
    }

    public int findCountByUserAndSpace(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userId != null) {
            params.put("userId", userId);
            params.put("spaceId", spaceId);
        }
        return this.bSqlHelper.getIntValue("base.BasSpaceComponentCustom.findCountByUserAndSpace", params);
    }

    public List<Map<String, Object>> findByUserAndSpace(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (spaceId != null) {
            params.put("userId", userId);
            params.put("spaceId", spaceId);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasSpaceComponentCustom.findByUserAndSpace", params);
        for (Map<String, Object> map : list) {
            String[] ids;
            String componentId = (String)map.get("componentId");
            String columnNames = "";
            if ("1".equals(map.get("componentType").toString())) {
                if (componentId.indexOf(",") == -1) {
                    GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(componentId));
                    columnNames = columnNames + gmInfoType.getTypeName();
                } else {
                    for (String id : ids = componentId.split(",")) {
                        GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(id));
                        columnNames = columnNames + gmInfoType.getTypeName() + " ";
                    }
                }
                map.put("componentName", columnNames);
                continue;
            }
            if (componentId.indexOf(",") == -1) {
                BasSpaceComponentDefinition basSpaceComponentDefinition = (BasSpaceComponentDefinition)this.basSpaceComponentDefinitionDao.findById(Long.parseLong(componentId)).get();
                columnNames = columnNames + basSpaceComponentDefinition.getComponentName();
                map.put("linkAddress", basSpaceComponentDefinition.getLinkAddress());
            } else {
                for (String id : ids = componentId.split(",")) {
                    BasSpaceComponentDefinition basSpaceComponentDefinition = (BasSpaceComponentDefinition)this.basSpaceComponentDefinitionDao.findById(Long.parseLong(id)).get();
                    columnNames = columnNames + basSpaceComponentDefinition.getComponentName() + " ";
                }
            }
            map.put("componentName", columnNames);
        }
        return list;
    }
}

