/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.dao.BasModelManageDao;
import com.guochuang.imp.base.entity.BasModelManage;
import com.guochuang.imp.base.extend.BasExecuteSqlColumnModel;
import com.guochuang.imp.base.extend.BasExecuteSqlConditionModel;
import com.guochuang.imp.base.extend.BasExecuteSqlModel;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasModelManageService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasModelManageDao basModelManageDao;

    public List<ComBoxTreeNode> treeBasModelManageWithRoot(Long pid, String modelType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        if (modelType != null && !"".equals(modelType)) {
            params.put("modelType", modelType);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasModelManage.treeBasModelManageWithRoot", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    @Transactional
    public void saveBasModelManage(BasModelManage entity) {
        this.basModelManageDao.save(entity);
    }

    public BasModelManage findBasModelManage(Long id) {
        BasModelManage entity = (BasModelManage)this.basModelManageDao.findById(id).get();
        return entity;
    }

    @Transactional
    public void delBasModelManage(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelId", id);
        this.bSqlHelper.updateOrDelete("base.BasModelManage.delBasModelManage", params);
    }

    public List<Map<String, Object>> getDataColumns(String search, Long modelPid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelPid", modelPid);
        if (search != null && !"".equals(search.trim())) {
            params.put("search", "%" + search + "%");
        }
        return this.bSqlHelper.getMapList("base.BasModelManage.getDataColumns", params);
    }

    public List<Map<String, Object>> findThemeListByWorkspace(Long modeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mainId", modeId);
        return this.bSqlHelper.getMapList("base.BasModelManage.findThemeListByWorkspace", params);
    }

    public List<Map<String, Object>> findThemeListByWorkspaceNew(Long modeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mainId", modeId);
        if (modeId == 0L) {
            return this.bSqlHelper.getMapList("base.BasModelManage.findThemeListByWorkspaceNew", params);
        }
        return this.bSqlHelper.getMapList("base.BasModelManage.findThemeListByWorkspace", params);
    }

    public List<BasExecuteSqlModel> findThemeSqlInfoList(String themeIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (themeIds != null && !"".equals(themeIds)) {
            params.put("themeIds", themeIds);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasModelManage.findThemeSqlInfoList", params);
        ArrayList<BasExecuteSqlModel> result = null;
        if (list != null && !list.isEmpty()) {
            result = new ArrayList<BasExecuteSqlModel>();
            for (Map<String, Object> map : list) {
                BasExecuteSqlConditionModel conditionInfo;
                List<BasExecuteSqlConditionModel> conditionList;
                String modelType;
                Long themeId = Long.valueOf(map.get("themeId").toString());
                BasExecuteSqlModel sqlModel = result.stream().filter(entity -> entity.getThemeId().longValue() == themeId.longValue()).findAny().orElse(null);
                if (sqlModel == null) {
                    sqlModel = new BasExecuteSqlModel();
                    sqlModel.setThemeId(themeId);
                    sqlModel.setColumnList(new ArrayList<BasExecuteSqlColumnModel>());
                    sqlModel.setConditionList(new ArrayList<BasExecuteSqlConditionModel>());
                    sqlModel.setTableNames(new ArrayList<String>());
                    result.add(sqlModel);
                }
                if ("mainTable".equals(modelType = StringUtil.null2String(map.get("modelType"))) || "sublistTable".equals(modelType)) {
                    List<String> tables = sqlModel.getTableNames();
                    Long cnt = tables.stream().filter(table -> table.equals(map.get("tableName").toString())).count();
                    if (cnt > 0L) continue;
                    tables.add(map.get("tableName").toString());
                    continue;
                }
                if ("dataColumn".equals(modelType) || "computedColumn".equals(modelType)) {
                    List<BasExecuteSqlColumnModel> colList = sqlModel.getColumnList();
                    BasExecuteSqlColumnModel colInfo = new BasExecuteSqlColumnModel();
                    colInfo.setTableId(Long.valueOf(map.get("tableId").toString()));
                    colInfo.setTableName(map.get("tableName").toString());
                    colInfo.setModelType(map.get("modelType").toString());
                    colInfo.setColumnId(Long.valueOf(map.get("columnId").toString()));
                    colInfo.setColumnName(map.get("columnName").toString());
                    colInfo.setColumnCat(StringUtil.null2String(map.get("dataCat")));
                    colInfo.setColumnSql(StringUtil.null2String(map.get("express")));
                    colList.add(colInfo);
                    continue;
                }
                if ("tableRelationship".equals(modelType)) {
                    conditionList = sqlModel.getConditionList();
                    conditionInfo = new BasExecuteSqlConditionModel();
                    conditionInfo.setConditionId(Long.valueOf(map.get("tableId").toString()));
                    conditionInfo.setModelType(map.get("modelType").toString());
                    conditionInfo.setrTable1(map.get("rTable1").toString());
                    conditionInfo.setrTable2(map.get("rTable2").toString());
                    conditionInfo.setrColumn1(map.get("rColumn1").toString());
                    conditionInfo.setrColumn2(map.get("rColumn2").toString());
                    conditionList.add(conditionInfo);
                    continue;
                }
                if (!"condition".equals(modelType)) continue;
                conditionList = sqlModel.getConditionList();
                conditionInfo = new BasExecuteSqlConditionModel();
                conditionInfo.setConditionId(Long.valueOf(map.get("columnId").toString()));
                conditionInfo.setModelType(map.get("modelType").toString());
                conditionInfo.setConditionSql(StringUtil.null2String(map.get("express")));
                conditionList.add(conditionInfo);
            }
        }
        return result;
    }

    public List<Map<String, Object>> findDataCatListByThemeId(Long themeId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("themeId", themeId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasModelManage.findDataCatListByThemeId", params);
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> entity : list) {
                if (entity.get("dataCat") == null) continue;
                entity.put("dataCatText", MemCache.getDicText("DATA_CAT", entity.get("dataCat").toString()));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public BasModelManage getModelByCode(String themeCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelCode", themeCode);
        return this.bSqlHelper.getEntity("base.BasModelManage.getModelByCode", params, BasModelManage.class);
    }
}

