/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.app.common.AppPush;
import com.guochuang.imp.base.common.CronTask.SchedulingRunnable;
import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.CollectionUtils;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.common.util.dwr.SystemMessage;
import com.guochuang.imp.base.dao.BasDeviceUserDao;
import com.guochuang.imp.base.dao.BasMessageDao;
import com.guochuang.imp.base.dao.BasMessageReceiveDao;
import com.guochuang.imp.base.entity.BasDeviceUser;
import com.guochuang.imp.base.entity.BasMessage;
import com.guochuang.imp.base.entity.BasMessageDeadline;
import com.guochuang.imp.base.entity.BasMessageReceive;
import com.guochuang.imp.base.extend.BasMessageAppModel;
import com.guochuang.imp.base.extend.BasMessageModel;
import com.guochuang.imp.base.extend.IBasMessageAdditional;
import com.guochuang.imp.base.extend.IBasMessageWarnAdditional;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasMessageDeadlineConfigService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.sys.util.ListUtils;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.webservice.sms.ISmsManagerService;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasMessageService {
    public static Logger loger = Logger.getLogger(BasMessageService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMessageDao basmessageDao;
    @Autowired
    private BasMessageReceiveDao basMessageReceiveDao;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDeviceUserDao BasDeviceUserDao;
    @Autowired(required=false)
    private ISmsManagerService smsManagerService;
    @Autowired
    private AppPush appPush;
    @Autowired
    private BasMessageDeadlineConfigService basMessageDeadlineConfigService;

    public BasMessage findBasMessage(Long id) {
        BasMessage entity = (BasMessage)this.basmessageDao.findById(id).get();
        return entity;
    }

    public void saveBasMessage(BasMessage entity) {
        this.basmessageDao.save(entity);
    }

    public void delBasMessage(Long id) {
        this.basmessageDao.deleteById(id);
    }

    public BasMessage findBasMessageByAccountId(Long id, Long accountId) {
        if (id == null || accountId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountId);
        params.put("msgId", id);
        String sql = "select t.*\n  from Bas_Message t, BAS_MESSAGE_RECEIVE r\n where r.msg_id = t.msg_id\n   and (r.ACCOUNT_ID =:accountid or exists (select 1\n  from WF_AGENT a, gen_form f,  bas_message_receive e\n where   f.form_code =t.form_code\n   and e.account_id = a.agent_to_account\n   and e.msg_id=t.msg_id\n   and a.agent_to_account=r.account_id\n   and a.agent_account = :accountid\n   and( (concat('%,' , a.agent_content , ',%') like concat('%,' , f.flow_cat_id , ',%')\n   and a.end_date > now()\n   and (a.cancel_date is null or a.cancel_date > now())) or a.agent_type='2')) ) \n   and r.IS_DEAL = 'N'\n   and t.is_use = 'Y'\n   and t.msg_id = :msgId";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, BasMessage.class, new int[0]);
        if (list != null && !list.isEmpty()) {
            return (BasMessage)list.get(0);
        }
        return null;
    }

    public List<BasMessage> findBasMessageByAccountIdAndProcessinstid(Long accountId, Long processinstid, Long msgId, String dbType) {
        if (accountId == null || processinstid == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountId);
        params.put("processinstid", processinstid);
        if (msgId != null) {
            params.put("msgId", msgId);
        }
        params.put("dbType", dbType);
        List<BasMessage> list = this.bSqlHelper.getList("base.BasMessage.findBasMessageByAccountIdAndProcessinstid", params, BasMessage.class);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        return null;
    }

    public BasMessage findByformCodeAndbusiMainIdAndAccountId(String busiMainId, Long accountId, String formCode) {
        if (busiMainId == null || accountId == null || formCode == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountId);
        params.put("busiMainId", busiMainId);
        params.put("formCode", formCode);
        String sql = "select t.* from Bas_Message t,BAS_MESSAGE_RECEIVE r where r.msg_id=t.msg_id and t.msg_type='1' and r.ACCOUNT_ID=:accountid and r.IS_DEAL='N' and t.is_use='Y' and t.BUSI_MAIN_ID=:busiMainId and t.FORM_CODE=:formCode ";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, BasMessage.class, new int[0]);
        if (list != null && !list.isEmpty()) {
            return (BasMessage)list.get(0);
        }
        return null;
    }

    public List<BasMessage> findByProcessinstid(Long processinstid) {
        return this.basmessageDao.findByProcessinstidOrderByMsgId(processinstid);
    }

    public PageObject PageSysMessageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.msg_id,t.msg_title,DATE_FORMAT(t.sendtime,'%Y-%m-%d %H:%i:%s') as sendtime from BAS_MESSAGE t where t.is_use=:isUse and t.MSG_TYPE=2  ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append(" upper(t.MSG_TITLE) like :search ");
            sql.append(" or upper(t.SENDTIME) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MSG_TYPE", "MSG_TYPE");
        dicmapper.put("BUSI_TYPE", "BUSINESS_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from BAS_MESSAGE t  order by t.MSG_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_MESSAGE t where   upper(t.MSG_ID) like ?1  or upper(t.MSG_TITLE) like ?1  or upper(t.MSG_URL) like ?1  or upper(t.MSG_TYPE) like ?1  or upper(t.BUSI_TYPE) like ?1  or upper(t.SENDER) like ?1  or upper(t.SENDTIME) like ?1  or upper(t.IS_PUBLIC) like ?1  or upper(t.IS_USE) like ?1  order by t.MSG_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MSG_TYPE", "MSG_TYPE");
        dicmapper.put("BUSI_TYPE", "BUSINESS_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<Map<String, Object>> PageToDoList(Long accountid, String search) {
        List<BasMessageDeadline> deadlines = this.basMessageDeadlineConfigService.getMessageDeadlineList();
        StringBuffer sqltemp = new StringBuffer();
        if (!deadlines.isEmpty()) {
            sqltemp.append(" case ");
            deadlines.forEach(deadline -> {
                if (StringUtils.isNotBlank((String)deadline.getProcessTime()) && StringUtils.isNotBlank((String)deadline.getColor())) {
                    if ("1".equals(deadline.getTimeType())) {
                        sqltemp.append(" when TIMESTAMPDIFF(HOUR,i.STARTTIME,now())-(SELECT count(distinct(DATE_FORMAT(t.holiday_date,'%Y-%m-%d'))) FROM hr_attendance_holiday t ");
                        sqltemp.append(" WHERE t.HOLIDAY_TYPE != '5' and t.HOLIDAY_TYPE != '4' AND t.is_use = 'Y'  AND t.HOLIDAY_DATE BETWEEN  i.STARTTIME AND now())*24 >= ");
                        sqltemp.append(deadline.getProcessTime());
                        sqltemp.append(" then '" + deadline.getColor().replace("#", "\\#") + "' ");
                    } else {
                        sqltemp.append(" when TIMESTAMPDIFF(HOUR,i.STARTTIME,now()) >= ");
                        sqltemp.append(deadline.getProcessTime());
                        sqltemp.append(" then '" + deadline.getColor().replace("#", "\\#") + "' ");
                    }
                }
            });
            sqltemp.append(" end color ,");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  " + sqltemp + " case i.limittime when 0 then 0 else floor((now()-i.starttime)*24*60-i.limittime) end overtime,z.biz_type,t.*,\n       b.account_name  AS account_Name,(select d.abbr from bas_dept d where d.dept_id =b.dept_id) dept_name,\n       b2.account_name AS creator,\n       r.is_read       AS is_read,b.org_id\n  FROM BAS_MESSAGE t\n left join wf_workitem i on t.workitemid=i.workitemid    left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where  r.account_id = #accountid# and r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n \t\t\t\tand a.agent_account = #accountid# \t\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND ((concat('%,' , a.agent_content , ',%')) LIKE\n                    (concat('%,' , f.flow_cat_id , ',%')) AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  LEFT JOIN bas_emp_account b\n    ON t.sender = b.account_id\n  LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w\n    ON t.processinstid = w.processinstid\n  LEFT JOIN stf_business_process y\n \t ON y.design_name = w.PROCESSDEFNAME\n  LEFT JOIN STF_BUSINESS_type z\n\t ON z.res_id = y.business_type_id\n  LEFT JOIN bas_emp_account b2\n    ON w.creator = b2.account_id\n WHERE t.is_use = 'Y' and i.CURRENTSTATE in(4,10) \n");
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.hasRole("ORG_KJ")) {
            // empty if block
        }
        sql.append("   and r.account_id = #accountid#\n   AND t.msg_type = 1 \n");
        sql.append("and not exists (select 1 from bas_message_collapse c where c.is_common='Y'  and c.is_use='Y' and c.flow_code = y.design_name and (find_in_set (i.ACTIVITYDEFID,c.act_id)!=0 or c.act_id is null or c.ACT_ID='' ))");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like #search#  or upper(b.account_name) like #search# ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc ");
        List<Map<String, Object>> list = this.bSqlHelper.serachBySql(sql.toString(), params);
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            List<BasMessageModel> templist = bma.getMsgList();
            if (templist == null) continue;
            list.addAll(0, templist.stream().map(t -> {
                try {
                    return PropertyUtils.describe((Object)t);
                }
                catch (Exception e) {
                    return new HashMap();
                }
            }).filter(a -> a.get("msgTitle") != null).collect(Collectors.toList()));
        }
        list.forEach(msg -> {
            if (msg.get("orgId") != null) {
                msg.put("orgName", MemCache.getOrgAbbr(Objects.toString(msg.get("orgId"))));
            }
        });
        list.addAll(0, this.getCollapseMsg(accountid, search, null, null, null, null, null));
        return list;
    }

    public List<Map<String, Object>> getCollapseMsg(Long accountid, String search, String subject, String createName, String startDate, String endDate, String businessType) {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("SELECT  concat('\u60a8\u6709',count(*) ,'\u6761',c.COLLAPSE_NAME,',\u8bf7\u53ca\u65f6\u5904\u7406')MSG_TITLE, c.COLLAPSE_NAME,c.LINK_URL msg_Url,0 overtime,'N' is_read,0 busi_Type,0 msg_Level,'\u7cfb\u7edf'accountName,4 msg_Type\n  FROM BAS_MESSAGE t\n left join wf_workitem i on t.workitemid=i.workitemid   \n left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where  r.account_id = #accountid# and r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n \t\t\t\tand a.agent_account = #accountid#\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND ((concat('%,' , a.agent_content , ',%')) LIKE\n                    (concat('%,' , f.flow_cat_id , ',%')) AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w\n    ON t.processinstid = w.processinstid\n  LEFT JOIN stf_business_process y\n \t ON y.design_name = w.PROCESSDEFNAME\n  LEFT JOIN STF_BUSINESS_type z\n\t ON z.res_id = y.business_type_id\n  LEFT JOIN bas_emp_account b2\n    ON w.creator = b2.account_id, bas_message_collapse c\n WHERE t.is_use = 'Y'\n   and r.account_id = #accountid#\n   AND t.msg_type = 1  \nAND c.is_common = 'Y'  and c.is_use='Y' \nAND c.flow_code = y.design_name \nAND ( find_in_set (i.ACTIVITYDEFID,c.act_id)!=0 OR c.act_id IS NULL OR c.ACT_ID = '' )\n");
        if (StringUtils.isNotBlank((String)businessType)) {
            businessType = "," + businessType + ",";
            sql.append(" and  #businessType# like concat('%,',z.res_id,',%') \n");
            params.put("businessType", businessType);
        }
        sql.append("group by c.id,c.COLLAPSE_NAME,c.LINK_URL");
        params.put("accountid", accountid);
        return this.bSqlHelper.serachBySql(sql.toString(), params);
    }

    public List<Map<String, Object>> PageToDoList(Long accountid, String search, String subject, String createName, String startDate, String endDate, String businessType) {
        Subject currentUser;
        List<BasMessageDeadline> deadlines = this.basMessageDeadlineConfigService.getMessageDeadlineList();
        StringBuffer sqltemp = new StringBuffer();
        if (!deadlines.isEmpty()) {
            sqltemp.append(" case ");
            deadlines.forEach(deadline -> {
                if (StringUtils.isNotBlank((String)deadline.getProcessTime()) && StringUtils.isNotBlank((String)deadline.getColor())) {
                    if ("1".equals(deadline.getTimeType())) {
                        sqltemp.append(" when TIMESTAMPDIFF(HOUR,t.SENDTIME,now())-(SELECT count(distinct(DATE_FORMAT(t.holiday_date,'%Y-%m-%d'))) FROM hr_attendance_holiday t ");
                        sqltemp.append(" WHERE t.HOLIDAY_TYPE != '5' and t.HOLIDAY_TYPE != '4' AND t.is_use = 'Y'  AND t.HOLIDAY_DATE BETWEEN  t.SENDTIME AND now())*24 >= ");
                        sqltemp.append(deadline.getProcessTime());
                        sqltemp.append(" then '" + deadline.getColor().replace("#", "\\#") + "' ");
                    } else {
                        sqltemp.append(" when TIMESTAMPDIFF(HOUR,t.SENDTIME,now()) >= ");
                        sqltemp.append(deadline.getProcessTime());
                        sqltemp.append(" then '" + deadline.getColor().replace("#", "\\#") + "' ");
                    }
                }
            });
            sqltemp.append(" end color ,");
        }
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)businessType) && !"0".equals(businessType)) {
            String typeSql = "with recursive temp as(select t.res_id,t.parent_id from STF_BUSINESS_type t where t.res_id =#businessType#\nunion all \nselect t.res_id,t.parent_id from STF_BUSINESS_type t,temp  where t.parent_id = temp.res_id )\n select group_concat(t.res_id) type from temp t ";
            params.put("businessType", businessType);
            List<Map<String, Object>> typeList = this.bSqlHelper.serachBySql(typeSql, params);
            if (CollectionUtils.isNotEmpty(typeList)) {
                businessType = typeList.get(0).get("type").toString();
            }
        }
        sql.append("SELECT " + sqltemp + " t.*,z.biz_type, (case when  r.is_read ='Y' then z.title_Style else  concat('font-weight:bold;',z.title_Style) end) title_Style ,\n       b.account_name  AS account_Name,(select d.abbr from bas_dept d where d.dept_id =b.dept_id) dept_name,\n       b2.account_name AS creator,\n       r.is_read       AS is_read\n  FROM BAS_MESSAGE t\n  left join wf_workitem i on t.workitemid=i.workitemid    left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where  r.account_id = #accountid# and r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n \t\t\t\tand a.agent_account = #accountid# \t\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND ((concat('%,' , a.agent_content , ',%')) LIKE\n                    (concat('%,' , f.flow_cat_id , ',%')) AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  LEFT JOIN bas_emp_account b\n    ON t.sender = b.account_id\n  LEFT JOIN WF_PROCESSDEFINE_PROCESSINST w\n    ON t.processinstid = w.processinstid\n  LEFT JOIN bas_emp_account b2\n    ON w.creator = b2.account_id\n  LEFT JOIN stf_business_process y\n \t ON y.design_name = w.PROCESSDEFNAME\n  LEFT JOIN STF_BUSINESS_type z\n\t ON z.res_id = y.business_type_id\n");
        sql.append(" WHERE t.is_use = 'Y' and i.CURRENTSTATE in(4,10) \n");
        if (StringUtils.isNotBlank((String)businessType) && !"0".equals(businessType)) {
            businessType = "," + businessType + ",";
            sql.append(" and  #businessType# like concat('%,',z.res_id,',%') \n");
            params.put("businessType", businessType);
        }
        if ((currentUser = SecurityUtils.getSubject()).hasRole("ORG_KJ")) {
            // empty if block
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            sql.append("   and  DATE_FORMAT(SENDTIME,'%Y-%m-%d') BETWEEN  #startDate# and #endDate# \n");
            params.put("startDate", startDate);
            params.put("endDate", endDate);
        }
        if (StringUtil.isNotEmpty(subject)) {
            sql.append("   and  MSG_TITLE like  #subject# \n");
            params.put("subject", "%" + subject + "%");
        }
        if (StringUtil.isNotEmpty(createName)) {
            sql.append("   and  b2.account_name like  #createName# \n");
            params.put("createName", "%" + createName + "%");
        }
        sql.append("   and r.account_id = #accountid#\n   AND t.msg_type NOT IN (3, 4, 5) \n");
        params.put("accountid", accountid);
        sql.append("and not exists (select 1 from bas_message_collapse c where c.is_common='Y' and c.is_use='Y' and c.flow_code = y.design_name and (find_in_set (i.ACTIVITYDEFID,c.act_id)!=0 or c.act_id is null or c.ACT_ID='' ))");
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like #search#  or upper(b.account_name) like #search# ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc ");
        List<Map<String, Object>> list = this.bSqlHelper.serachBySql(sql.toString(), params);
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            list.addAll(0, bma.getMsgList().stream().map(t -> {
                try {
                    return PropertyUtils.describe((Object)t);
                }
                catch (Exception e) {
                    return new HashMap();
                }
            }).filter(a -> a.get("msgTitle") != null).collect(Collectors.toList()));
        }
        list.addAll(0, this.getCollapseMsg(accountid, search, null, null, null, null, businessType));
        return list;
    }

    public PageObject PageToDoListApp(Long accountid, String itemTypeId, String search, Integer page, Integer rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select c.app_url,\n       t.*,\n       b1.account_name accountName,\n       w.PROCESSDEFNAME,\n       case c.is_app when 'Y' then  nvl2(c.app_url, 1, 2) else  3 end MSG_FLAG,\n       r.is_read,\n       (\twith recursive temp as(\n\t\t select a.* from STF_BUSINESS_TYPE a where  a.res_id = s.business_type_id\n\t\t union all\n\t\t select a.* from STF_BUSINESS_TYPE a,temp t where t.PARENT_ID=a.RES_ID  ) \n\t\t select name from temp where PARENT_ID=0) item_type\n  from BAS_MESSAGE t\n  left join wf_workitem i on t.workitemid=i.workitemid    left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where  r.account_id = :accountid and r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n                AND s.msg_id = e.msg_id\n \t\t\t\tand a.agent_account = :accountid \t\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND (concat('%,',a.agent_content ,',%') LIKE\n                   concat('%,' ,f.flow_cat_id,',%') AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  left join bas_emp_account b1\n    on t.sender = b1.account_id\n  left join wf_processinst p\n    on p.processinstid = t.processinstid\n  left join stf_business_process s\n    on s.design_name = p.processinstname\n  left join GEN_FORM c\n    on t.form_code = c.form_code\n   and c.is_use = 'Y'\n inner join wf_processdefine_processinst w\n    on t.processinstid = w.processinstid\n where t.is_use = 'Y'\n   and t.msg_type not in (3, 4, 5)\n   and r.account_id = :accountid  and i.CURRENTSTATE in(4,10) \n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(itemTypeId)) {
            params.put("itemTypeId", itemTypeId);
            sql.append(" and (select y.res_id from stf_business_type y where y.parent_id = 0 start with y.res_id = s.business_type_id connect by y.res_id = prior y.parent_id)=:itemTypeId \n");
        }
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like :search  or upper(b.account_name) like :search ) \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SENDTIME desc ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        return pageobject;
    }

    public PageObject getSwToList(Long accountid, String search, String startDate, String endDate, String businessType, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search + "%");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        params.put("accountid", accountid);
        params.put("businessType", businessType);
        return this.bSqlHelper.searchPage("base.BasMessage.getSwToList", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject pageHaveDoneList(String isBusiness, Long accountid, String startDate, String endDate, String search, int page, int rows, String subject, String createName, String flowType) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT\n a.MSG_ID,\n a.processinstid,\n a.MSG_TITLE,\n a.msg_url,\n a.msg_type,\n a.form_code,\n a.busi_main_id,\n DATE_FORMAT(a.sendtime,'%Y-%m-%d %H:%i:%s') AS SENDTIME,\n DATE_FORMAT(t.ENDTIME,'%Y-%m-%d %H:%i:%s') as deal_time,\n b.account_name,\n b2.account_name creator,\n( SELECT group_concat( t.ACCOUNT_NAME)  FROM bas_message_receive r,bas_message m,BAS_EMP_ACCOUNT   t  WHERE m.PROCESSINSTID = t.PROCESSINSTID and m.IS_USE='Y' and m.msg_type='1' and r.MSG_ID=m.MSG_ID and r.ACCOUNT_ID = t.ACCOUNT_ID)  AS receive_By,\nifnull((select group_concat(DISTINCT w.workitemname) from wf_workitem w where w.processinstid = a.processinstid and w.currentstate IN (4, 10)),'\u7ed3\u675f') workitemname\nFROM\n\t(SELECT\n\tt.WORKITEMID,\n\tt.PROCESSINSTID ,\n\tt.ENDTIME,\n\t ROW_NUMBER() over(PARTITION by t.PROCESSINSTID ORDER BY t.ENDTIME DESC) as ro\nFROM\n\twf_workitem t \nWHERE\n\tt.PARTICIPANT =:accountid \n\tAND t.CURRENTSTATE = 12) t\njoin bas_message a on a.WORKITEMID = t.WORKITEMID and a.msg_type='1' and a.is_use='N'\nleft join wf_processinst w on t.PROCESSINSTID = w.PROCESSINSTID\nLEFT JOIN STF_BUSINESS_PROCESS e ON e.design_name = w.PROCESSINSTNAME\t\nLEFT JOIN stf_business_type y ON y.res_id = e.business_type_id \nleft join bas_emp_account b on a.sender = b.account_id\nLEFT JOIN bas_emp_account b2 ON w.creator = b2.account_id\nWHERE t.ro=1");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid.toString());
        if (StrKit.notBlank(subject)) {
            sql.append("\tand locate( :subject , MSG_TITLE ) > 0  \n");
            params.put("subject", subject);
        }
        if (StrKit.notBlank(createName)) {
            sql.append("\tand locate( :createName , b2.account_name ) > 0  \n");
            params.put("createName", createName);
        }
        if (StrKit.notBlank(startDate)) {
            sql.append("\tand DATE_FORMAT(t.ENDTIME,'%Y-%m-%d') >= :startDate \n");
            params.put("startDate", startDate);
        }
        if (StrKit.notBlank(endDate)) {
            sql.append("\tand DATE_FORMAT(t.ENDTIME,'%Y-%m-%d') <= :endDate \n");
            params.put("endDate", endDate);
        }
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(a.MSG_TITLE) like :search  or upper(b.account_name) like :search ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (StrKit.notBlank(flowType)) {
            sql.append(" \tAND y.res_id IN\n\t(\n\twith recursive temp as(\n\t select a.* from stf_business_type a where  a.RES_ID = :flowType\n\t union all\n\t select a.* from stf_business_type a,temp t where a.PARENT_ID=t.RES_ID  )\nSELECT\n\tt.RES_ID id\nFROM \n        temp t\nORDER BY \n        t.RES_ID\n\t) ");
            params.put("flowType", flowType);
        }
        sql.append(" order by ifnull(t.ENDTIME,now()) desc ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("MSG_TYPE", "MSG_TYPE");
        dicmapper.put("BUSI_TYPE", "BUSINESS_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<BasMessage> queryHaveDoneList(Long accountid, String search, int page, int rows) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.* from (SELECT\n a.*,DATE_FORMAT(t.ENDTIME,'%Y-%m-%d %H:%i:%s') as dealtime,\nifnull((select group_concat(DISTINCT w.workitemname) from wf_workitem w where w.processinstid = a.processinstid and w.currentstate IN (4, 10)),'\u7ed3\u675f') workitemname\nFROM\n\t(SELECT\n\tt.WORKITEMID,\n\tt.PROCESSINSTID ,\n\tt.ENDTIME,\n\t ROW_NUMBER() over(PARTITION by t.PROCESSINSTID ORDER BY t.ENDTIME DESC,t.WORKITEMID DESC) as ro\nFROM\n\twf_workitem t \nWHERE\n\t(t.PARTICIPANT =#accountid# or t.AGENT_PARTICIPANT=#accountid#)\n\tAND t.CURRENTSTATE = 12) t\njoin bas_message a on a.WORKITEMID = t.WORKITEMID and a.msg_type='1' and a.is_use='N'\nleft join bas_emp_account b on a.sender = b.account_id\nWHERE t.ro=1");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid.toString());
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(a.MSG_TITLE) like #search#  or upper(b.account_name) like #search# ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by ifnull(t.ENDTIME,now()) desc ");
        sql.append(" )t   limit #largenum#,#bignum# ");
        params.put("largenum", (page - 1) * rows);
        params.put("bignum", page * rows);
        List<BasMessage> list = this.bSqlHelper.serachBySql(sql.toString(), params, BasMessage.class);
        return list;
    }

    public PageObject pageHaveDoneListApp(Long accountid, String search, String flowType, int page, int rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select c.app_url,a.MSG_ID,a.processinstid,a.MSG_TITLE,a.msg_type,a.form_code,a.busi_main_id,DATE_FORMAT(a.sendtime,'yyyy-mm-dd %H:%i:%s') AS SENDTIME,DATE_FORMAT(t.deal_time,'%Y-%m-%d %H:%i:%s') as deal_time,b.account_name\n  from BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n inner join GEN_FORM c on a.FORM_code = c.FORM_code and c.is_app = 'Y' \n inner join wf_processdefine_processinst  w  on a.PROCESSINSTID = w.PROCESSINSTID \nLEFT JOIN STF_BUSINESS_PROCESS e ON e.design_name = w.PROCESSDEFNAME\n\tLEFT JOIN stf_business_type y ON y.res_id = e.business_type_id\n   where  t.account_id=:accountid and t.is_deal='Y' \n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StringUtils.isNotBlank((String)flowType)) {
            sql.append("and y.res_id in\n\t(\n\twith recursive temp as(\n\t                     select aa.* from stf_business_type aa where  aa.RES_ID = :flowType\n\t                     union all\n\t                     select aa.* from stf_business_type aa,temp t where aa.PARENT_ID=t.RES_ID  )\n\t                     select t.res_id id from temp t order by t.res_id\n\t)");
            params.put("flowType", flowType);
        }
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(a.MSG_TITLE) like :search  or upper(b.account_name) like :search ) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.DEAL_TIME desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        return pageobject;
    }

    public PageObject pageAccountMessageList(Long accountid, String msgType, String isRead, String search, Integer page, Integer rows) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.MSG_ID,a.processinstid,a.MSG_TITLE,a.msg_type,a.form_code,a.busi_main_id,a.msg_url msg_url,t.is_read,DATE_FORMAT(a.sendtime,'%Y-%m-%d %H:%i:%s') as send_time,b.account_name,b1.account_name creator_name\n  from BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n  left join wf_processinst f\n    on a.processinstid = f.processinstid\n  left join bas_emp_account b1\n    on f.creator = b1.account_id\n   where  t.account_id=:accountid  and a.is_use = 'Y' ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)isRead)) {
            sql.append("and t.IS_READ=:isRead ");
            params.put("isRead", isRead);
        }
        if (StringUtils.isNotEmpty((String)msgType)) {
            sql.append("and a.msg_type=:msgType ");
            params.put("msgType", msgType);
        } else {
            sql.append("and a.msg_type=:msgType ");
            params.put("msgType", SysContent.MSG_ALERT);
            sql.append("and a.form_code NOT IN ('HrEmp') ");
        }
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (upper(a.MSG_TITLE) like :search or  upper(b.account_name) like :search)");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.is_read, a.sendtime desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<BasMessage> getMessageWarnAlert(Long accountid, String search) {
        ArrayList<BasMessage> messageList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.*\n  from BAS_MESSAGE_RECEIVE t\n  left join BAS_MESSAGE a\n    on t.msg_id = a.msg_id\n  left join bas_emp_account b\n    on a.sender = b.account_id\n   where  t.account_id=:accountid and a.msg_type = " + SysContent.MSG_WARN + " and a.is_use = 'Y'");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and upper(a.MSG_TITLE) like :search ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.is_read, a.sendtime desc");
        messageList = this.sqlHelper.queryByNativeSQL(sql.toString(), params, BasMessage.class, new int[0]);
        return messageList;
    }

    public List<BasMessage> findAccountWarningList(Long accountid, String search) {
        ArrayList<BasMessage> msglist = new ArrayList<BasMessage>();
        List<BasMessage> messagelist = this.getMessageWarnAlert(accountid, search);
        msglist.addAll(messagelist);
        Map<String, IBasMessageWarnAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageWarnAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageWarnAdditional bma = map.get(key);
            msglist.addAll(bma.getWarnList());
        }
        Collections.sort(msglist);
        return msglist;
    }

    public void saveMessage(Long processInstId, String msgTitle, String params, List<Long> reciveIds, String msgUrl, String msgytype, String formCode, String businessMainId) {
        this.saveMessage(processInstId, null, msgTitle, params, SysUtils.getLoginAccountId(), reciveIds, msgUrl, msgytype, formCode, businessMainId, null, null, true);
    }

    public void saveMessage(Long processInstId, String msgTitle, JSONObject params, List<Long> reciveIds, String msgUrl, String msgytype, String businessType, String formCode, String businessMainId) {
        this.saveMessage(processInstId, null, msgTitle, params.toString(), SysUtils.getLoginAccountId(), reciveIds, msgUrl, msgytype, businessType, formCode, businessMainId, null, null, true);
    }

    public void saveMessage(Long processInstId, Long workitemid, String msgTitle, String params, Long accountid, List<Long> reciveIds, String msgUrl, String msgytype, String formCode, String businessMainId, Long msglevel, String listUrl, boolean isSendDD) {
        if (msgTitle != null) {
            msgTitle = msgTitle.replaceAll("\t|\r|\n", "");
        }
        BasMessage basMessage = new BasMessage();
        basMessage.setProcessinstid(processInstId);
        basMessage.setWorkitemid(workitemid);
        basMessage.setMsgTitle(msgTitle);
        basMessage.setMsgUrl(msgUrl);
        basMessage.setBusiMainId(businessMainId);
        basMessage.setFormCode(formCode.toString());
        basMessage.setSender(accountid);
        basMessage.setSendtime(new Date());
        basMessage.setMsgType(Long.parseLong(msgytype));
        basMessage.setBusiType("0");
        basMessage.setIsPublic("Y");
        basMessage.setIsUse("Y");
        basMessage.setMsgLevel(msglevel == null ? SysContent.MSG_LEVEL_0 : msglevel);
        basMessage.setMsgParams(params);
        BasMessage message = (BasMessage)this.basmessageDao.save(basMessage);
        String sendername = "";
        if (accountid != null) {
            sendername = this.basEmpAccountService.findById(accountid).getAccountName();
        }
        isSendDD = processInstId != null && isSendDD;
        loger.info((Object)("\u6267\u884c\u6d41\u7a0b\u751f\u6210\u6d88\u606f\u7684\u76f8\u5173\u4fe1\u606f:" + JSON.toJSONString((Object)message)));
        this.saveMsgDetail(message, reciveIds, msgTitle, listUrl, sendername, isSendDD, processInstId, formCode, businessMainId);
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            this.entityManager.flush();
            message = this.flowUtilService.fillMessage(message);
            if ("start".equals(listUrl)) {
                message.setApplyUrl("/GenForm/form?formcode=" + formCode + "&newpage=true&isdetail=true&id=" + message.getBusiMainId());
                message.setApplyAppUrl("/pages/common/workflow?formcode=" + formCode + "&processid=" + StringUtil.null2String(message.getProcessinstid()) + "&isApprove=false&fromMyApply=true&mainid=" + message.getBusiMainId());
            }
            bma.onMessageSave(message, reciveIds);
        }
    }

    public void saveMessage(Long processInstId, Long workitemid, String msgTitle, String params, Long accountid, List<Long> reciveIds, String msgUrl, String msgytype, String businessType, String formCode, String businessMainId, Long msglevel, String listUrl, boolean isSendDD) {
        if (msgTitle != null) {
            msgTitle = msgTitle.replaceAll("\t|\r|\n", "");
        }
        BasMessage basMessage = new BasMessage();
        basMessage.setProcessinstid(processInstId);
        basMessage.setWorkitemid(workitemid);
        basMessage.setMsgTitle(msgTitle);
        basMessage.setMsgUrl(msgUrl);
        basMessage.setBusiMainId(businessMainId);
        basMessage.setFormCode(formCode.toString());
        basMessage.setSender(accountid);
        basMessage.setSendtime(new Date());
        basMessage.setMsgType(Long.parseLong(msgytype));
        basMessage.setBusiType(businessType);
        basMessage.setIsPublic("Y");
        basMessage.setIsUse("Y");
        basMessage.setMsgLevel(msglevel == null ? SysContent.MSG_LEVEL_0 : msglevel);
        basMessage.setMsgParams(params);
        BasMessage message = (BasMessage)this.basmessageDao.save(basMessage);
        String sendername = "";
        if (accountid != null) {
            sendername = this.basEmpAccountService.findById(accountid).getAccountName();
        }
        isSendDD = processInstId != null && isSendDD;
        loger.info((Object)("\u6267\u884c\u6d41\u7a0b\u751f\u6210\u6d88\u606f\u7684\u76f8\u5173\u4fe1\u606f:" + JSON.toJSONString((Object)message)));
        this.saveMsgDetail(message, reciveIds, msgTitle, listUrl, sendername, isSendDD, processInstId, formCode, businessMainId);
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            this.entityManager.flush();
            message = this.flowUtilService.fillMessage(message);
            bma.onMessageSave(message, reciveIds);
        }
    }

    public void saveMsgDetail(BasMessage message, List<Long> reciveIds, String msgTitle, String listUrl, String sendername, boolean isFlow, Long processInstId, String formCode, String businessMainId) {
        ArrayList<String> clientIds = new ArrayList<String>(reciveIds.size());
        for (Long reciveId : reciveIds) {
            BasMessageReceive basMessageDetail = new BasMessageReceive();
            basMessageDetail.setMsgId(message.getMsgId());
            basMessageDetail.setAccountId(reciveId);
            basMessageDetail.setIsDeal("N");
            basMessageDetail.setIsRead("N");
            this.basMessageReceiveDao.save(basMessageDetail);
            List<BasDeviceUser> devs = this.BasDeviceUserDao.findByAccountIdOrderByIdDesc(reciveId);
            if (devs.isEmpty()) continue;
            clientIds.add(devs.get(0).getClientId());
        }
        JSONObject json = new JSONObject();
        json.put("businessMainId", (Object)businessMainId);
        json.put("msgId", (Object)message.getMsgId());
        json.put("formCode", (Object)message.getFormCode());
        json.put("processid", (Object)message.getProcessinstid());
        new Thread(() -> {}).start();
    }

    public void sendMsg(String userIds, String title, String listUrl, String sendername, boolean isFlow, long msgId, long processInstId, String formCode, String businessMainId) {
    }

    public void delMydealByWorkitemid(Long workitemid, Long accountid, String follows, String TH) {
        String sql = "SELECT d.*\n  FROM bas_message t,\n       bas_message_receive d\n WHERE  d.account_id=?2\n   and d.is_deal='N'\n\tand t.msg_id=d.msg_id\n\tand t.workitemid=?1\n";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{workitemid, accountid}, BasMessageReceive.class, new int[0]);
        HashMap<Long, Long> ids = new HashMap<Long, Long>();
        ArrayList<Long> msgIds = new ArrayList<Long>();
        if (!list.isEmpty()) {
            BasMessageReceive detail = (BasMessageReceive)list.get(0);
            ids.put(detail.getMsgId(), accountid);
            detail.setIsDeal("Y");
            detail.setIsRead("Y");
            detail.setDealTime(new Date());
            this.basMessageReceiveDao.save(detail);
            BasMessage msg = (BasMessage)this.basmessageDao.findById(detail.getMsgId()).get();
            msg.setMsgTitle(msg.getMsgTitle().replace("\u5f85\u5904\u7406", "\u5df2\u5904\u7406"));
            msg.setIsUse("N");
            msg.setFollowType(follows);
            this.basmessageDao.save(msg);
            if (!msgIds.contains(msg.getMsgId())) {
                msgIds.add(msg.getMsgId());
            }
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                bma.onDelMydealByWorkitemid(msg, detail, TH);
            }
        }
        if (!msgIds.isEmpty()) {
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                bma.onMessageDel(msgIds, "A", accountid.toString());
            }
        }
    }

    public void delMydealByProcessinstid(Long processinstid, String businessMainId) {
        List<BasMessage> list = this.basmessageDao.findByProcessinstidAndBusiMainIdAndIsUse(processinstid, businessMainId, "Y");
        ArrayList<Long> msgIds = new ArrayList<Long>();
        for (BasMessage msg : list) {
            msg.setIsUse("N");
            msgIds.add(msg.getMsgId());
        }
        this.basmessageDao.saveAll(list);
        this.deleteOADb(list);
        if (!msgIds.isEmpty()) {
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                bma.onMessageDel(msgIds, new String[0]);
            }
        }
    }

    public void delMydealByProcessinstid(Long processinstid) {
        List<BasMessage> list = this.basmessageDao.findByProcessinstidOrderByMsgId(processinstid);
        ArrayList<Long> msgIds = new ArrayList<Long>();
        for (BasMessage msg : list) {
            msg.setIsUse("N");
            msgIds.add(msg.getMsgId());
        }
        this.basmessageDao.saveAll(list);
        if (!msgIds.isEmpty()) {
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                bma.onMessageDel(msgIds, new String[0]);
            }
        }
    }

    private void deleteOADb(List<BasMessage> list) {
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (BasMessage msg : list) {
            List<BasMessageReceive> receives = this.basMessageReceiveDao.findByMsgId(msg.getMsgId());
            if (receives.isEmpty()) continue;
            for (BasMessageReceive receive : receives) {
                for (String key : map.keySet()) {
                    IBasMessageAdditional bma = map.get(key);
                    bma.onOaMessageDel(msg.getProcessinstid(), receive.getAccountId(), receive.getMsgId(), receive.getIsDeal() == "Y" ? "\u5df2\u529e" : "\u5f85\u529e");
                }
            }
        }
    }

    public List<Map<String, Object>> findAccountToDoList(Long accountid) {
        return this.PageToDoList(accountid, null);
    }

    public List<Map<String, Object>> findToDoListForAdm(Long accountid) {
        return this.PageToDoList(accountid, null);
    }

    public BasMessage findMsgByProcessinstid(Long accountid, Long processinstid) {
        if (processinstid == null || accountid == null) {
            return null;
        }
        Long workitemid = this.flowUtilService.getWorkItemId(processinstid);
        if (workitemid == null) {
            return new BasMessage();
        }
        BasMessage message = this.basmessageDao.findByWorkitemidAndProcessinstidAndIsUseAndMsgType(workitemid, processinstid, "Y", SysContent.MSG_BASE);
        return message;
    }

    public HashMap<String, List<BasMessage>> findMsgs() throws ParseException {
        HashMap<String, List<BasMessage>> hashMap = new HashMap<String, List<BasMessage>>();
        StringBuilder sqlMsg = new StringBuilder();
        sqlMsg.append("SELECT t.msg_id,\n       t.msg_title,\n       t.sender senderid,\n       t.msg_url,\n       t.busi_type,\n       p.ACCOUNT_ID reciveid,\n       DATE_FORMAT(t.sendtime,'%Y-%m-%d %H:%i:%s') sendtime\n  FROM bas_message        t,\n       BAS_MESSAGE_RECEIVE p\n WHERE t.msg_id = p.msg_id\n      -- AND t.busi_type IN (0, 1)\n\tand t.is_use='Y' \n   AND p.is_read = 'N'\n ORDER BY t.sendtime DESC");
        List list = this.sqlHelper.queryByNativeSQL(sqlMsg.toString(), new int[0]);
        for (Object o : list) {
            Map row = (Map)o;
            BasMessage basMessage = new BasMessage();
            basMessage.setMsgId(Long.parseLong(row.get("MSG_ID").toString()));
            String titleStr = SysUtils.removeHtmlTag(row.get("MSG_TITLE").toString());
            if (StringUtils.isEmpty((String)titleStr.trim().replaceAll("&nbsp;", ""))) {
                basMessage.setMsgTitle("\u672a\u8bfb\u6d88\u606f");
            } else if (titleStr.length() > 40) {
                basMessage.setMsgTitle(titleStr.substring(0, 39) + "\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
            } else {
                basMessage.setMsgTitle(titleStr);
            }
            if (row.get("MSG_URL") != null) {
                basMessage.setMsgUrl(row.get("MSG_URL").toString());
            }
            basMessage.setSender(Long.parseLong(row.get("SENDERID").toString()));
            basMessage.setBusiType(row.get("BUSI_TYPE").toString());
            basMessage.setSendtime(DateUtils.strToTime(row.get("SENDTIME").toString()));
            basMessage.setReciveId(Long.parseLong(row.get("RECIVEID").toString()));
            if (!hashMap.keySet().contains(row.get("RECIVEID").toString())) {
                hashMap.put(row.get("RECIVEID").toString(), new ArrayList());
            }
            hashMap.get(row.get("RECIVEID").toString()).add(basMessage);
        }
        return hashMap;
    }

    public BasMessage maintain() {
        StringBuilder sql = new StringBuilder();
        sql.append("select *  from BAS_MESSAGE t where t.is_use='Y' and t.msg_type = 2 and t.sendtime > now() order by t.sendtime desc ");
        Object o = this.sqlHelper.getSingal(sql.toString(), null, BasMessage.class);
        if (o != null) {
            return (BasMessage)o;
        }
        return null;
    }

    public void setMsgIsRead(Long accountid, Long msgid) {
        List<BasMessageReceive> receivelist = this.basMessageReceiveDao.findByAccountIdAndMsgId(accountid, msgid);
        for (BasMessageReceive basMessageReceive : receivelist) {
            if (basMessageReceive.getReadTime() == null) {
                basMessageReceive.setReadTime(new Date());
            }
            basMessageReceive.setIsRead("Y");
            this.basMessageReceiveDao.save(basMessageReceive);
        }
    }

    public void setMsgIsRead(Long accountid) {
        List<BasMessageReceive> receivelist = this.basMessageReceiveDao.findByAccountId(accountid);
        for (BasMessageReceive basMessageReceive : receivelist) {
            basMessageReceive.setIsRead("Y");
            if (basMessageReceive.getReadTime() == null) {
                basMessageReceive.setReadTime(new Date());
            }
            this.basMessageReceiveDao.save(basMessageReceive);
        }
    }

    public BasMessage findMsgByBizTypeAndBizMainId(Long bizType, String bizMainId) {
        return this.basmessageDao.findByBusiTypeAndBusiMainId(bizType, bizMainId);
    }

    public List<BasMessage> getAccountMessageList(Long accountid, Long type) {
        String sql = "select b.*\n  from bas_message_receive a, bas_message b\n where a.msg_id = b.msg_id\n   and b.msg_type = ?2\n   and a.account_id = ?1\n   and a.is_read = 'N'\n   and b.is_use = 'Y'\n";
        if (SysContent.MSG_ALERT.equals(type)) {
            sql = sql + " and b.form_code NOT IN ('HrEmp') ";
        }
        sql = sql + " order by b.sendtime desc";
        return this.sqlHelper.queryByNativeSQL(sql, new Object[]{accountid, type}, BasMessage.class, new int[0]);
    }

    public List<Map<String, Object>> findAccountMakeCopyList(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = " WITH person AS (\n\tSELECT\n\t\tgroup_concat(s.participant) participant,\n\t\tgroup_concat(DISTINCT s.workitemname) workitemname,\n\t\ts.processinstid\n\tFROM\n\t\t(\n\t\t\tSELECT\n\t\t\t\tp.participant,\n\t\t\t\ttt.workitemname,\n\t\t\t\ttt.processinstid\n\t\t\tFROM\n\t\t\t\tWF_WORKITEM tt,\n\t\t\t\tWF_PARTICIPANT p\n\t\t\tWHERE\n\t\t\t\ttt.currentstate IN (4, 10)\n\t\t\tAND p.partictype = 'role'\n\t\t\tAND tt.workitemid = p.workitemid\n\t\t\tUNION ALL\n\t\t\t\tSELECT\n\t\t\t\t\tp.participant,\n\t\t\t\t\tworkitemname,\n\t\t\t\t\ttt.processinstid\n\t\t\t\tFROM\n\t\t\t\t\tWF_WORKITEM tt,\n\t\t\t\t\tWF_PARTICIPANT p\n\t\t\t\tWHERE\n\t\t\t\t\ttt.currentstate IN (4, 10)\n\t\t\t\tAND p.partictype = 'person'\n\t\t\t\tAND tt.workitemid = p.workitemid\n\t\t) s\n\tGROUP BY\n\t\ts.processinstid\n)\nSELECT\n\tb.*,\n  CASE\n\t\tWHEN p.workitemname = '' THEN\n\t\t\t'\u7ed3\u675f'\n\t\tWHEN p.workitemname IS NULL THEN\n\t\t\t'\u7ed3\u675f'\n\t\tELSE\n\t\t\tp.workitemname\n\t\tEND AS workitemname\nFROM\n\t\n bas_message b  \nLEFT JOIN bas_message_receive a ON a.msg_id = b.msg_id\nLEFT JOIN person p ON p.processinstid = b.processinstid\nWHERE\n b.msg_type = 5\nAND a.account_id = #accountid#\nAND a.is_read = 'N'\nAND b.is_use = 'Y'\nORDER BY\n\tb.sendtime DESC";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapList(Long accountid, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        String sql = "select b.*,a.is_read,to_char(b.sendtime,'yyyy-mm-dd hh24:mi:ss') sendtime_All,k.PHOTO_VERSION_ID,getaccountname(b.sender) sender_name\n  from bas_message_receive a, bas_message b ,BAS_EMP_ACCOUNT c,hr_emp k,bas_emp h    \n where a.msg_id = b.msg_id\n   and b.msg_type = 3\n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type#  \n") + "   and b.is_use = 'Y' and  c.EMP_ID=h.EMP_ID AND b.sender=c.ACCOUNT_ID and h.hr_emp_id=k.emp_id \n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getMsgInfoByCodeAndType(Long accountid, String formCode, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("formCode", formCode);
        params.put("type", type);
        String sql = "select b.*,a.is_read,to_char(b.sendtime,'yyyy-mm-dd hh24:mi:ss') sendtime_All,k.PHOTO_VERSION_ID,getaccountname(b.sender) sender_name\n  from bas_message_receive a, bas_message b ,BAS_EMP_ACCOUNT c,hr_emp k,bas_emp h    \n where a.msg_id = b.msg_id\n   and b.msg_type = 3  and ifnull(a.IS_SHOW, 'Y') !='N' \n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y' and b.FORM_CODE=#formCode# and b.PROCESSINSTID is null and  c.EMP_ID=h.EMP_ID AND b.sender=c.ACCOUNT_ID and h.hr_emp_id=k.emp_id\n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getMsgInfoAll(Long accountid, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        String sql = "select b.*,a.is_read,date_format(b.sendtime,'%Y-%m-%d %H:%i:%s') sendtime_All,d.FORM_NAME AS MSG_TYPE_NAME,k.PHOTO_VERSION_ID,getaccountname(b.sender) sender_name,NVL2(b.PROCESSINSTID, 'liucheng',d.icon ) ICON\r\n  from bas_message_receive a, bas_message b ,BAS_EMP_ACCOUNT c,hr_emp k,bas_emp h,GEN_FORM d    \n where a.msg_id = b.msg_id\n   and b.msg_type = 3 and ifnull(a.IS_SHOW, 'Y') !='N' and b.FORM_CODE=d.FORM_CODE and d.is_use='Y'\n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y'   and  c.EMP_ID=h.EMP_ID AND b.sender=c.ACCOUNT_ID and h.hr_emp_id=k.hr_emp_id\n   order by b.sendtime asc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public void clearMessageList(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "UPDATE bas_message_receive a\r\n\t\t\t\tSET a.IS_SHOW = 'N' \r\n\t\t\t\tWHERE\r\n\t\t\t\t\ta.account_id =#accountid# and  a.MSG_ID IN (SELECT MSG_ID FROM BAS_MESSAGE WHERE MSG_TYPE=3 AND IS_USE='Y') \r\n";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapInfo(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "SELECT\r\n\tifnull( sum( case  a.is_read when 'Y' then 1 else  0 end), 0 ) 'read',\r\n\tifnull( sum( case  a.is_read when 'N' then  1 else  0 end), 0 ) not_read \r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tBAS_MESSAGE_RECEIVE a \r\nWHERE\r\n\tt.MSG_TYPE = 3 \r\n\tAND t.MSG_ID = a.msg_id \r\n\tAND ifnull( a.IS_SHOW, 'Y' ) != 'N' \r\n\tAND a.ACCOUNT_ID =#accountid# \r\n\tAND t.IS_USE = 'Y'";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapInfoToWork(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "SELECT\r\n\t\t\t\tsum(decode(is_read,'Y',1,0)) read,sum(decode(is_read,'N',1,0)) not_read\r\n\t\t\t\tFROM\r\n\t\t\t\t\tBAS_MESSAGE t,\r\n\t\t\t\t\tBAS_MESSAGE_RECEIVE a \r\n\t\t\t\tWHERE\r\n\t\t\t\t\tMSG_TYPE = 3  \r\n\t\t\t\t\tAND t.MSG_ID = a.msg_id \r\n\t\t\t\t\tand t.PROCESSINSTID is NOT NULL\r\n\t\t\t\t\tAND a.ACCOUNT_ID =#accountid#\r\n\t\t\t\t\tAND t.IS_USE='Y' and ifnull(a.IS_SHOW, 'Y')!='N' ";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> findByformCode(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "SELECT\r\nt.*,C.FORM_NAME AS MSG_TYPE_NAME,getaccountname(t.sender) sender_name,DATE_FORMAT(t.sendtime,'%Y-%m-%d %H:%i:%s') sendTime_all\r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tBAS_MESSAGE_RECEIVE a ,GEN_FORM C \r\nWHERE\r\n\tMSG_TYPE = 3 \r\n\tAND t.MSG_ID = a.msg_id and t.FORM_CODE=C.FORM_CODE  \r\n\tAND a.ACCOUNT_ID =#accountid# \r\n\tAND t.IS_USE = 'Y'  AND t.SENDTIME=(SELECT\r\nMAX(t.SENDTIME) \r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tBAS_MESSAGE_RECEIVE a \r\nWHERE\r\n\tMSG_TYPE = 3 \r\n\tAND t.MSG_ID = a.msg_id \r\n\tAND a.ACCOUNT_ID =#accountid# \r\n\tAND t.IS_USE = 'Y'  )";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<Map<String, Object>> findByMaxMsg(Long accountId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountId", accountId);
        String sql = "SELECT\r\nt.*,C.FORM_NAME AS MSG_TYPE_NAME,getaccountname(t.sender) sender_name,to_char(t.sendtime,'yyyy-mm-dd hh24:mi:ss') sendTime_all\r\nFROM\r\n\tBAS_MESSAGE t,\r\n\tGEN_FORM C \r\nWHERE\r\n t.SENDTIME = (\r\n\tSELECT\r\n\t\tmax( t.SENDTIME ) \r\n\tFROM\r\n\t\tBAS_MESSAGE t,\r\n\t\tBAS_MESSAGE_RECEIVE a \r\n\tWHERE\r\n\t\tMSG_TYPE = 3 \r\n\t\tAND t.MSG_ID = a.msg_id \r\n\t\tAND t.PROCESSINSTID IS NOT NULL \r\n\t\tAND a.ACCOUNT_ID =#accountId# \r\n\tAND t.IS_USE = 'Y' \r\n\t)\t\r\n and t.FORM_CODE=C.FORM_CODE  ";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public void setAccountMessageAllReaded(Long accountid, String msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("msgId", msgId);
        String sqlWhere = "a.msg_id = #msgId#\n";
        if (msgId == null) {
            sqlWhere = "a.msg_id in (select msg_id from bas_message b where b.msg_type = 3 and b.is_use = 'Y')\n";
        }
        String sql = "update bas_message_receive a\n   set a.is_read = 'Y', a.read_time = now()\n   where\n " + sqlWhere + "   and a.account_id = #accountid#\n   and a.is_read = 'N'";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public void setAccountMessageFormReaded(Long accountid, String formCode) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("formCode", formCode);
        String sql = "update bas_message_receive a\n   set a.is_read = 'Y', a.read_time = sysdate\n   where\n    a.account_id = #accountid# and a.msg_id in (select b.msg_id from bas_message b where b.msg_type=3 and b.is_use='Y' and b.FORM_CODE=#formCode# and b.PROCESSINSTID is null)\n   and a.is_read = 'N'";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public void setAccountMessageWorkReaded(Long accountid) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        String sql = "update bas_message_receive a\n   set a.is_read = 'Y', a.read_time = sysdate\n   where\n     a.account_id = #accountid# and a.msg_id in (select b.msg_id from bas_message b where b.msg_type=3 and b.is_use='Y' and b.PROCESSINSTID is not null) \n   and a.is_read = 'N'";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public List<Map<String, Object>> getAccountMessageMapList(Long accountid, String type, String queryFormCode, String search) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        String tempSql = "";
        if (StrKit.notNull(queryFormCode)) {
            params.put("queryFormCode", queryFormCode);
            tempSql = tempSql + " and b.form_code = #queryFormCode# \n";
        }
        if (StrKit.notNull(search)) {
            params.put("search", "%" + search + "%");
            tempSql = tempSql + "   and b.msg_title like #search#\n";
        }
        String sql = "select b.*,a.is_read,GETACCOUNTNAME(a.account_id) account_name\n  from bas_message_receive a, bas_message b\n where a.msg_id = b.msg_id\n   and b.msg_type =3\n" + tempSql + "   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y'\n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params);
    }

    public List<BasMessage> getAccountMessageAndWarnMapList(Long accountid, String type, String queryFormCode, String search, String msgType) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("accountid", accountid);
        params.put("type", type);
        params.put("search", "%" + search + "%");
        String sql = "select b.*,a.is_read,GETACCOUNTNAME(a.account_id) account_name\n ,case when a.is_read = 'Y' then '\u5df2\u8bfb' when a.is_read = 'N'  then '\u672a\u8bfb' end as is_read_text\n  from bas_message_receive a, bas_message b\n where a.msg_id = b.msg_id\n   and b.msg_type =3\n   and b.msg_title like #search#\n   and a.account_id = #accountid#\n" + (type.equals("A") ? "\n" : "and a.is_read = #type# \n") + "   and b.is_use = 'Y'\n   order by b.sendtime desc";
        return this.bSqlHelper.serachBySql(sql, params, BasMessage.class);
    }

    public void saveMessageList(String formCode, String title, String msgUrl, Long sender, Long receiveId, String busiMainId) {
        BasMessage message = new BasMessage();
        message.setMsgTitle(title);
        message.setMsgType(SysContent.MSG_ALERT);
        message.setMsgUrl(msgUrl);
        message.setSender(sender);
        message.setBusiType(String.valueOf(SysContent.APP_TYPE_IOP));
        message.setIsPublic("Y");
        message.setBusiMainId(busiMainId);
        message.setFormCode(formCode);
        message.setIsUse("Y");
        message.setSendtime(new Date());
        this.saveBasMessage(message);
        BasMessageReceive receive = new BasMessageReceive();
        receive.setAccountId(receiveId);
        receive.setIsRead("N");
        receive.setIsDeal("N");
        receive.setMsgId(message.getMsgId());
        this.basMessageReceiveDao.save(receive);
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            this.entityManager.flush();
            ArrayList<Long> receiveIds = new ArrayList<Long>();
            receiveIds.add(receiveId);
            message.setApplyUrl("/GenForm/form?formcode=" + formCode + "&newpage=true&isdetail=true&id=" + message.getBusiMainId());
            message.setApplyAppUrl("/pages/common/workflow?formcode=" + formCode + "&processid=" + StringUtil.null2String(message.getProcessinstid()) + "&isApprove=false&fromMyApply=true&mainid=" + message.getBusiMainId());
            bma.onMessageSave(message, receiveIds);
        }
    }

    public Object isHaveTodo(Long accountId1) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (accountId1 != null) {
            params.put("accountId1", accountId1);
        }
        return this.bSqlHelper.getLongValue("business.hr.HrEmp.isHaveTodo", params);
    }

    public PageObject pageBaseFlowSendInfo(String search, int page, int rows, String status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search + "%");
        }
        if (!StringUtils.isEmpty((String)status)) {
            params.put("status", status);
        }
        params.put("admin", SysContent.ADMIN_ACCOUNT_ID);
        return this.bSqlHelper.serachPage("base.BasMessage.BaseFlowSendInfo", params, PageRequest.of((int)page, (int)rows));
    }

    public List<BasMessage> findByformCodeAndbusiMainId(Long id, String formCode) {
        return this.basmessageDao.findByBusiMainIdAndFormCodeAndIsUse(id.toString(), formCode, "Y");
    }

    public Object getMyFlow(Long accountId, String myFLow) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (accountId == null) {
            accountId = SysUtils.getLoginAccountId();
        }
        params.put("accountId", accountId);
        if (StrKit.notBlank(myFLow)) {
            params.put("myFLow", myFLow);
        }
        return this.bSqlHelper.getStringValue("base.BasMessage.getMyFlow", params);
    }

    public JsonMsg sendurge(String actId, Long processInstId, String ids, String msgContent, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstId", processInstId);
        params.put("actId", actId);
        if ("1".equals(type)) {
            List<BasMessage> msgs = this.findByMsgTypeAndProcessinstid(1L, processInstId);
            JSONObject json = new JSONObject();
            this.saveMessage(processInstId, msgContent, json, Arrays.asList(ids.split(",")).stream().map(n -> Long.parseLong(n)).collect(Collectors.toList()), msgs.get(0).getMsgUrl(), "3", "MESSAGE", msgs.get(0).getFormCode(), msgs.get(0).getBusiMainId());
            return new JsonMsg();
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasMessage.getUndoEmpMobileByProcessinstId", params);
        if (list.isEmpty()) {
            return new JsonMsg("\u6ca1\u6709\u627e\u5230\u53ef\u4ee5\u53d1\u9001\u77ed\u4fe1\u7684\u8054\u7cfb\u4eba");
        }
        ArrayList<String> mobiles = new ArrayList<String>(list.size() + 1);
        String msgTitle = Objects.toString(list.get(0).get("msgTitle"), "");
        list.stream().forEach(p -> {
            if (("," + ids + ",").contains("," + Objects.toString(p.get("accountId"), "") + ",")) {
                mobiles.add(Objects.toString(p.get("mobilephone"), ""));
            }
        });
        return this.smsManagerService.sendSms(mobiles, StringUtils.isNotBlank((String)msgContent) ? msgContent : SysUtils.getLoginUser().getAccountName() + "\u5411\u60a8\u53d1\u9001\u4e86\u4e00\u6761\u667a\u7ba1\u5e73\u53f0\u5f85\u529e\u50ac\u529e\uff1a" + msgTitle + "\u3002\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\uff01");
    }

    public List<Map<String, Object>> getUrgePersons(String actId, Long processInstId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstId", processInstId);
        params.put("actId", actId);
        return this.bSqlHelper.getMapList("base.BasMessage.getUndoEmpMobileByProcessinstId", params);
    }

    public List<Map<String, Object>> getUndoAccounts(Long processinstid) {
        String sql = "select t.msg_title,\nt.msg_id,\n       getaccountname(r.account_id) account_name,p.processinstname,\n       r.account_id,\n       t.workitemid,\n      w.workitemname\n  from BAS_MESSAGE t, bas_message_receive r,wf_workitem w,Wf_Processinst p\n where t.msg_id = r.msg_id\n   and w.workitemid=t.workitemid\n   and t.is_use = 'Y'\n   and t.msg_type = 1\n   AND w.processinstid =p.processinstid    AND t.processinstid =#processinstid# ";
        return this.bSqlHelper.serachBySql(sql, MapUtil.of((Object)"processinstid", (Object)processinstid));
    }

    public void updateMsgAccount(Long workitemid, Long accountId, Long msgId, Long newaccountId, String newActId, String newActName) {
        String sql;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("workitemid", workitemid);
        params.put("accountId", accountId);
        BasMessage msg = (BasMessage)this.basmessageDao.findById(msgId).get();
        params.put("msgId", msgId);
        params.put("processinstid", msg.getProcessinstid());
        if (newaccountId != null) {
            params.put("newaccountId", newaccountId);
            params.put("newaccountName", this.basEmpAccountService.findById(newaccountId).getAccountName());
            sql = "update bas_message_receive t set t.account_id=#newaccountId# where t.msg_id=#msgId# and t.account_id=#accountId#";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update WF_WORKITEM t set t.participant=#newaccountId# where t.workitemid=#workitemid#";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update wf_participant t set t.participant=#newaccountId#,participant2=#newaccountName# where t.workitemid=#workitemid#";
            this.bSqlHelper.updateBysql(sql, params);
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newActId, newActName})) {
            params.put("newActId", newActId);
            params.put("newActName", newActName);
            sql = "update WF_WORKITEM t set t.activitydefid=#newActId#,t.workitemname=#newActName# where t.workitemid=#workitemid#";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update wf_transctrl r set r.destactdefid=#newActId#,r.destactdefname=#newActName#  where r.transctrlid in( select x.transctrlid from (select max(t.transctrlid) transctrlid from  wf_transctrl t where t.processinstid=#processinstid# and t.destactdefid=(select w.activitydefid from wf_workitem w where w.workitemid=#workitemid#))x)";
            this.bSqlHelper.updateBysql(sql, params);
            sql = "update wf_activityinst t set  t.activitydefid=#newActId#,t.activityinstname=#newActName#  where t.activityinstid in(select x.activityinstid from (select w.activityinstid from wf_workitem w where w.workitemid=#workitemid#)x)";
            this.bSqlHelper.updateBysql(sql, params);
        }
    }

    public void updateMsgDeal(Long processinstid, Long day) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processinstid", processinstid);
        if (day == null) {
            day = 2L;
        }
        params.put("day", day);
        String sql = "update WF_WORKITEM t set t.endtime=t.endtime-#day#,t.starttime=t.starttime-#day# where t.processinstid=#processinstid#\n";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update wf_transctrl t set t.transtime=t.transtime-#day# where t.processinstid=#processinstid#\n";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update wf_activityinst t set t.endtime=t.endtime-#day#,t.starttime=t.starttime-#day#,t.createtime=t.createtime-#day# where t.processinstid=#processinstid#";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update bas_message t set t.sendtime=t.sendtime-#day# where t.processinstid=#processinstid#";
        this.bSqlHelper.updateBysql(sql, params);
        sql = "update bas_message_receive t set t.read_time=t.read_time-#day#,t.deal_time=t.deal_time-#day#  where t.msg_id in( select t.msg_id from bas_message t where t.processinstid=#processinstid#)";
        this.bSqlHelper.updateBysql(sql, params);
    }

    public void msgUrgeAuto() {
        String sql = "select  t.*\n  from bas_message t, bas_message_receive r\n where t.msg_id = r.msg_id\n   and ((t.msg_level = '0' and (now() - t.sendtime) * 24 <= 23) or\n       (t.msg_level = '1' and (now() - t.sendtime) * 24 <= 2.5 ))\n   and t.is_use = 'Y'\n";
        List<BasMessage> msgs = this.bSqlHelper.serachBySql(sql, new HashMap<String, Object>(), BasMessage.class);
        for (BasMessage msg : msgs) {
            this.pushMsgReminde(msg);
        }
    }

    public void pushMsgReminde(BasMessage msg) {
        try {
            String msgTitle = "";
            Date sendTime = msg.getSendtime();
            if ("0".equals(String.valueOf(msg.getMsgLevel()))) {
                sendTime = DateUtils.addHours(sendTime, 23);
                msgTitle = "\u60a8\u6709\u4e00\u6761\u5f85\u529e1\u5c0f\u65f6\u540e\u5373\u5c06\u5230\u671f";
            } else if ("1".equals(String.valueOf(msg.getMsgLevel()))) {
                sendTime = DateUtils.addSecond(sendTime, 150);
                msgTitle = "\u60a8\u6709\u4e00\u6761\u52a0\u6025\u5f85\u529e\u534a\u5c0f\u65f6\u540e\u5373\u5c06\u5230\u671f";
            } else if ("2".equals(String.valueOf(msg.getMsgLevel()))) {
                sendTime = new Date();
                msgTitle = "\u60a8\u6709\u4e00\u6761\u7279\u6025\u5f85\u529e\u6025\u9700\u5904\u7406";
            }
            JSONObject json = new JSONObject();
            json.put("businessMainId", (Object)msg.getBusiMainId().toString());
            json.put("msgId", (Object)msg.getMsgId());
            json.put("formCode", (Object)msg.getFormCode());
            json.put("processid", (Object)msg.getProcessinstid());
            List<BasMessageReceive> receives = this.basMessageReceiveDao.findByMsgId(msg.getMsgId());
            ArrayList<String> clientIds = new ArrayList<String>();
            for (BasMessageReceive receive : receives) {
                List<BasDeviceUser> devs = this.BasDeviceUserDao.findByAccountIdOrderByIdDesc(receive.getAccountId());
                if (devs.isEmpty()) continue;
                clientIds.add(devs.get(0).getClientId());
            }
            if ("2".equals(String.valueOf(msg.getMsgLevel()))) {
                this.pushMsgReminde(msgTitle, msg.getMsgTitle(), json, clientIds);
            } else {
                SchedulingRunnable schedulingRunnable = new SchedulingRunnable("basMessageService", "pushMsgReminde", msgTitle, msg.getMsgTitle(), json, clientIds);
            }
        }
        catch (Exception e) {
            loger.error((Object)"\u624b\u673a\u7aef\u63a8\u9001\u5931\u8d25:", (Throwable)e);
        }
    }

    public void pushMsgReminde(String title, String msgTitle, JSONObject json, ArrayList<String> clientIds) {
        loger.info((Object)("title:" + title + ",clientIds" + msgTitle + ",clientIds" + json.toJSONString() + ",clientIds" + clientIds));
    }

    public List<String> getApproActs(String busiMainId, String formCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", SysUtils.getLoginAccountId());
        params.put("busiMainId", busiMainId);
        params.put("formCode", formCode);
        return this.bSqlHelper.getList("workflow.flow.getApproActsByBizId", params, String.class);
    }

    public List<BasMessage> findByMsgTypeAndProcessinstid(Long msgType, Long processinstid) {
        return this.basmessageDao.findByMsgTypeAndProcessinstidAndIsUse(msgType, processinstid, "Y");
    }

    public int getAccountUndoMsgCount(Long accountId) {
        return this.bSqlHelper.getIntValue("base.BasMessage.getAccountUndoMsgCount", MapUtil.of((Object)"accountId", (Object)accountId));
    }

    public List<Map<String, Object>> getAccountRecordList(Long accountid) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT\nt.feedback_id AS BUSI_MAIN_ID,\nt.task_id AS msg_id,\n'GmTaskFeedback' AS form_code,\nt.record_date AS SEND_TIME,\nt.PROCESSINSTID ,\nGETDICNAME('taskfrom', g.TASK_TYPE) AS MSG_PARAMS,\ng.TASK_NAME AS msg_title\nFROM\nGM_TASK_FEEDBACK t,\ngm_task_content g \nWHERE\ng.TASK_ID = t.TASK_ID \nAND t.is_use = 'Y' \nAND t.WORKFLOW_STATUS = 1 \nAND t.feedback_man = :accountid");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountid", accountid);
        return this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
    }

    public PageObject PageToDoListAppNew(Long accountid, String itemTypeId, String search, Integer page, Integer rows, String isApp, String bizType, String noBizTypes) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.* from(select c.app_url,\n       t.*,z.biz_type,(case when  r.is_read ='Y' then z.title_Style else  concat('font-weight:bold;',z.title_Style) end) title_Style,\n       b1.account_name accountName,\n       w.PROCESSDEFNAME,\n       case c.is_app when 'Y' then  nvl2(c.app_url, 1, 2) else  3 end MSG_FLAG,\n       r.is_read,\n       (\twith recursive temp as(\n\t\t select a.* from STF_BUSINESS_TYPE a where  a.res_id = s.business_type_id\n\t\t union all\n\t\t select a.* from STF_BUSINESS_TYPE a,temp t where t.PARENT_ID=a.RES_ID  ) \n\t\t select name from temp where PARENT_ID=0) item_type,\n       (\twith recursive temp as(\n\t\t select a.* from STF_BUSINESS_TYPE a where  a.res_id = s.business_type_id\n\t\t union all\n\t\t select a.* from STF_BUSINESS_TYPE a,temp t where t.PARENT_ID=a.RES_ID  ) \n\t\t select res_id from temp where PARENT_ID=0) item_type_id\n  from BAS_MESSAGE t\n  left join wf_workitem i on t.workitemid=i.workitemid    left join (SELECT r.msg_id, r.account_id, r.is_read\n               FROM BAS_MESSAGE_RECEIVE r\n              where  r.account_id =:accountid and r.is_deal = 'N'\n             UNION\n             SELECT s.msg_id, a.agent_account, e.is_read\n               FROM WF_AGENT            a,\n                    gen_form            f,\n                    bas_message         s,\n                    bas_message_receive e\n              WHERE s.form_code = f.form_code\n \t\t\t\tand a.agent_account =:accountid \t\n                AND s.msg_id = e.msg_id\n                AND e.account_id = a.agent_to_account\n                AND s.is_use = 'Y'\n                AND e.is_deal = 'N'\n                AND a.is_use = 'Y'\n                AND (concat('%,',a.agent_content ,',%') LIKE\n                   concat('%,' ,f.flow_cat_id,',%') AND\n                    a.end_date > now() AND\n                    (a.cancel_date IS NULL OR a.cancel_date > now()) OR\n                    a.agent_type = '2')) r\n    on r.msg_id = t.msg_id\n  left join bas_emp_account b1\n    on t.sender = b1.account_id\n  left join wf_processinst p\n    on p.processinstid = t.processinstid\n  left join stf_business_process s\n    on s.design_name = p.processinstname\n  LEFT JOIN STF_BUSINESS_type z\n\t ON z.res_id = s.business_type_id\n  left join GEN_FORM c\n    on t.form_code = c.form_code\n   and c.is_use = 'Y'\n inner join wf_processdefine_processinst w\n    on t.processinstid = w.processinstid\n where t.is_use = 'Y'  and i.CURRENTSTATE in(4,10) \n   and t.msg_type not in (3, 4, 5,7)\n   and r.account_id = :accountid \n");
        if (StringUtil.isNotEmpty(isApp) && "Y".equals(isApp)) {
            sql.append("and c.IS_APP = 'Y' \n");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty(bizType)) {
            sql.append("and z.biz_Type =:bizType \n");
            params.put("bizType", bizType);
        }
        if (StringUtil.isNotEmpty(noBizTypes)) {
            sql.append("and ifnull(z.biz_Type,'') not in(:noBizTypes) \n");
            params.put("noBizTypes", ListUtil.of((Object[])noBizTypes.split(",")));
        }
        params.put("accountid", accountid);
        if (StrKit.notBlank(search)) {
            sql.append("  and (    upper(t.MSG_TITLE) like :search  or upper(b1.account_name) like :search ) \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" )t where 1=1 \n");
        if (StrKit.notBlank(itemTypeId)) {
            params.put("itemTypeId", itemTypeId);
            sql.append(" and t.item_type_id=:itemTypeId \n");
        }
        sql.append(" order by t.SENDTIME desc ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        try {
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                List<BasMessageAppModel> templist = bma.getAppMsgList(itemTypeId, search);
                if (templist == null) continue;
                pageobject.getRows().addAll(0, templist.stream().map(t -> {
                    try {
                        Map mt = PropertyUtils.describe((Object)t);
                        HashMap nmt = new HashMap();
                        for (Map.Entry entry : mt.entrySet()) {
                            nmt.put(DBPropertyUtil.underscoreName((String)entry.getKey()).toUpperCase(), entry.getValue());
                        }
                        return nmt;
                    }
                    catch (Exception e) {
                        loger.error((Object)"app\u6269\u5c55\u6d88\u606f\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
                        return new HashMap();
                    }
                }).filter(a -> a.get("MSG_TITLE") != null).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            loger.error((Object)"app\u6269\u5c55\u6d88\u606f\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
        return pageobject;
    }

    public List<Map<String, Object>> getAppTodoSum(Long accountid) {
        String sql = "select a.res_id,a.name,a.res_color,a.res_ico from STF_BUSINESS_TYPE a where a.PARENT_ID=0 and a.is_enabled = 'Y' order by a.ORDER_INDEX";
        List<Map<String, Object>> sumlist = this.bSqlHelper.serachBySql(sql, MapUtil.of((Object)"accountid", (Object)accountid));
        List todolist = this.PageToDoListAppNew(accountid, null, null, 1, 9999999, null, null, null).getRows();
        sumlist.forEach(sum -> sum.put("detail", todolist.stream().filter(todo -> todo.get("ITEM_TYPE") != null && todo.get("ITEM_TYPE").toString().equals(sum.get("name").toString())).collect(Collectors.toList())));
        return sumlist;
    }

    public List<Map<String, Object>> getAppDoneddSum(Long accountid) {
        List<Map<String, Object>> sumlist = this.bSqlHelper.getMapList("base.BasMessage.getHaveDoneSumList", MapUtil.of((Object)"accountid", (Object)accountid));
        return sumlist;
    }

    public void delDealByWorkitemId(String id) {
        String sql = "SELECT d.*\n  FROM bas_message t,\n       bas_message_receive d\n WHERE  d.is_deal='N'\n\tand t.msg_id=d.msg_id\n\tand t.workitemid=?1\n";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{id}, BasMessageReceive.class, new int[0]);
        HashMap ids = new HashMap();
        if (!list.isEmpty()) {
            BasMessageReceive detail = (BasMessageReceive)list.get(0);
            detail.setIsDeal("Y");
            detail.setIsRead("Y");
            detail.setDealTime(new Date());
            this.basMessageReceiveDao.save(detail);
            BasMessage msg = (BasMessage)this.basmessageDao.findById(detail.getMsgId()).get();
            msg.setMsgTitle(msg.getMsgTitle().replace("\u5f85\u5904\u7406", "\u5df2\u5904\u7406"));
            msg.setIsUse("N");
            this.basmessageDao.save(msg);
        }
    }

    public void remindMsg() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("date", LocalDate.now().toString());
        if (this.bSqlHelper.getIntValue("base.BasMessage.checkHolidayByDate", params) == 0) {
            List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasMessage.getTodoGreaterThan4H", null);
            for (Map<String, Object> map : list) {
                SystemMessage.sendMsgRemind(map.get("accountId").toString(), "\u60a8\u6709" + map.get("cou") + "\u6761\u5f85\u529e\u5df2\u8d85\u8fc74\u4e2a\u5c0f\u65f6\u672a\u5904\u7406\uff0c\u8bf7\u53ca\u65f6\u529e\u7406\uff0c\u8c22\u8c22\uff01");
                List<BasDeviceUser> devs = this.BasDeviceUserDao.findByAccountIdOrderByIdDesc(Long.parseLong(map.get("accountId").toString()));
                if (devs.isEmpty()) continue;
            }
        }
    }

    public void remindMsgSend() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("date", LocalDate.now().toString());
        int num = 0;
        try {
            num = this.bSqlHelper.getIntValue("base.BasMessage.findIsSendMsgToDay", params);
        }
        catch (Exception e) {
            num = 0;
        }
        if (num == 0) {
            String ls_sql = " INSERT INTO pub_flow_send_log(ID,SEND_DATE,IS_USE)( select ( select count(*)+1 from pub_flow_send_log l ) ID,NOW() SEND_DATE,'Y'  IS_USE)";
            try {
                this.bSqlHelper.updateBysql(ls_sql, new HashMap<String, Object>());
            }
            catch (Exception e) {
                loger.error((Object)e.getMessage());
            }
            List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasMessage.getTodoGreaterThan12H", null);
            List<Map<String, Object>> mobiles = this.bSqlHelper.getMapList("business.hr.HrEmp.getEmpMobileAll", params);
            if (list != null && list.size() > 0) {
                list.forEach(sum -> {
                    String msgContent = "\u60a8\u6709" + sum.get("cou") + "\u6761\u5f85\u529e\u5df2\u8d85\u8fc712\u4e2a\u5c0f\u65f6\u672a\u5904\u7406\uff0c\u8bf7\u53ca\u65f6\u529e\u7406\uff0c\u8c22\u8c22\uff01";
                    SystemMessage.sendMsgRemind(sum.get("accountId").toString(), msgContent);
                    List mobile = mobiles.stream().filter(mo -> mo.get("accountId") != null && mo.get("accountId").toString().equals(sum.get("accountId").toString())).collect(Collectors.toList());
                    if (mobile != null && mobile.size() > 0 && mobile.get(0) != null && ((Map)mobile.get(0)).get("mobilephone") != null) {
                        this.smsManagerService.sendSms(ListUtils.stringToList(((Map)mobile.get(0)).get("mobilephone").toString()), msgContent);
                    }
                });
            }
        }
    }

    public Object PageWorkflowDataSum(String createBy, String msgTitle, String startDate, String endDate, String flowStatus, String bizOrgDept, String cSub, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)createBy)) {
            params.put("createBy", "%" + createBy.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)flowStatus)) {
            params.put("flowStatus", flowStatus);
        }
        if (!StringUtils.isEmpty((String)bizOrgDept)) {
            params.put("bizOrgDept", bizOrgDept);
        }
        if (!StringUtils.isEmpty((String)cSub)) {
            params.put("cSub", cSub);
        } else {
            params.put("cSub", "N");
        }
        if (!StringUtils.isEmpty((String)msgTitle)) {
            params.put("msgTitle", "%" + msgTitle.toUpperCase().replace("%", "/%") + "%");
        }
        return this.bSqlHelper.serachPage("base.BasMessage.PageWorkflowDataSum", params, PageRequest.of((int)page, (int)rows));
    }

    public void delMydealByProcessinstidAll(String processinstids) {
        String[] split;
        if (ObjectUtil.isEmpty((Object)processinstids)) {
            return;
        }
        for (String processinstid : split = processinstids.trim().split(",")) {
            if (ObjectUtil.isEmpty((Object)processinstid)) continue;
            List<BasMessage> list = this.basmessageDao.findByProcessinstidOrderByMsgId(Long.parseLong(processinstid));
            ArrayList<Long> msgIds = new ArrayList<Long>();
            for (BasMessage msg : list) {
                msg.setIsUse("N");
                msgIds.add(msg.getMsgId());
            }
            this.basmessageDao.saveAll(list);
            if (msgIds.isEmpty()) continue;
            Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
            for (String key : map.keySet()) {
                IBasMessageAdditional bma = map.get(key);
                bma.onMessageDel(msgIds, new String[0]);
            }
        }
    }

    public Boolean checkIsThisAccount(String msgId, String accountId, String ... isDeal) {
        String sql;
        List receiveList;
        String isDealP = "N";
        if (isDeal != null && isDeal.length > 0 && isDeal[0] != null && isDeal[0].equals("Y")) {
            isDealP = isDeal[0];
        }
        if ((receiveList = this.sqlHelper.queryByNativeSQL(sql = "SELECT d.*\n  FROM \n       bas_message_receive d\n       left join bas_message b on b.msg_id = d.msg_id\n WHERE  (d.is_deal='" + isDealP + "' or b.msg_type='7' or b.msg_type='3')\n\tand d.msg_id=?1\n and d.ACCOUNT_ID=?2\t\n", new Object[]{msgId, accountId}, BasMessageReceive.class, new int[0])) != null && receiveList.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean checkIsHaveDeal(long msgId) {
        LoginUser user = SysUtils.getLoginUser();
        BasMessageReceive receive = this.basMessageReceiveDao.findByMsgIdAndAccountId(msgId, user.getAccountid());
        if ("Y".equals(receive.getIsDeal())) {
            return true;
        }
        return false;
    }

    public Boolean checkIsHaveNotDeal(String msgId) {
        LoginUser user = SysUtils.getLoginUser();
        BasMessageReceive receive = this.basMessageReceiveDao.findByMsgIdAndAccountId(Long.valueOf(msgId), user.getAccountid());
        if (receive == null) {
            return false;
        }
        if ("N".equals(receive.getIsDeal())) {
            int count = this.bSqlHelper.getIntValue("base.BasMessage.checkIsHaveNotDeal", MapUtil.builder(new HashMap()).put((Object)"msgId", (Object)msgId).put((Object)"accountId", (Object)user.getAccountid()).build());
            if (count > 0) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean checkIsDelete(String msgId) {
        LoginUser user = SysUtils.getLoginUser();
        BasMessage message = this.basmessageDao.findById(Long.valueOf(msgId)).orElse(null);
        BasMessageReceive receive = this.basMessageReceiveDao.findByMsgIdAndAccountId(Long.valueOf(msgId), user.getAccountid());
        if (message == null) {
            return true;
        }
        if (receive == null) {
            JsonMsg msg = this.flowUtilService.judgeIsFlowCreator(user.getAccountid().toString(), message.getProcessinstid().toString());
            if (msg.isSuccess()) {
                return false;
            }
            return true;
        }
        return false;
    }

    public List<BasMessage> findNextStep(String busiMainId, Long processinstid, String formCode, Long msgId) {
        String sql = "SELECT * FROM bas_message t where t.FORM_CODE='" + formCode + "' and t.msg_type = 1 and t.msg_id > " + msgId + " and t.is_use != \"N\" and t.BUSI_MAIN_ID=" + busiMainId + " and t.PROCESSINSTID=" + processinstid + " order by t.MSG_ID desc";
        List list = this.sqlHelper.queryByNativeSQL(sql, BasMessage.class, new int[0]);
        return list;
    }

    public List<Long> getMsgAccount(Long msgId) {
        return this.bSqlHelper.getList("base.BasMessage.getMsgAccount", MapUtil.of((Object)"msgId", (Object)msgId), Long.class);
    }

    public BasMessage getMsgAndReciveId(Long msgId) {
        return this.bSqlHelper.getEntity("base.BasMessage.getMsgAndReciveId", MapUtil.of((Object)"msgId", (Object)msgId), BasMessage.class);
    }

    public Long getDbMsgAndReceiveId(Long processinstid, Long receiveId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processinstid", processinstid);
        params.put("receiveId", receiveId);
        return this.bSqlHelper.getLongValue("base.BasMessage.getDbMsgAndReceiveId", params);
    }
}

