/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasMessageCollapseDao;
import com.guochuang.imp.base.entity.BasMessageCollapse;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class BasMessageCollapseService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageCollapseDao basMessageCollapseDao;
    @Autowired
    private FlowUtilService flowUtilService;

    public PageObject pageAll(String fuzzy, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasMessageCollapse.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            String flowCode = map.get("flowCode").toString();
            String flowName = this.getFlowNameByFlowCode(flowCode);
            if (!ObjectUtils.isEmpty((Object)flowName)) {
                map.put("flowName", flowName);
            }
            String actName = this.flowUtilService.getFlowActList(flowCode).stream().filter(act -> ("," + Objects.toString(map.get("actId")) + ",").contains("," + act.get("ACTIVITYDEFID") + ",")).map(e -> e.get("ACTNAME").toString()).collect(Collectors.joining(","));
            map.put("actName", actName);
            map.put("isCommonText", MemCache.getDicText("IS_OR_NOT", StringUtil.null2String(map.get("isCommon"))));
        }
        return pageObject;
    }

    public String getFlowNameByFlowCode(String flowCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowCode", flowCode);
        Map<String, Object> map = this.bSqlHelper.getMap("base.BasMessageCollapse.getFlowNameByFlowCode", params);
        if (!ObjectUtils.isEmpty(map)) {
            return map.get("flowName").toString();
        }
        return null;
    }

    @Transactional
    public void saveBasMessageCollapse(BasMessageCollapse entity) {
        this.basMessageCollapseDao.save(entity);
    }

    public BasMessageCollapse findBasMessageCollapse(Long id) {
        BasMessageCollapse entity = (BasMessageCollapse)this.basMessageCollapseDao.findById(id).get();
        return entity;
    }

    public void delBasMessageCollapse(Long id) {
        BasMessageCollapse entity = (BasMessageCollapse)this.basMessageCollapseDao.findById(id).get();
        entity.setIsUse("N");
        this.basMessageCollapseDao.save(entity);
    }
}

