/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.LunarCalendar;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasHolidayBackgroudDao;
import com.guochuang.imp.base.dao.BasHolidayDao;
import com.guochuang.imp.base.entity.BasHoliday;
import com.guochuang.imp.base.entity.BasHolidayBackgroud;
import com.guochuang.imp.doc.entity.DocFormFile;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasHolidayBackgroudService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasHolidayDao basHolidayDao;
    @Autowired
    private BasHolidayBackgroudDao basHolidayBackgroudDao;
    @Autowired
    private DocFormFileService docFormFileService;
    private static final String[] festival = new String[]{"0101 \u5143\u65e6\u8282", "0214 \u60c5\u4eba\u8282", "0308 \u5987\u5973\u8282", "0312 \u690d\u6811\u8282", "0401 \u611a\u4eba\u8282", "0501 \u52b3\u52a8\u8282", "0504 \u9752\u5e74\u8282", "0512 \u62a4\u58eb\u8282", "0601 \u513f\u7ae5\u8282", "0701 \u5efa\u515a\u8282", "0801 \u5efa\u519b\u8282", "0910 \u6559\u5e08\u8282", "1001 \u56fd\u5e86\u8282", "1225 \u5723\u8bde\u8282"};
    private static final String[] lfestival = new String[]{"0101 \u6625\u8282", "0115 \u5143\u5bb5\u8282", "0505 \u7aef\u5348\u8282", "0707 \u4e03\u5915\u60c5\u4eba\u8282", "0715 \u4e2d\u5143\u8282", "0815 \u4e2d\u79cb\u8282", "0909 \u91cd\u9633\u8282", "1208 \u814a\u516b\u8282", "1224 \u5c0f\u5e74", "1230 \u9664\u5915"};
    public static final String[] solarTerm = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    public static final String[] wfestival = new String[]{"52 \u6bcd\u4eb2\u8282", "63 \u7236\u4eb2\u8282"};
    private static final long[] LUNAR_INFO = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    public static final String[] sTermInfo = new String[]{"9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c3598082c95f8c965cc920f", "97bd0b06bdb0722c965ce1cfcc920f", "b027097bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c359801ec95f8c965cc920f", "97bd0b06bdb0722c965ce1cfcc920f", "b027097bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c359801ec95f8c965cc920f", "97bd0b06bdb0722c965ce1cfcc920f", "b027097bd097c36b0b6fc9274c91aa", "9778397bd19801ec9210c965cc920e", "97b6b97bd19801ec95f8c965cc920f", "97bd09801d98082c95f8e1cfcc920f", "97bd097bd097c36b0b6fc9210c8dc2", "9778397bd197c36c9210c9274c91aa", "97b6b97bd19801ec95f8c965cc920e", "97bd09801d98082c95f8e1cfcc920f", "97bd097bd097c36b0b6fc9210c8dc2", "9778397bd097c36c9210c9274c91aa", "97b6b97bd19801ec95f8c965cc920e", "97bcf97c3598082c95f8e1cfcc920f", "97bd097bd097c36b0b6fc9210c8dc2", "9778397bd097c36c9210c9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c3598082c95f8c965cc920f", "97bd097bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c3598082c95f8c965cc920f", "97bd097bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c359801ec95f8c965cc920f", "97bd097bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c359801ec95f8c965cc920f", "97bd097bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf97c359801ec95f8c965cc920f", "97bd097bd07f595b0b6fc920fb0722", "9778397bd097c36b0b6fc9210c8dc2", "9778397bd19801ec9210c9274c920e", "97b6b97bd19801ec95f8c965cc920f", "97bd07f5307f595b0b0bc920fb0722", "7f0e397bd097c36b0b6fc9210c8dc2", "9778397bd097c36c9210c9274c920e", "97b6b97bd19801ec95f8c965cc920f", "97bd07f5307f595b0b0bc920fb0722", "7f0e397bd097c36b0b6fc9210c8dc2", "9778397bd097c36c9210c9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bd07f1487f595b0b0bc920fb0722", "7f0e397bd097c36b0b6fc9210c8dc2", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf7f1487f595b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf7f1487f595b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf7f1487f531b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c965cc920e", "97bcf7f1487f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b97bd19801ec9210c9274c920e", "97bcf7f0e47f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "9778397bd097c36b0b6fc9210c91aa", "97b6b97bd197c36c9210c9274c920e", "97bcf7f0e47f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "9778397bd097c36b0b6fc9210c8dc2", "9778397bd097c36c9210c9274c920e", "97b6b7f0e47f531b0723b0b6fb0722", "7f0e37f5307f595b0b0bc920fb0722", "7f0e397bd097c36b0b6fc9210c8dc2", "9778397bd097c36b0b70c9274c91aa", "97b6b7f0e47f531b0723b0b6fb0721", "7f0e37f1487f595b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc9210c8dc2", "9778397bd097c36b0b6fc9274c91aa", "97b6b7f0e47f531b0723b0b6fb0721", "7f0e27f1487f595b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "9778397bd097c36b0b6fc9274c91aa", "97b6b7f0e47f531b0723b0787b0721", "7f0e27f0e47f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "9778397bd097c36b0b6fc9210c91aa", "97b6b7f0e47f149b0723b0787b0721", "7f0e27f0e47f531b0723b0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "9778397bd097c36b0b6fc9210c8dc2", "977837f0e37f149b0723b0787b0721", "7f07e7f0e47f531b0723b0b6fb0722", "7f0e37f5307f595b0b0bc920fb0722", "7f0e397bd097c35b0b6fc9210c8dc2", "977837f0e37f14998082b0787b0721", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e37f1487f595b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc9210c8dc2", "977837f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "977837f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd097c35b0b6fc920fb0722", "977837f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "977837f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "977837f0e37f14998082b0787b06bd", "7f07e7f0e47f149b0723b0787b0721", "7f0e27f0e47f531b0b0bb0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "977837f0e37f14998082b0723b06bd", "7f07e7f0e37f149b0723b0787b0721", "7f0e27f0e47f531b0723b0b6fb0722", "7f0e397bd07f595b0b0bc920fb0722", "977837f0e37f14898082b0723b02d5", "7ec967f0e37f14998082b0787b0721", "7f07e7f0e47f531b0723b0b6fb0722", "7f0e37f1487f595b0b0bb0b6fb0722", "7f0e37f0e37f14898082b0723b02d5", "7ec967f0e37f14998082b0787b0721", "7f07e7f0e47f531b0723b0b6fb0722", "7f0e37f1487f531b0b0bb0b6fb0722", "7f0e37f0e37f14898082b0723b02d5", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e37f1487f531b0b0bb0b6fb0722", "7f0e37f0e37f14898082b072297c35", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e37f0e37f14898082b072297c35", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e37f0e366aa89801eb072297c35", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f149b0723b0787b0721", "7f0e27f1487f531b0b0bb0b6fb0722", "7f0e37f0e366aa89801eb072297c35", "7ec967f0e37f14998082b0723b06bd", "7f07e7f0e47f149b0723b0787b0721", "7f0e27f0e47f531b0723b0b6fb0722", "7f0e37f0e366aa89801eb072297c35", "7ec967f0e37f14998082b0723b06bd", "7f07e7f0e37f14998083b0787b0721", "7f0e27f0e47f531b0723b0b6fb0722", "7f0e37f0e366aa89801eb072297c35", "7ec967f0e37f14898082b0723b02d5", "7f07e7f0e37f14998082b0787b0721", "7f07e7f0e47f531b0723b0b6fb0722", "7f0e36665b66aa89801e9808297c35", "665f67f0e37f14898082b0723b02d5", "7ec967f0e37f14998082b0787b0721", "7f07e7f0e47f531b0723b0b6fb0722", "7f0e36665b66a449801e9808297c35", "665f67f0e37f14898082b0723b02d5", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e36665b66a449801e9808297c35", "665f67f0e37f14898082b072297c35", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e26665b66a449801e9808297c35", "665f67f0e37f1489801eb072297c35", "7ec967f0e37f14998082b0787b06bd", "7f07e7f0e47f531b0723b0b6fb0721", "7f0e27f1487f531b0b0bb0b6fb0722"};

    public PageObject pageAll(String fuzzy, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasHolidayBackgroud.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("isHolidayText", MemCache.getDicText("IS_OR_NOT", StringUtil.null2String(map.get("isHoliday"))));
        }
        return pageObject;
    }

    @Transactional
    public void saveBasHolidayBackgroud(BasHolidayBackgroud entity) {
        this.basHolidayBackgroudDao.save(entity);
    }

    public void saveBasHolidayBackgroud(BasHolidayBackgroud entity, FormFileBean formfile) {
        this.basHolidayBackgroudDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getBackgroudId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public BasHolidayBackgroud findBasHolidayBackgroud(Long id) {
        BasHolidayBackgroud entity = (BasHolidayBackgroud)this.basHolidayBackgroudDao.findById(id).get();
        return entity;
    }

    public void delBasHolidayBackgroud(Long id) {
        BasHolidayBackgroud entity = (BasHolidayBackgroud)this.basHolidayBackgroudDao.findById(id).get();
        entity.setIsUse("N");
        this.basHolidayBackgroudDao.save(entity);
    }

    public void basHolidayCreate() throws GEPSBisException, ParseException {
        Date fesDate;
        SimpleDateFormat dateFormat;
        String fesName;
        Calendar c = Calendar.getInstance();
        int year = c.get(1) + 1;
        for (int i = 0; i < festival.length; ++i) {
            String month = festival[i].substring(0, 2);
            String day = festival[i].substring(2, 4);
            String date = year + "-" + month + "-" + day;
            fesName = festival[i].substring(5);
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            fesDate = dateFormat.parse(date);
            this.createBasHoloday(fesDate, fesName, String.valueOf(year));
        }
        for (int j = 0; j < lfestival.length; ++j) {
            String lunarMonth = lfestival[j].substring(0, 2);
            String lunarDay = lfestival[j].substring(2, 4);
            String lunarDate = year + "-" + lunarMonth + "-" + lunarDay;
            fesName = lfestival[j].substring(5);
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            fesDate = dateFormat.parse(lunarDate);
            int year1 = fesDate.getYear() + 1900;
            int month1 = fesDate.getMonth() + 1;
            int day1 = fesDate.getDate();
            if ("\u9664\u5915".equals(fesName)) {
                day1 = (LUNAR_INFO[fesDate.getYear()] & (long)(65536 >> month1)) == 0L ? 29 : 30;
            }
            int leapMonth = (int)(LUNAR_INFO[fesDate.getYear()] & 0xFL);
            boolean isLeap = false;
            if (leapMonth != 0) {
                isLeap = true;
            }
            int[] solarInfo = LunarCalendar.lunarToSolar(year1, month1, day1, isLeap);
            String date = solarInfo[0] + "-" + solarInfo[1] + "-" + solarInfo[2];
            fesDate = dateFormat.parse(date);
            this.createBasHoloday(fesDate, fesName, String.valueOf(year));
        }
        String sTerm = sTermInfo[year - 1900];
        String[] jieqi = new String[24];
        int p = 0;
        for (int index = 0; index < sTerm.length(); index += 5) {
            int convertedValue = Integer.decode("0x" + sTerm.substring(index, index + 5));
            String chunk = String.valueOf(convertedValue);
            jieqi[p] = String.valueOf(chunk.charAt(0));
            jieqi[p + 1] = chunk.substring(1, 3);
            jieqi[p + 2] = String.valueOf(chunk.charAt(3));
            jieqi[p + 3] = chunk.substring(4, 6);
            p += 4;
        }
        for (int q = 0; q < solarTerm.length; ++q) {
            int k = q / 2;
            String date = year + "-" + (k + 1) + "-" + jieqi[q];
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
            Date fesDate2 = dateFormat2.parse(date);
            this.createBasHoloday(fesDate2, solarTerm[q], String.valueOf(year));
        }
        for (int k = 0; k < wfestival.length; ++k) {
            int wMonth = Integer.parseInt(wfestival[k].substring(0, 1));
            int wDay = Integer.parseInt(wfestival[k].substring(1, 2));
            String fesName2 = wfestival[k].substring(3);
            Calendar t = Calendar.getInstance();
            t.set(1, year);
            t.set(2, wMonth - 1);
            int maxDate = t.getActualMaximum(5);
            int sunDays = 0;
            for (int i = 1; i <= maxDate; ++i) {
                t.set(5, i);
                if (t.get(7) == 1 && ++sunDays == wDay) break;
            }
            String date = new SimpleDateFormat("yyyy-MM-dd").format(t.getTime());
            this.createBasHoloday(t.getTime(), fesName2, String.valueOf(year));
        }
    }

    public void createBasHoloday(Date fesDate, String fesName, String currentYear) {
        List<BasHoliday> basHolidays = this.basHolidayDao.findByHolidayNameAndCurrentYear(fesName, currentYear);
        if (basHolidays == null || basHolidays.size() < 1) {
            BasHoliday entity = new BasHoliday();
            entity.setCurrentYear(currentYear);
            entity.setHolidayName(fesName);
            entity.setHolidayDate(fesDate);
            this.basHolidayDao.save(entity);
        }
    }

    public List<Long> getHolidayBackground() {
        Long id = this.bSqlHelper.getLongValue("base.BasHolidayBackgroud.getCurbackGround", null);
        if (id == null) {
            return Collections.emptyList();
        }
        return this.docFormFileService.findByFormCodeAndPrimaryKey("BasHolidayBackgroud", id.toString()).stream().map(DocFormFile::getFileVersionId).collect(Collectors.toList());
    }
}

